/*!
* @file GameEngine.cpp
* @brief Q[GW̎
* @date 2013/12/17
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "GameEngine.h"


namespace Deeangband
{
	GameEngine::GameEngine()
	{
		gameSurface = new GameSurfaceSDL();
		gameWorld = new GameWorld();
	}

	PLAY_EXIT_CODE GameEngine::PlayLoop(void)
	{
		GAME_COMMAND commandID;
		PLAY_EXIT_CODE code = PLAY_EXIT_NONE;
		gameSurface->Redraw();

		while(code == PLAY_EXIT_NONE)
		{
			commandID = gameSurface->GetCommand();
			code = DoGameCommand(commandID);
		}

		return PLAY_EXIT_QUIT;
	}

	PLAY_EXIT_CODE GameEngine::DoGameCommand(GAME_COMMAND command)
	{
		switch(command)
		{
		case GAME_COMMAND_VIEW_PLAYER_STATUS:
			gameSurface->ViewCreatureStatus(gameWorld->GetCreature(0));
			break;
		case GAME_COMMAND_REDRAW:
			gameSurface->Redraw();
			break;
		case GAME_COMMAND_EXIT:
			return PLAY_EXIT_QUIT;
			break;
		}
		return PLAY_EXIT_NONE;
	}

}
