/*!
* @file Floor.h
* @brief Q[̃_Wƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "GameWorld.h"
#include "GameElement.h"
#include "Square.h"

namespace Deeangband
{

	/*!
	* @class Floor
	* @brief tÃNX
	*/
	class Floor : public GameElement
	{
	private:
		std::vector<std::vector<std::shared_ptr<Square>>> squares;
		std::vector<std::shared_ptr<Door>> doors;
		MAP_LENGTH width; /*!< tẢTCY*/
		MAP_LENGTH height; /*!< tȀcTCY*/

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param fileVersion t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int fileVersion) 
		{
			std::vector<Door>::iterator door = array.begin();
			while(door != array.end())
			{
				archive & BOOST_SERIALIZATION_NVP(door);
				door++;
			}		
			archive & BOOST_SERIALIZATION_NVP(width);
			archive & BOOST_SERIALIZATION_NVP(height);
		}

	public:

		/*! 
		* @brief FloorNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Floor::Floor(ID id, TAG tag, GameWorld *gameWorld);

		Floor::Floor();

		Floor::~Floor();

		/*!
		* @brief tẢTCY𓾂
		* @return tẢTCY
		*/
		MAP_LENGTH Floor::GetWidth(void);

		/*!
		* @brief tȀcTCY𓾂
		* @return tȀcTCY
		*/
		MAP_LENGTH Floor::GetHeight(void);

		/*!
		* @brief tÅYW̃}XԂB
		* @return Y}XCX^X̎Qƃ|C^
		*/
		Square *Floor::GetSquare(MAP_LENGTH x, MAP_LENGTH y);
	};

}