/*!
* @file Floor.cpp
* @brief Q[̃tA`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Floor.h"

namespace Deeangband
{

	Floor::Floor(ID id, TAG tag, GameWorld *gameWorld) : GameElement(id, tag, gameWorld)
	{
		int x, y;
		this->width = 50;
		this->height = 50;

		squares.resize(this->height);
		for(y = 0; y < height; y++)
		{
			for(x = 0; x < width; x++)
			{
				squares[y].push_back(std::shared_ptr<Square>(new Square()));			
			}
		}

		doors.resize(0);
	}

	Floor::Floor()
	{
	}

	Floor::~Floor()
	{
	}

	MAP_LENGTH Floor::GetWidth(void)
	{
		return width;
	}

	MAP_LENGTH Floor::GetHeight(void)
	{
		return height;
	}

	Square *Floor::GetSquare(MAP_LENGTH x, MAP_LENGTH y)
	{
		return &(*(squares[x][y]));
	}

}