/*!
* @file Creature.h
* @brief Q[̃N[`[ƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "BaseStatusTable.h"
#include "Coordinates.h"
#include "Discipline.h"
#include "Effect.h"
#include "Floor.h"
#include "Item.h"
#include "GameElement.h"
#include "SavingTable.h"
#include "Species.h"

BOOST_CLASS_VERSION(Creature, 1);

namespace Deeangband
{

	/*!
	* @class Creature
	* @brief N[`[̃NX
	*/
	class Creature : public GameElement
	{
	private:

		static SOUL soulLevel[CREATURE_MAX_LEVEL]; //!< Kv\Exe[u

		NAME name;      //!< N[`[̖O
		HP currentHp;     //!< ݂HP
		HP maxHp;         //!< ݂̍őHP
		MP currentMp;     //!< ݂MP
		MP maxMp;         //!< ݂̍őMP
		MP maxMaxMp;      //!< {̍őMP
		SOUL currentSoul; //!< ݂̃\El
		SOUL maxSoul;     //!< \Eő哞Bl

		HEIGHT height;    //!< g
		HEIGHT weight;    //!< ̏d

		FEED currentFeed; //!< ݎ{l
		FEED maxFeed;     //!< ő厠{l

		Discipline currentDiscipilne; //!< ݂̏C{l
		LEVEL divineLevel;            //!< _x

		BaseStatusTable currentStatus; //!< ݂̃Xe[^X
		BaseStatusTable maxStatus;     //!< ʏ̃Xe[^X
		BaseStatusTable maxMaxStatus;  //!< ẼXe[^X

		SavingTable savings; //!< Z[rO

		ID floorID;           //!< ݂tAID
		Coordinates position; //!< W
		std::vector<Item> itemList;  //!< ACeXg
		std::map<TAG, SKILL_EXP> skillExpList; //!< XLolXg

		char symbol;       //!< V{L
		Color symbolColor; //!< V{J[
		ID tileID;         //!< ^CID

		ID campID; //!< wcID

		TURN turn; //!< ^[

		HP hpTable[CREATURE_MAX_LEVEL]; //!< qbg_CXɊÂꂽx̊{HP

		/*!
		* @brief N[`[S̏s
		* @return Ȃ
		*/
		void Creature::die(void);

		/*!
		* @brief N[`[̌HP𑝌
		* @param amount HP
		* @return Ȃ
		*/
		void Creature::calcHP(HP amount);

		/*!
		* @brief N[`[̌MP𑝌
		* @param amount MP
		* @return Ȃ
		*/
		void Creature::calcMP(MP amount);

		/*!
		* @brief N[`[̌HPݒ肷
		* @param amount ݒHP
		* @return Ȃ
		*/
		void Creature::setHP(HP amount);

		/*!
		* @brief N[`[̌MPݒ肷
		* @param amount ݒHP
		* @return Ȃ
		*/
		void Creature::setMP(MP amount);

		/*!
		* @brief N[`[tȀWɈړ
		* @param floorID ړtAID
		* @param x ړxW
		* @param y ړyW
		* @return ړłȂꍇ̃G[ID
		*/
		int Creature::move(ID floorID, int x, int y);

		/*!
		* @brief N[`[tȀWɈړ
		* @param floorID ړtAID
		* @param coord ړW
		* @return ړłȂꍇ̃G[ID
		*/
		int Creature::move(ID floorID, Coordinates coord);

		/*!
		* @brief N[`[̃x{HPČvZ
		* @return Ȃ
		*/
		void Creature::calcHPTable(void);

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & BOOST_SERIALIZATION_NVP(name);
				archive & BOOST_SERIALIZATION_NVP(currentHp);
				archive & BOOST_SERIALIZATION_NVP(maxHp);
				archive & BOOST_SERIALIZATION_NVP(hpTable);
				archive & BOOST_SERIALIZATION_NVP(currentMp);
				archive & BOOST_SERIALIZATION_NVP(maxMp);
				archive & BOOST_SERIALIZATION_NVP(maxMaxMp);
				archive & BOOST_SERIALIZATION_NVP(currentSoul);
				archive & BOOST_SERIALIZATION_NVP(maxSoul);
				archive & BOOST_SERIALIZATION_NVP(currentStatus);
				archive & BOOST_SERIALIZATION_NVP(maxStatus);
				archive & BOOST_SERIALIZATION_NVP(maxMaxStatus);
				archive & BOOST_SERIALIZATION_NVP(height);
				archive & BOOST_SERIALIZATION_NVP(weight);
				archive & BOOST_SERIALIZATION_NVP(currentFeed);
				archive & BOOST_SERIALIZATION_NVP(maxFeed);
				archive & BOOST_SERIALIZATION_NVP(savings);
				archive & BOOST_SERIALIZATION_NVP(floorID);
				archive & BOOST_SERIALIZATION_NVP(position);
				archive & BOOST_SERIALIZATION_NVP(itemList);
			}
		}

	public:

		/*! 
		* @brief CreatureNXRXgN^(GameElementoΉ)
		* @param speciesPtr ƂȂN[`[
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Creature::Creature(Species *speciesPtr, ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief CreatureNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Creature::Creature(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief CreatureNXRXgN^
		*/
		Creature::Creature(void);

		/*! 
		* @brief CreatureNXfXgN^
		*/
		Creature::~Creature(void);

		/*! 
		* @brief N[`[ʂɊÂN[`[𐶐
		*/
		void Creature::SetSpeciesData(Species *speciesPtr);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Creature::SetDammyData(void);

		/*!
		* @brief N[`[̖OԂ
		* @return N[`[
		*/
		NAME Creature::GetName(void);

		/*!
		* @brief N[`[ĂԂԂ
		* @return ĂȂtrueԂ
		*/
		bool Creature::IsAlive(void);

		/*!
		* @brief 󂯂ʂ
		* @param effectPtr
		* @param amount
		*/
		bool Creature::TakeEffect(Effect* effectPtr, POWER amount);

		/*! 
		* @brief N[`[̌xԂ
		* @return N[`[̌x
		*/
		LEVEL Creature::GetLevel(void);

		/*!
		* @brief N[`[̌HPԂ
		* @return N[`[̌HP
		*/
		HP Creature::GetCurHP(void);

		/*!
		* @brief N[`[̌őHPԂ
		* @return N[`[̌őHP
		*/
		HP Creature::GetMaxHP(void);

		/*!
		* @brief N[`[̒ʏőHPԂ
		* @return N[`[̒ʏőHP
		*/
		HP Creature::GetNorMaxHP(void);

		/*!
		* @brief N[`[̌MPԂ
		* @return N[`[̌MP
		*/
		MP Creature::GetCurMP(void);

		/*!
		* @brief N[`[̌őMPԂ
		* @return N[`[̌őMP
		*/
		MP Creature::GetMaxMP(void);

		/*!
		* @brief N[`[̒ʏőMPԂ
		* @return N[`[̒ʏőMP
		*/
		MP Creature::GetNorMaxMP(void);

		/*!
		* @brief N[`[̌bZ[rOlԂ
		* @return N[`[̌bZ[rOl
		*/
		AC Creature::GetArmorSaving(void);

		/*!
		* @brief N[`[̌Z[rOlԂ
		* @return N[`[̌Z[rOl
		*/
		EV Creature::GetEvasionSaving(void);

		/*!
		* @brief N[`[̌ӎvZ[rOlԂ
		* @return N[`[̌ӎvZ[rOl
		*/
		VO Creature::GetVolitionSaving(void);

		/*!
		* @brief N[`[݈̌ʒuԂ
		* @return N[`[݈ʒuCoordinates
		*/
		Coordinates *Creature::getCorrdinates(void);

		/*!
		* @brief N[`[̏iXgԂ
		* @return N[`[iXg}bv
		*/
		std::vector<Item> *Creature::getItemList(void);

		/*!
		* @brief N[`[̌\ElԂ
		* @return N[`[̌\El
		*/
		SOUL Creature::GetCurrentSoul(void);

		/*!
		* @brief N[`[̃\Eő哞BlԂ
		* @return N[`[̃\Eő哞Bl
		*/
		SOUL Creature::GetMaxSoul(void);

		/*!
		* @brief N[`[̌b\͒lԂ
		* @param stat 擾b\͒lID
		* @return b\͒ľݒl
		*/
		BASE_STATUS Creature::GetCurrentStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̕b\͒lԂ
		* @param stat 擾\͒lID
		* @return b\͒l̕l
		*/
		BASE_STATUS Creature::GetMaxStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̌Eb\͒lԂ
		* @param stat 擾E\͒lID
		* @return b\͒ľEl
		*/
		BASE_STATUS Creature::GetMaxMAXStatus(CREATURE_STATUS stat);

		/*!
		* @brief N[`[̌ݏC{lԂ
		* @param typ 擾ݏC{lID
		* @return ݏC{l
		*/
		int Creature::GetDiscipilnePoint(DISCIPLINE_TYPE typ);

		/*!
		* @brief N[`[̌ݏC{NԂ
		* @param typ 擾ݏC{NID
		* @return ݏC{N
		*/
		int Creature::GetDiscipilneRank(DISCIPLINE_TYPE typ);

		/*!
		* @brief N[`[̐gԂ
		* @return g
		*/
		HEIGHT Creature::GetHeight(void);

		/*!
		* @brief N[`[̑̏dԂ
		* @return ̏d
		*/
		WEIGHT Creature::GetWeight(void);

		/*!
		* @brief N[`[̑̊ilԂ
		* @return ̊il
		*/
		BODY_SIZE Creature::GetSize(void);

		/*!
		* @brief \El̐VKZ
		* @param plus VKZ\E
		* @return Ȃ
		*/
		void Creature::GainSoul(SOUL plus);

		/*!
		* @brief \El̑r
		* @param amount r\E
		* @return Ȃ
		*/
		void Creature::LostSoul(SOUL amount);

		/*!
		* @brief N[`[̐_xԂ
		* @return _x
		*/
		LEVEL Creature::GetDivineLevel(void);

		/*!
		* @brief ݎ{lԂ
		* @return ݎ{l
		*/
		FEED Creature::GetCurrentFeedPoint(void);

		/*!
		* @brief ő厠{lԂ
		* @return ő厠{l
		*/
		FEED Creature::GetMaxFeedPoint(void);

		/*!
		* @brief N[`[̃^[XVs
		* @return Ȃ
		*/
		void Creature::TurnProcess(void);

		/*!
		* @brief N[`[̃Q[ԍXVs
		* @return Ȃ
		*/
		void Creature::TimeProcess(void);

		/*!
		* @brief N[`[̌oߑ^[Ԃ
		* @return ^[
		*/
		TURN Creature::GetTurn(void);

		/*! 
		* @brief N[`[ʂ̃XL{olԂ
		* @param tag 擾XL̃^O
		* @return YXL̊{olAS̖oȂ0Ԃ
		*/
		SKILL_EXP Creature::GetSkillExp(TAG tag);

		/*!
		* @brief N[`[̏wcIDԂ
		* @return wcID
		*/
		ID Creature::GetCampID(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void Creature::XMLSave(std::string filename);

	};

}