/*!
*  @file Dice.h
*  @brief DiceNXƂ̑tvf̒`
*  @date 2014/01/19
*  @author Deskull
*  2014 Sikabane Works.
*/

#pragma once

#include "Deeangband.h"

namespace Deeangband
{

	/*!
	 * @class Dice
	 * @brief Q[̃_CX
	 * @details
	 * <H1>Tv</H1>
	 * <p>DiceNX̓Q[ɑ݂邠郉_p[^̃CX^XƂȂA̗B
	 * ܂ÓIȃNX֐ł́ABoost(or C++11)ŎꂽZkcCX^ێAڐK󂯎@\B
	 * </p>
	 */
	class Dice
	{
	private:

		int num; //!< _CX̐
		int side; //!< _CX̖ʐ

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Num", num);
				archive & boost::serialization::make_nvp("Side", side);
			}
		}

		template<class Archive> friend void save_construct_data(Archive & archive, const Dice *ptr, const unsigned int version)
		{
			archive & boost::serialization::make_nvp("num", ptr->GetNum());
			archive & boost::serialization::make_nvp("side", ptr->GetSide());
		}

		template<class Archive> friend void load_construct_data(Archive & archive, Dice *ptr, const unsigned int version)
		{
			int n, s;
			archive & boost::serialization::make_nvp("num", n);
			archive & boost::serialization::make_nvp("side", s);
			::new(ptr) Dice(num, side);
		}

	public:

		static std::mt19937 Dice::mt; //!< ZkcCX^ɂ闐GW

		/*!
		 * @brief RXgN^
		 */
		Dice::Dice(void);

		/*!
		 * @brief RXgN^
		 * @param num _CX̐
		 * @param side _CX̖
		 */
		Dice::Dice(int num, int side);

		/*!
		 * @brief fXgN^
		 */
		Dice::~Dice(void);

		/*!
		 * @brief _CX̐lݒsB
		 * @param num _CX̐
		 * @param side _CX̖
		 * @return Ȃ
		 */
		void Dice::Set(int num, int side);

		/*!
		 * @brief ֐
		 * @return Ȃ
		 */
		static void Dice::Initialize(void);

		/*!
		 * @brief _CX̐Ԃ
		 * @return _CX̐
		 */
		int Dice::GetNum(void);

		/*!
		 * @brief _CX̖ʐԂ
		 * @return _CX̖ʐ
		 */
		int Dice::GetSide(void);

		/*!
		 * @brief _CXU
		 * @return _CX̑vl
		 */
		int Dice::Cast(void);

		/*!
		 * @brief _CXU
		 * @param num _CX̐
		 * @param side _CX̖ʐ
		 * @return _CX̑vl
		 */
		static int Dice::Cast(int num, int side);

		/*!
		 * @brief KU
		 * @param ave 
		 * @param dic U
		 * @return l
		 */
		static int Dice::CastNormalRand(int ave, int div);

		/*!
		 * @brief _CX̎蓾őlԂ
		 * @return _CX̍ől
		 */
		int Dice::MaxCast(void);

		/*!
		 * @brief _CX̎蓾őlԂ
		 * @param num _CX̐
		 * @param side _CX̖ʐ
		 * @return _CX̍ől
		 */
		static int Dice::MaxCast(int num, int side);

		/*!
		 * @brief 0ŏlƂԂ
		 * @param max ͈̔(0`max-1)
		 * @return ̒l
		 */
		static int Dice::Rand0(int max);

		/*!
		 * @brief 1ŏlƂԂ
		 * @param max ̍ől(1`max)
		 * @return ̒l
		 */
		static int Dice::Rand1(int max);

		/*!
		 * @brief Z[rO
		 * @param diff Z[rOx-Z[rOl
		 * @return Z[rOȂ true ԂB
		 */
		static bool Dice::Saving(int diff);

	};

}

BOOST_CLASS_VERSION(Deeangband::Dice, 10);
