/*!
* @file BaseStatusTable.h
* @brief b\͒lNX̃vg^Cv
* @date 2014/03/05
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

namespace Deeangband
{

	/*!
	* @class BaseStatusTable
	* @brief {Xe[^XNX
	*/
	class BaseStatusTable
	{
	private:

		BASE_STATUS status[CS_MAX]; /*!<Xe[^X*/

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version > 0)
			{
				archive & boost::serialization::make_nvp("STR", status[0]);
				archive & boost::serialization::make_nvp("INT", status[1]);
				archive & boost::serialization::make_nvp("WIS", status[2]);
				archive & boost::serialization::make_nvp("DEX", status[3]);
				archive & boost::serialization::make_nvp("CON", status[4]);
				archive & boost::serialization::make_nvp("CHA", status[5]);
			}
		}

	public:

		/*! 
		* @brief BaseStatusTableRXgN^
		* @param status Xe[^Xle[u
		*/
		BaseStatusTable::BaseStatusTable(BASE_STATUS status[CS_MAX]);

		/*! 
		* @brief BaseStatusTableRXgN^
		* @param bStr r
		* @param bInt m
		* @param bWis 
		* @param bDex p
		* @param bCon ϋv
		* @param bCha 
		*/
		BaseStatusTable::BaseStatusTable(BASE_STATUS bStr, BASE_STATUS bInt, BASE_STATUS bWis, BASE_STATUS bDex, BASE_STATUS bCon, BASE_STATUS bCha);

		/*! 
		* @brief BaseStatusTablefXgN^
		*/
		BaseStatusTable::BaseStatusTable(void);

		/*! 
		* @brief BaseStatusTablefXgN^
		*/
		BaseStatusTable::~BaseStatusTable(void);

		/*! 
		* @brief \͒l̒l𓾂B
		* @param typ \͒lID
		*/
		const BASE_STATUS BaseStatusTable::Get(CREATURE_STATUS typ);

		/*! 
		* @brief S\͒l܂Ƃ߂ăZbgB
		* @param status Xe[^Xle[u
		* @return Ȃ
		*/
		void BaseStatusTable::Set(BASE_STATUS status[CS_MAX]);

		/*! 
		* @brief S\͒l܂Ƃ߂ăZbgB
		* @param bStr r
		* @param bInt m
		* @param bWis 
		* @param bDex p
		* @param bCon ϋv
		* @param bCha 
		* @return Ȃ
		*/
		void BaseStatusTable::Set(BASE_STATUS bStr, BASE_STATUS bInt, BASE_STATUS bWis, BASE_STATUS bDex, BASE_STATUS bCon, BASE_STATUS bCha);

		/*!
		* @brief +ZqɂWZ
		* @param plus Z
		*/
		BaseStatusTable BaseStatusTable::operator+(const BaseStatusTable& plus);  

		/*!
		* @brief +=ZqɂWZ
		* @param plus Z
		*/
		BaseStatusTable& BaseStatusTable::operator+=(const BaseStatusTable& plus);

	};

}


BOOST_CLASS_VERSION(Deeangband::BaseStatusTable, 10);
