/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser.ast;

import zigen.sql.parser.ASTVisitor;
import zigen.sql.parser.Node;

public class ASTTarget
extends Node {
    private String schemaName;
    private String createName;

    public ASTTarget(String plsqlName, int offset, int length, int scope) {
        super(plsqlName, offset, length, scope);
        this.parse(plsqlName);
    }

    private void parse(String tableName) {
        String[] strs = tableName.split("[.]");
        if (strs.length == 2) {
            this.schemaName = strs[0];
            this.createName = strs[1];
        } else if (strs.length == 1) {
            this.createName = strs[0];
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.schemaName != null) {
            sb.append(this.schemaName);
            sb.append(".");
        }
        if (this.createName != null) {
            sb.append(this.createName);
        }
        return String.valueOf(this.getNodeClassName()) + " text=\"" + sb.toString() + "\"";
    }

    public Object accept(ASTVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCreateName() {
        return this.createName;
    }
}

