package daruma.client.darumaviewer.views;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.*;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.service.DaRuMaClientAgent;
import daruma.client.darumaviewer.views.SwtUtil.FileButtonListener;

/**
 * ダミービュー レイアウトを確保するために 使用する
 */
public class RunCommandView extends ViewPart {
	private DaRuMaServer currServer;

	private Label lblSts;

	private TabFolder tabFolder;

	private Text txtServer;

	private TabItem tabDaRuMaClient;

	private Text txtDaRuMaClientInFile;

	private Text txtDaRuMaClientOutFile;

	private Button btnDaRuMaClientInFile;

	private Button btnDaRuMaClientOutFile;

	private Button chkDaRuMaClientAddSoapHeader;

	private Button chkDaRuMaClientDelSoapHeader;

	private Button chkDaRuMaClientConsole;
	
	private Button chkDCMakebatFile;
	
	private Text txtDCCmdBatFile;
	
	private Button btnDCCmdBatFile;
	
	private Button chkDCViewCommand;

	private TabItem tabRegisterFeatureType;

	private Text txtRegisterFeatureTypeInFile;

	private Text txtRegisterFeatureTypeOutFile;

	private Button btnRegisterFeatureTypeInFile;

	private Button btnRegisterFeatureTypeOutFile;

	private Button chkRegisterFeatureTypeConsole;

	private Button chkRFMakebatFile;
	
	private Text txtRFCmdBatFile;
	
	private Button btnRFCmdBatFile;
	
	private Button chkRFViewCommand;
	
	private TabItem tabXmlInsert;

	private Text txtXmlInsertInFile;

	private Text txtXmlInsertOutFile;

	private Button btnXmlInsertInFile;

	private Button btnXmlInsertOutFile;

	private Button chkXmlInsertConsole;
	
	private Button chkXIMakebatFile;
	
	private Text txtXICmdBatFile;
	
	private Button btnXICmdBatFile;
	
	private Button chkXIViewCommand;

	private TabItem tabCsvInsert;

	private Text txtCsvInsertInFile;

	private Text txtCsvInsertCsvCfgFile;

	private Text txtCsvInsertOutFile;

	private Button btnCsvInsertInFile;

	private Button btnCsvInsertCsvCfgFile;

	private Button btnCsvInsertOutFile;

	private Button chkCsvInsertConsole;

	private Combo cmbCsvInsertEncode;

	private Text txtCsvInsertAttatchedFileDir;

	private Button btnCsvInsertAttatchedFileDir;
	
	private Button chkCIMakebatFile;
	
	private Text txtCICmdBatFile;
	
	private Button btnCICmdBatFile;
	
	private Button chkCIViewCommand;

	private TabItem tabXmlGetFeature;

	private Text txtXmlGetFeatureInFeatureType;

	private Text txtXmlGetFeatureInFile;

	private Button chkXmlGetFeature;

	private Text txtXmlGetFeatureOutFile;

	private Button btnXmlGetFeatureInFile;

	private Button btnXmlGetFeatureOutFile;

	private Button chkXmlGetFeatureConsole;
	
	private Button chkXGMakebatFile;
	
	private Text txtXGCmdBatFile;
	
	private Button btnXGCmdBatFile;
	
	private Button chkXGViewCommand;
	
	private TabItem tabCsvGetFeature;

	private Text txtCsvGetFeatureInFeatureType;

	private Text txtCsvGetFeatureInFile;

	private Text txtCsvGetFeatureCsvCfgFile;

	private Button btnCsvGetFeatureCsvCfgFile;

	private Text txtCsvGetFeatureAttatchedFileDir;

	private Button btnCsvGetFeatureAttatchedFileDir;

	private Combo cmbCsvGetFeatureEncode;

	private Button chkCsvGetFeature;

	private Text txtCsvGetFeatureOutFile;

	private Button btnCsvGetFeatureInFile;

	private Button btnCsvGetFeatureOutFile;

	private Button chkCsvGetFeatureConsole;
	
	private Button chkCGMakebatFile;
	
	private Text txtCGCmdBatFile;
	
	private Button btnCGCmdBatFile;
	
	private Button chkCGViewCommand;

	private Button btnRun;
	
	RunCommandViewSelectionListener listener;

	/**
	 * ビューID
	 */
	public static final String ID = RunCommandView.class.getName();

	/**
	 * ビューの画面を作成する
	 * 
	 * @param parent
	 *            親Composite
	 */
	public void createPartControl(Composite parent) {
		int colNum = 2;
		listener = new RunCommandViewSelectionListener();

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("RunCommandView.0")); //$NON-NLS-1$
		txtServer = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		txtServer.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum - 1));

		tabFolder = new TabFolder(parent, SWT.NULL);
		tabFolder.setLayoutData(SwtUtil.makeVarGridData(500, 100, colNum));
		Composite compTab;

		tabDaRuMaClient = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabDaRuMaClient.setText(Messages.getString("RunCommandView.13")); //$NON-NLS-1$
		tabDaRuMaClient.setControl(compTab);
		setupDaRuMaClient(compTab);

		tabRegisterFeatureType = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabRegisterFeatureType.setText(Messages.getString("RunCommandView.14")); //$NON-NLS-1$
		tabRegisterFeatureType.setControl(compTab);
		setupRegisterFeatureType(compTab);

		tabXmlInsert = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabXmlInsert.setText(Messages.getString("RunCommandView.28")); //$NON-NLS-1$
		tabXmlInsert.setControl(compTab);
		setupXmlInsert(compTab);

		tabCsvInsert = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabCsvInsert.setText(Messages.getString("RunCommandView.29")); //$NON-NLS-1$
		tabCsvInsert.setControl(compTab);
		setupCsvInsert(compTab);

		tabXmlGetFeature = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabXmlGetFeature.setText(Messages.getString("RunCommandView.30")); //$NON-NLS-1$
		tabXmlGetFeature.setControl(compTab);
		setupXmlGetFeature(compTab);

		tabCsvGetFeature = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabCsvGetFeature.setText(Messages.getString("RunCommandView.31")); //$NON-NLS-1$
		tabCsvGetFeature.setControl(compTab);
		setupCsvGetFeature(compTab);

		btnRun = new Button(parent, SWT.NULL);
		btnRun.setText(Messages.getString("RunCommandView.7")); //$NON-NLS-1$
		lblSts = new Label(parent, SWT.NULL);
		lblSts.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		btnRun.addSelectionListener(listener);
		
		validateOut();
	}

	private void setupDaRuMaClient(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.15")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.1")); //$NON-NLS-1$
		txtDaRuMaClientInFile = new Text(grpIn, SWT.BORDER);
		txtDaRuMaClientInFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtDaRuMaClientInFile.setToolTipText(Messages
				.getString("RunCommandView.16")); //$NON-NLS-1$
		btnDaRuMaClientInFile = new Button(grpIn, SWT.NULL);
		btnDaRuMaClientInFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnDaRuMaClientInFile.addSelectionListener(new FileButtonListener(
				txtDaRuMaClientInFile));
		chkDaRuMaClientAddSoapHeader = new Button(grpIn, SWT.CHECK);
		chkDaRuMaClientAddSoapHeader.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkDaRuMaClientAddSoapHeader.setText(Messages
				.getString("RunCommandView.3")); //$NON-NLS-1$

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.17")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkDaRuMaClientConsole = new Button(grpOut, SWT.CHECK);
		chkDaRuMaClientConsole.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				grpColNum));
		chkDaRuMaClientConsole.setText(Messages.getString("RunCommandView.18")); //$NON-NLS-1$
		chkDaRuMaClientConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtDaRuMaClientOutFile = new Text(grpOut, SWT.BORDER);
		txtDaRuMaClientOutFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtDaRuMaClientOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnDaRuMaClientOutFile = new Button(grpOut, SWT.NULL);
		btnDaRuMaClientOutFile.setText(Messages.getString("RunCommandView.5")); //$NON-NLS-1$
		btnDaRuMaClientOutFile.addSelectionListener(new FileButtonListener(
				txtDaRuMaClientOutFile));

		chkDaRuMaClientDelSoapHeader = new Button(grpOut, SWT.CHECK);
		chkDaRuMaClientDelSoapHeader.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkDaRuMaClientDelSoapHeader.setText(Messages
				.getString("RunCommandView.6")); //$NON-NLS-1$

		
//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkDCMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkDCMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkDCMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkDCMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtDCCmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtDCCmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtDCCmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnDCCmdBatFile = new Button(grpCmd, SWT.NULL);
		btnDCCmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnDCCmdBatFile.addSelectionListener(new FileButtonListener(
				txtDCCmdBatFile));
		
		chkDCViewCommand = new Button(grpCmd, SWT.CHECK);
		chkDCViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkDCViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$
		
		SwtUtil.TextDropTargetListener
		.makeTextDropTargetListener(txtDaRuMaClientInFile);
		SwtUtil.TextDropTargetListener
		.makeTextDropTargetListener(txtDaRuMaClientOutFile);
		SwtUtil.TextDropTargetListener
		.makeTextDropTargetListener(txtDCCmdBatFile);

		chkDaRuMaClientAddSoapHeader.setSelection(true);
		chkDaRuMaClientDelSoapHeader.setSelection(false);
		chkDaRuMaClientConsole.setSelection(true);
		chkDCMakebatFile.setSelection(false);
		chkDCViewCommand.setSelection(false);
	}

	private void setupRegisterFeatureType(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.20")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.22")); //$NON-NLS-1$
		txtRegisterFeatureTypeInFile = new Text(grpIn, SWT.BORDER);
		txtRegisterFeatureTypeInFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 1));
		txtRegisterFeatureTypeInFile.setToolTipText(Messages
				.getString("RunCommandView.21")); //$NON-NLS-1$
		btnRegisterFeatureTypeInFile = new Button(grpIn, SWT.NULL);
		btnRegisterFeatureTypeInFile.setText(Messages
				.getString("RunCommandView.2")); //$NON-NLS-1$
		btnRegisterFeatureTypeInFile
				.addSelectionListener(new FileButtonListener(
						txtRegisterFeatureTypeInFile));

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.23")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkRegisterFeatureTypeConsole = new Button(grpOut, SWT.CHECK);
		chkRegisterFeatureTypeConsole.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkRegisterFeatureTypeConsole.setText(Messages
				.getString("RunCommandView.24")); //$NON-NLS-1$
		chkRegisterFeatureTypeConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtRegisterFeatureTypeOutFile = new Text(grpOut, SWT.BORDER);
		txtRegisterFeatureTypeOutFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 1));
		txtRegisterFeatureTypeOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnRegisterFeatureTypeOutFile = new Button(grpOut, SWT.NULL);
		btnRegisterFeatureTypeOutFile.setText(Messages
				.getString("RunCommandView.5")); //$NON-NLS-1$
		btnRegisterFeatureTypeOutFile
				.addSelectionListener(new FileButtonListener(
						txtRegisterFeatureTypeOutFile));
//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkRFMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkRFMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkRFMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkRFMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtRFCmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtRFCmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtRFCmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnRFCmdBatFile = new Button(grpCmd, SWT.NULL);
		btnRFCmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnRFCmdBatFile.addSelectionListener(new FileButtonListener(
				txtRFCmdBatFile));
		
		chkRFViewCommand = new Button(grpCmd, SWT.CHECK);
		chkRFViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkRFViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$
		
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtRegisterFeatureTypeInFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtRegisterFeatureTypeOutFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtRFCmdBatFile);

		chkRegisterFeatureTypeConsole.setSelection(true);
		chkRFMakebatFile.setSelection(false);
		chkRFViewCommand.setSelection(false);
	}

	private void setupXmlInsert(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.20")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.32")); //$NON-NLS-1$
		txtXmlInsertInFile = new Text(grpIn, SWT.BORDER);
		txtXmlInsertInFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		txtXmlInsertInFile.setToolTipText(Messages
				.getString("RunCommandView.33")); //$NON-NLS-1$
		btnXmlInsertInFile = new Button(grpIn, SWT.NULL);
		btnXmlInsertInFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnXmlInsertInFile.addSelectionListener(new FileButtonListener(
				txtXmlInsertInFile));

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.23")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkXmlInsertConsole = new Button(grpOut, SWT.CHECK);
		chkXmlInsertConsole.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				grpColNum));
		chkXmlInsertConsole.setText(Messages.getString("RunCommandView.24")); //$NON-NLS-1$
		chkXmlInsertConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtXmlInsertOutFile = new Text(grpOut, SWT.BORDER);
		txtXmlInsertOutFile
				.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		txtXmlInsertOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnXmlInsertOutFile = new Button(grpOut, SWT.NULL);
		btnXmlInsertOutFile.setText(Messages.getString("RunCommandView.5")); //$NON-NLS-1$
		btnXmlInsertOutFile.addSelectionListener(new FileButtonListener(
				txtXmlInsertOutFile));

//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkXIMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkXIMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkXIMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkXIMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtXICmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtXICmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtXICmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnXICmdBatFile = new Button(grpCmd, SWT.NULL);
		btnXICmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnXICmdBatFile.addSelectionListener(new FileButtonListener(
				txtXICmdBatFile));
		
		chkXIViewCommand = new Button(grpCmd, SWT.CHECK);
		chkXIViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkXIViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$
		
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXmlInsertInFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXmlInsertOutFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXICmdBatFile);

		chkXmlInsertConsole.setSelection(true);
		chkXIMakebatFile.setSelection(false);
		chkXIViewCommand.setSelection(false);
	}

	private void setupCsvInsert(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.20")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.34")); //$NON-NLS-1$
		txtCsvInsertInFile = new Text(grpIn, SWT.BORDER);
		txtCsvInsertInFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		txtCsvInsertInFile.setToolTipText(Messages
				.getString("RunCommandView.35")); //$NON-NLS-1$
		btnCsvInsertInFile = new Button(grpIn, SWT.NULL);
		btnCsvInsertInFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvInsertInFile.addSelectionListener(new FileButtonListener(
				txtCsvInsertInFile));

		new Label(grpIn, SWT.NULL).setText(Messages.getString("RunCommandView.69")); //$NON-NLS-1$
		cmbCsvInsertEncode = new Combo(grpIn, SWT.READ_ONLY);
		cmbCsvInsertEncode.setLayoutData(SwtUtil.makeFixedGridData(100, 0, 1));
		setupEncode(cmbCsvInsertEncode);
		new Label(grpIn, SWT.NULL).setText(""); //$NON-NLS-1$

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.36")); //$NON-NLS-1$
		txtCsvInsertCsvCfgFile = new Text(grpIn, SWT.BORDER);
		txtCsvInsertCsvCfgFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtCsvInsertCsvCfgFile.setToolTipText(Messages
				.getString("RunCommandView.37")); //$NON-NLS-1$
		btnCsvInsertCsvCfgFile = new Button(grpIn, SWT.NULL);
		btnCsvInsertCsvCfgFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvInsertCsvCfgFile.addSelectionListener(new FileButtonListener(
				txtCsvInsertCsvCfgFile));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.65")); //$NON-NLS-1$
		txtCsvInsertAttatchedFileDir = new Text(grpIn, SWT.BORDER);
		txtCsvInsertAttatchedFileDir.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 1));
		txtCsvInsertAttatchedFileDir.setToolTipText(Messages
				.getString("RunCommandView.66")); //$NON-NLS-1$
		btnCsvInsertAttatchedFileDir = new Button(grpIn, SWT.NULL);
		btnCsvInsertAttatchedFileDir.setText(Messages
				.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvInsertAttatchedFileDir
				.addSelectionListener(new SwtUtil.DirectoryButtonListener(
						txtCsvInsertAttatchedFileDir));

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.23")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkCsvInsertConsole = new Button(grpOut, SWT.CHECK);
		chkCsvInsertConsole.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				grpColNum));
		chkCsvInsertConsole.setText(Messages.getString("RunCommandView.24")); //$NON-NLS-1$
		chkCsvInsertConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtCsvInsertOutFile = new Text(grpOut, SWT.BORDER);
		txtCsvInsertOutFile
				.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		txtCsvInsertOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnCsvInsertOutFile = new Button(grpOut, SWT.NULL);
		btnCsvInsertOutFile.setText(Messages.getString("RunCommandView.5")); //$NON-NLS-1$
		btnCsvInsertOutFile.addSelectionListener(new FileButtonListener(
				txtCsvInsertOutFile));
		
//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkCIMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkCIMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkCIMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkCIMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtCICmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtCICmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtCICmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnCICmdBatFile = new Button(grpCmd, SWT.NULL);
		btnCICmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCICmdBatFile.addSelectionListener(new FileButtonListener(
				txtCICmdBatFile));
		
		chkCIViewCommand = new Button(grpCmd, SWT.CHECK);
		chkCIViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkCIViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$

		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvInsertInFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvInsertCsvCfgFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvInsertOutFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvInsertAttatchedFileDir);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCICmdBatFile);

		chkCsvInsertConsole.setSelection(true);
		chkCIMakebatFile.setSelection(false);
		chkCIViewCommand.setSelection(false);
	}

	private void setupEncode(Combo cmb) {
		cmb.add("UTF-8"); //$NON-NLS-1$
		cmb.add("Shift_JIS"); //$NON-NLS-1$
		cmb.add("EUC-JP"); //$NON-NLS-1$
		cmb.setText("UTF-8"); //$NON-NLS-1$
	}

	private void setupXmlGetFeature(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.20")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkXmlGetFeature = new Button(grpIn, SWT.CHECK);
		chkXmlGetFeature.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				grpColNum));
		chkXmlGetFeature.setText(Messages.getString("RunCommandView.38")); //$NON-NLS-1$
		chkXmlGetFeature.addSelectionListener(listener);

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.39")); //$NON-NLS-1$
		txtXmlGetFeatureInFeatureType = new Text(grpIn, SWT.BORDER);
		txtXmlGetFeatureInFeatureType.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 2));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.40")); //$NON-NLS-1$
		txtXmlGetFeatureInFile = new Text(grpIn, SWT.BORDER);
		txtXmlGetFeatureInFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtXmlGetFeatureInFile.setToolTipText(Messages
				.getString("RunCommandView.41")); //$NON-NLS-1$
		btnXmlGetFeatureInFile = new Button(grpIn, SWT.NULL);
		btnXmlGetFeatureInFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnXmlGetFeatureInFile.addSelectionListener(new FileButtonListener(
				txtXmlGetFeatureInFile));

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.23")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkXmlGetFeatureConsole = new Button(grpOut, SWT.CHECK);
		chkXmlGetFeatureConsole.setLayoutData(SwtUtil.makeHorVarGridData(100,
				0, grpColNum));
		chkXmlGetFeatureConsole
				.setText(Messages.getString("RunCommandView.24")); //$NON-NLS-1$
		chkXmlGetFeatureConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtXmlGetFeatureOutFile = new Text(grpOut, SWT.BORDER);
		txtXmlGetFeatureOutFile.setLayoutData(SwtUtil.makeHorVarGridData(100,
				0, 1));
		txtXmlGetFeatureOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnXmlGetFeatureOutFile = new Button(grpOut, SWT.NULL);
		btnXmlGetFeatureOutFile.setText(Messages.getString("RunCommandView.5")); //$NON-NLS-1$
		btnXmlGetFeatureOutFile.addSelectionListener(new FileButtonListener(
				txtXmlGetFeatureOutFile));
		
//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkXGMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkXGMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkXGMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkXGMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtXGCmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtXGCmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtXGCmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnXGCmdBatFile = new Button(grpCmd, SWT.NULL);
		btnXGCmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnXGCmdBatFile.addSelectionListener(new FileButtonListener(
				txtXGCmdBatFile));
		
		chkXGViewCommand = new Button(grpCmd, SWT.CHECK);
		chkXGViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkXGViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$

		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXmlGetFeatureInFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXmlGetFeatureOutFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtXGCmdBatFile);

		chkXmlGetFeature.setSelection(true);
		chkXmlGetFeatureConsole.setSelection(true);
		chkXGMakebatFile.setSelection(false);
		chkXGViewCommand.setSelection(false);
	}

	private void setupCsvGetFeature(Composite parent) {
		int colNum = 2;
		int grpColNum = 3;

		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		Group grpIn = new Group(parent, SWT.NULL);
		grpIn.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpIn.setText(Messages.getString("RunCommandView.20")); //$NON-NLS-1$
		grpIn.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkCsvGetFeature = new Button(grpIn, SWT.CHECK);
		chkCsvGetFeature.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				grpColNum));
		chkCsvGetFeature.setText(Messages.getString("RunCommandView.42")); //$NON-NLS-1$
		chkCsvGetFeature.addSelectionListener(listener);

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.43")); //$NON-NLS-1$
		txtCsvGetFeatureInFeatureType = new Text(grpIn, SWT.BORDER);
		txtCsvGetFeatureInFeatureType.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 2));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.44")); //$NON-NLS-1$
		txtCsvGetFeatureInFile = new Text(grpIn, SWT.BORDER);
		txtCsvGetFeatureInFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtCsvGetFeatureInFile.setToolTipText(Messages
				.getString("RunCommandView.45")); //$NON-NLS-1$
		btnCsvGetFeatureInFile = new Button(grpIn, SWT.NULL);
		btnCsvGetFeatureInFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvGetFeatureInFile.addSelectionListener(new FileButtonListener(
				txtCsvGetFeatureInFile));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.46")); //$NON-NLS-1$
		txtCsvGetFeatureCsvCfgFile = new Text(grpIn, SWT.BORDER);
		txtCsvGetFeatureCsvCfgFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, 1));
		txtCsvGetFeatureCsvCfgFile.setToolTipText(Messages
				.getString("RunCommandView.47")); //$NON-NLS-1$
		btnCsvGetFeatureCsvCfgFile = new Button(grpIn, SWT.NULL);
		btnCsvGetFeatureCsvCfgFile.setText(Messages
				.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvGetFeatureCsvCfgFile.addSelectionListener(new FileButtonListener(
				txtCsvGetFeatureCsvCfgFile));

		new Label(grpIn, SWT.NULL).setText(Messages
				.getString("RunCommandView.67")); //$NON-NLS-1$
		txtCsvGetFeatureAttatchedFileDir = new Text(grpIn, SWT.BORDER);
		txtCsvGetFeatureAttatchedFileDir.setLayoutData(SwtUtil
				.makeHorVarGridData(100, 0, 1));
		txtCsvGetFeatureAttatchedFileDir.setToolTipText(Messages
				.getString("RunCommandView.68")); //$NON-NLS-1$
		btnCsvGetFeatureAttatchedFileDir = new Button(grpIn, SWT.NULL);
		btnCsvGetFeatureAttatchedFileDir.setText(Messages
				.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCsvGetFeatureAttatchedFileDir
				.addSelectionListener(new SwtUtil.DirectoryButtonListener(
						txtCsvGetFeatureAttatchedFileDir));

		Group grpOut = new Group(parent, SWT.NULL);
		grpOut.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpOut.setText(Messages.getString("RunCommandView.23")); //$NON-NLS-1$
		grpOut.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkCsvGetFeatureConsole = new Button(grpOut, SWT.CHECK);
		chkCsvGetFeatureConsole.setLayoutData(SwtUtil.makeHorVarGridData(100,
				0, grpColNum));
		chkCsvGetFeatureConsole
				.setText(Messages.getString("RunCommandView.24")); //$NON-NLS-1$
		chkCsvGetFeatureConsole.addSelectionListener(listener);

		new Label(grpOut, SWT.NULL).setText(Messages
				.getString("RunCommandView.4")); //$NON-NLS-1$
		txtCsvGetFeatureOutFile = new Text(grpOut, SWT.BORDER);
		txtCsvGetFeatureOutFile.setLayoutData(SwtUtil.makeHorVarGridData(100,
				0, 1));
		txtCsvGetFeatureOutFile.setToolTipText(Messages
				.getString("RunCommandView.19")); //$NON-NLS-1$
		btnCsvGetFeatureOutFile = new Button(grpOut, SWT.NULL);
		btnCsvGetFeatureOutFile.setText(Messages.getString("RunCommandView.5")); //$NON-NLS-1$
		btnCsvGetFeatureOutFile.addSelectionListener(new FileButtonListener(
				txtCsvGetFeatureOutFile));

		new Label(grpOut, SWT.NULL).setText(Messages.getString("RunCommandView.75")); //$NON-NLS-1$
		cmbCsvGetFeatureEncode = new Combo(grpOut, SWT.READ_ONLY);
		cmbCsvGetFeatureEncode.setLayoutData(SwtUtil.makeFixedGridData(100, 0,
				1));
		setupEncode(cmbCsvGetFeatureEncode);
		new Label(grpOut, SWT.NULL).setText(""); //$NON-NLS-1$
		
//		追加　2007,1,21
		Group grpCmd = new Group(parent, SWT.NULL);
		grpCmd.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
		grpCmd.setText(Messages.getString("RunCommandView.73")); //$NON-NLS-1$
		grpCmd.setLayout(SwtUtil.makeGridLayout(grpColNum));

		chkCGMakebatFile = new Button(grpCmd, SWT.CHECK);
		chkCGMakebatFile.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkCGMakebatFile.setText(Messages
				.getString("RunCommandView.70")); //$NON-NLS-1$
		chkCGMakebatFile.addSelectionListener(listener);
		
		new Label(grpCmd, SWT.NULL).setText(Messages
				.getString("RunCommandView.72")); //$NON-NLS-1$
		
		txtCGCmdBatFile = new Text(grpCmd, SWT.BORDER);
		txtCGCmdBatFile.setLayoutData(SwtUtil.makeHorVarGridData(100, 0,
				1));
		txtCGCmdBatFile.setToolTipText(Messages
				.getString("RunCommandView.74")); //$NON-NLS-1$
		btnCGCmdBatFile = new Button(grpCmd, SWT.NULL);
		btnCGCmdBatFile.setText(Messages.getString("RunCommandView.2")); //$NON-NLS-1$
		btnCGCmdBatFile.addSelectionListener(new FileButtonListener(
				txtCGCmdBatFile));
		
		chkCGViewCommand = new Button(grpCmd, SWT.CHECK);
		chkCGViewCommand.setLayoutData(SwtUtil.makeHorVarGridData(
				100, 0, grpColNum));
		chkCGViewCommand.setText(Messages
				.getString("RunCommandView.71")); //$NON-NLS-1$

		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvGetFeatureInFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvGetFeatureCsvCfgFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvGetFeatureOutFile);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCsvGetFeatureAttatchedFileDir);
		SwtUtil.TextDropTargetListener
				.makeTextDropTargetListener(txtCGCmdBatFile);

		chkCsvGetFeature.setSelection(true);
		chkCsvGetFeatureConsole.setSelection(true);
		chkCGMakebatFile.setSelection(false);
		chkCGViewCommand.setSelection(false);
	}

	private void validateOut() {
		boolean enable;

		enable = !chkDaRuMaClientConsole.getSelection();
		txtDaRuMaClientOutFile.setEnabled(enable);
		btnDaRuMaClientOutFile.setEnabled(enable);

		enable = !chkRegisterFeatureTypeConsole.getSelection();
		txtRegisterFeatureTypeOutFile.setEnabled(enable);
		btnRegisterFeatureTypeOutFile.setEnabled(enable);

		enable = !chkXmlInsertConsole.getSelection();
		txtXmlInsertOutFile.setEnabled(enable);
		btnXmlInsertOutFile.setEnabled(enable);

		enable = !chkCsvInsertConsole.getSelection();
		txtCsvInsertOutFile.setEnabled(enable);
		btnCsvInsertOutFile.setEnabled(enable);

		enable = !chkXmlGetFeatureConsole.getSelection();
		txtXmlGetFeatureOutFile.setEnabled(enable);
		btnXmlGetFeatureOutFile.setEnabled(enable);

		enable = !chkXmlGetFeature.getSelection();
		txtXmlGetFeatureInFile.setEnabled(enable);
		btnXmlGetFeatureInFile.setEnabled(enable);
		txtXmlGetFeatureInFeatureType.setEnabled(!enable);

		enable = !chkCsvGetFeatureConsole.getSelection();
		txtCsvGetFeatureOutFile.setEnabled(enable);
		btnCsvGetFeatureOutFile.setEnabled(enable);

		enable = !chkCsvGetFeature.getSelection();
		txtCsvGetFeatureInFile.setEnabled(enable);
		btnCsvGetFeatureInFile.setEnabled(enable);
		txtCsvGetFeatureInFeatureType.setEnabled(!enable);
		
		enable = !chkDCMakebatFile.getSelection();
		txtDCCmdBatFile.setEnabled(!enable);
		btnDCCmdBatFile.setEnabled(!enable);
		
		enable = !chkRFMakebatFile.getSelection();
		txtRFCmdBatFile.setEnabled(!enable);
		btnRFCmdBatFile.setEnabled(!enable);
		
		enable = !chkXIMakebatFile.getSelection();
		txtXICmdBatFile.setEnabled(!enable);
		btnXICmdBatFile.setEnabled(!enable);
		
		enable = !chkCIMakebatFile.getSelection();
		txtCICmdBatFile.setEnabled(!enable);
		btnCICmdBatFile.setEnabled(!enable);
		
		enable = !chkXGMakebatFile.getSelection();
		txtXGCmdBatFile.setEnabled(!enable);
		btnXGCmdBatFile.setEnabled(!enable);
		
		enable = !chkCGMakebatFile.getSelection();
		txtCGCmdBatFile.setEnabled(!enable);
		btnCGCmdBatFile.setEnabled(!enable);

	}

	class RunCommandViewSelectionListener implements SelectionListener {

		public void widgetSelected(SelectionEvent e) {
			if ((e.widget == chkDaRuMaClientConsole)
					|| (e.widget == chkRegisterFeatureTypeConsole)
					|| (e.widget == chkXmlInsertConsole)
					|| (e.widget == chkCsvInsertConsole)
					|| (e.widget == chkXmlGetFeatureConsole)
					|| (e.widget == chkXmlGetFeature)
					|| (e.widget == chkCsvGetFeatureConsole)
					|| (e.widget == chkCsvGetFeature)
					|| (e.widget == chkDCMakebatFile)
					|| (e.widget == chkRFMakebatFile)
					|| (e.widget == chkXIMakebatFile)
					|| (e.widget == chkCIMakebatFile)
					|| (e.widget == chkXGMakebatFile)
					|| (e.widget == chkCGMakebatFile)){
				validateOut();
			} else if (e.widget == btnRun) {
				TabItem currTab = null;
				int temp = tabFolder.getSelectionIndex();
				if (temp >= 0)
					currTab = tabFolder.getItem(temp);
				if (tabDaRuMaClient == currTab) {
					if (checkDaRuMaClientParam()) {
						DaRuMaViewerView.dftService.agent.doDaRuMaClient(
								DaRuMaViewerView.dftPref, currServer,
								txtDaRuMaClientInFile.getText(),
								chkDaRuMaClientAddSoapHeader.getSelection(),
								chkDaRuMaClientConsole.getSelection() ? null
										: txtDaRuMaClientOutFile.getText(),
								chkDaRuMaClientDelSoapHeader.getSelection(),
								chkDCMakebatFile.getSelection(),
								txtDCCmdBatFile.getText(),
								chkDCViewCommand.getSelection(),
								DaRuMaClientAgent.MODE_DIALOG);
					}
				} else if (tabRegisterFeatureType == currTab) {
					if (checkRegisterFeatureParam()) {
						DaRuMaViewerView.dftService.agent
								.doRegisterFeatureType(
										DaRuMaViewerView.dftPref, currServer,
										txtRegisterFeatureTypeInFile.getText(),
										chkRegisterFeatureTypeConsole
												.getSelection() ? null
												: txtRegisterFeatureTypeOutFile
														.getText(),
										chkRFMakebatFile.getSelection(),
										txtRFCmdBatFile.getText(),
										chkRFViewCommand.getSelection(),
										DaRuMaClientAgent.MODE_DIALOG);
					}
				} else if (tabXmlInsert == currTab) {
					if (checkXmlInsertParam()) {
						DaRuMaViewerView.dftService.agent.doXmlInsert(
								DaRuMaViewerView.dftPref, currServer,
								txtXmlInsertInFile.getText(),
								chkXmlInsertConsole.getSelection() ? null
										: txtXmlInsertOutFile.getText(),
								chkXIMakebatFile.getSelection(),
								txtXICmdBatFile.getText(),
								chkXIViewCommand.getSelection(),
								DaRuMaClientAgent.MODE_DIALOG);
					}
				} else if (tabCsvInsert == currTab) {
					if (chkCsvInsertParam()) {
						DaRuMaViewerView.dftService.agent.doCsvInsert(
								DaRuMaViewerView.dftPref, currServer,
								txtCsvInsertInFile.getText(),
								txtCsvInsertCsvCfgFile.getText(),
								txtCsvInsertAttatchedFileDir.getText(),
								chkCsvInsertConsole.getSelection() ? null
										: txtCsvInsertOutFile.getText(),
								cmbCsvInsertEncode.getText(),
								chkCIMakebatFile.getSelection(),
								txtCICmdBatFile.getText(),
								chkCIViewCommand.getSelection(),
								DaRuMaClientAgent.MODE_DIALOG);
					}
				} else if (tabXmlGetFeature == currTab) {
					if (chkXmlGetFeature()) {
						if (chkXmlGetFeature.getSelection()) {
							DaRuMaFeatureType featureType = DaRuMaFeatureType
									.makeFeatureType(currServer,
											txtXmlGetFeatureInFeatureType
													.getText());
							DaRuMaViewerView.dftService.agent
									.doXmlGetFeature(DaRuMaViewerView.dftPref,
											currServer, featureType,
											chkXmlGetFeatureConsole
													.getSelection() ? null
													: txtXmlGetFeatureOutFile
															.getText(),
											chkXGMakebatFile.getSelection(),
											txtXGCmdBatFile.getText(),
											chkXGViewCommand.getSelection(),
											DaRuMaClientAgent.MODE_DIALOG);
						} else {
							DaRuMaViewerView.dftService.agent
									.doXmlGetFeature(DaRuMaViewerView.dftPref,
											currServer, txtXmlGetFeatureInFile
													.getText(),
											chkXmlGetFeatureConsole
													.getSelection() ? null
													: txtXmlGetFeatureOutFile
															.getText(),
											chkXGMakebatFile.getSelection(),
											txtXGCmdBatFile.getText(),
											chkXGViewCommand.getSelection(),
											DaRuMaClientAgent.MODE_DIALOG);
						}
					}
				} else if (tabCsvGetFeature == currTab) {
					if (chkCsvGetFeature()) {
						if (chkCsvGetFeature.getSelection()) {
							DaRuMaFeatureType featureType = null;
							if ((txtCsvGetFeatureInFeatureType.getText()
									.length() > 0)) {

								featureType = DaRuMaFeatureType
										.makeFeatureType(currServer,
												txtCsvGetFeatureInFeatureType
														.getText());
							}
							DaRuMaViewerView.dftService.agent
									.doCsvGetFeature(DaRuMaViewerView.dftPref,
											currServer, featureType,
											txtCsvGetFeatureCsvCfgFile
													.getText(),
											txtCsvGetFeatureAttatchedFileDir
													.getText(),

											chkCsvGetFeatureConsole
													.getSelection() ? null
													: txtCsvGetFeatureOutFile
															.getText(),
											cmbCsvGetFeatureEncode.getText(),
											chkCGMakebatFile.getSelection(),
											txtCGCmdBatFile.getText(),
											chkCGViewCommand.getSelection(),
											DaRuMaClientAgent.MODE_DIALOG);
						} else {
							DaRuMaViewerView.dftService.agent
									.doCsvGetFeature(DaRuMaViewerView.dftPref,
											currServer, txtCsvGetFeatureInFile
													.getText(),
											txtCsvGetFeatureCsvCfgFile
													.getText(),
											txtCsvGetFeatureAttatchedFileDir
													.getText(),

											chkCsvGetFeatureConsole
													.getSelection() ? null
													: txtCsvGetFeatureOutFile
															.getText(),
											cmbCsvGetFeatureEncode.getText(),
											chkCGMakebatFile.getSelection(),
											txtCGCmdBatFile.getText(),
											chkCGViewCommand.getSelection(),
											DaRuMaClientAgent.MODE_DIALOG);
						}
					}
				}

			}
		}

		private boolean chkCsvGetFeature() {
			if (chkCsvGetFeature.getSelection()) {
				if ((txtCsvGetFeatureInFeatureType.getText().length() > 0)) {
					if (DaRuMaFeatureType.makeFeatureType(currServer,
							txtCsvGetFeatureInFeatureType.getText()) == null) {
						SwtUtil.showError(Messages
								.getString("RunCommandView.48")); //$NON-NLS-1$
						return false;
					}
				}
			} else {
				if ((txtCsvGetFeatureInFile.getText().length() <= 0)) {
					SwtUtil.showError(Messages.getString("RunCommandView.49")); //$NON-NLS-1$
					return false;
				} else if (!(new File(txtCsvGetFeatureInFile.getText()))
						.exists()) {
					SwtUtil.showError(Messages.getString("RunCommandView.50")); //$NON-NLS-1$
					return false;
				}
			}
			if ((txtCsvGetFeatureCsvCfgFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.51")); //$NON-NLS-1$
				return false;
			} else if (!(new File(txtCsvGetFeatureCsvCfgFile.getText()))
					.exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.52")); //$NON-NLS-1$
				return false;
			}
			if (!chkCsvGetFeatureConsole.getSelection()) {
				if (txtCsvGetFeatureOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				} else if ((new File(txtCsvGetFeatureOutFile.getText()))
						.exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtCsvGetFeatureOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkCGMakebatFile.getSelection()) {
				if (txtCGCmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtCGCmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtCGCmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			return true;
		}

		private boolean chkXmlGetFeature() {
			if (chkXmlGetFeature.getSelection()) {
				if ((txtXmlGetFeatureInFeatureType.getText().length() <= 0)) {
					SwtUtil.showError(Messages.getString("RunCommandView.53")); //$NON-NLS-1$
					return false;
				} else if (DaRuMaFeatureType.makeFeatureType(currServer,
						txtXmlGetFeatureInFeatureType.getText()) == null) {
					SwtUtil.showError(Messages.getString("RunCommandView.54")); //$NON-NLS-1$
					return false;
				}
			} else {
				if ((txtXmlGetFeatureInFile.getText().length() <= 0)) {
					SwtUtil.showError(Messages.getString("RunCommandView.55")); //$NON-NLS-1$
					return false;
				} else if (!(new File(txtXmlGetFeatureInFile.getText()))
						.exists()) {
					SwtUtil.showError(Messages.getString("RunCommandView.56")); //$NON-NLS-1$
					return false;
				}
			}
			if (!chkXmlGetFeatureConsole.getSelection()) {
				if (txtXmlGetFeatureOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				} else if ((new File(txtXmlGetFeatureOutFile.getText()))
						.exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtXmlGetFeatureOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkXGMakebatFile.getSelection()) {
				if (txtXGCmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtXGCmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtXGCmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			return true;
		}

		private boolean chkCsvInsertParam() {
			if ((txtCsvInsertInFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.57")); //$NON-NLS-1$
				return false;
			} else if (!(new File(txtCsvInsertInFile.getText())).exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.58")); //$NON-NLS-1$
				return false;
			} else if ((txtCsvInsertCsvCfgFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.59")); //$NON-NLS-1$
				return false;
			} else if (!(new File(txtCsvInsertCsvCfgFile.getText())).exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.60")); //$NON-NLS-1$
				return false;
			} else if (!chkCsvInsertConsole.getSelection()) {
				if (txtCsvInsertOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				} else if ((new File(txtCsvInsertOutFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtCsvInsertOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkCIMakebatFile.getSelection()) {
				if (txtCICmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtCICmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtCICmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			return true;
		}

		private boolean checkXmlInsertParam() {
			if ((txtXmlInsertInFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.61")); //$NON-NLS-1$
				return false;
			} else if (!(new File(txtXmlInsertInFile.getText())).exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.62")); //$NON-NLS-1$
				return false;
			} else if (!chkXmlInsertConsole.getSelection()) {
				if (txtXmlInsertOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				} else if ((new File(txtXmlInsertOutFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtXmlInsertOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkXIMakebatFile.getSelection()) {
				if (txtXICmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtXICmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtXICmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			return true;
		}

		private boolean checkRegisterFeatureParam() {
			if ((txtRegisterFeatureTypeInFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.63")); //$NON-NLS-1$
				return false;
			} else if (!(new File(txtRegisterFeatureTypeInFile.getText()))
					.exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.64")); //$NON-NLS-1$
				return false;
			} else if (!chkRegisterFeatureTypeConsole.getSelection()) {
				if (txtRegisterFeatureTypeOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				} else if ((new File(txtRegisterFeatureTypeOutFile.getText()))
						.exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtRegisterFeatureTypeOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkRFMakebatFile.getSelection()) {
				if (txtRFCmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtRFCmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtRFCmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			return true;
		}

		private boolean checkDaRuMaClientParam() {
			if ((txtDaRuMaClientInFile.getText().length() <= 0)) {
				SwtUtil.showError(Messages.getString("RunCommandView.8")); //$NON-NLS-1$
				return false;
			}
			if (!(new File(txtDaRuMaClientInFile.getText())).exists()) {
				SwtUtil.showError(Messages.getString("RunCommandView.10")); //$NON-NLS-1$
				return false;
			}
			if (!chkDaRuMaClientConsole.getSelection()) {
				if (txtDaRuMaClientOutFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.9")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtDaRuMaClientOutFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtDaRuMaClientOutFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
						return false;
				}
			}
			if (chkDCMakebatFile.getSelection()) {
				if (txtDCCmdBatFile.getText().length() <= 0) {
					SwtUtil.showError(Messages.getString("RunCommandView.76")); //$NON-NLS-1$
					return false;
				}

				if ((new File(txtDCCmdBatFile.getText())).exists()) {
					if (!SwtUtil.showQuestion(Messages
							.getString("RunCommandView.26") //$NON-NLS-1$
							+ txtDCCmdBatFile.getText()
							+ Messages.getString("RunCommandView.27"))) //$NON-NLS-1$
							return false;
				}
			}
			
			return true;

		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
	}

	/**
	 * フォーカスを設定する
	 */
	public void setFocus() {
	}

	/**
	 * currServerをセットする
	 * 
	 * @param currServer
	 *            The currServer to set.
	 */
	public void setCurrServer(DaRuMaServer currServer) {
		this.currServer = currServer;
		update();
	}

	private void update() {
		this
				.setPartName(Messages.getString("RunCommandView.12") + currServer.getName()); //$NON-NLS-1$
		txtServer.setText(currServer.getName());
	}

	public void setXmlGetFeature(DaRuMaFeatureType currFeatureType,
			boolean xmlGetFeature) {
		if (xmlGetFeature) {
			tabFolder.setSelection(tabFolder.indexOf(tabXmlGetFeature));
			chkXmlGetFeature.setSelection(true);
			txtXmlGetFeatureInFeatureType.setText(currFeatureType.getName());
		} else {
			tabFolder.setSelection(tabFolder.indexOf(tabCsvGetFeature));
			chkCsvGetFeature.setSelection(true);
			txtCsvGetFeatureInFeatureType.setText(currFeatureType.getName());
		}
		validateOut();

	}

}
