package daruma.client.darumaviewer.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureTypeInfo;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;

public class DaRuMaClientUtil {
	public static boolean retriveFeatureTypes(String outFile, DaRuMaServer server) {
		boolean rc = false;
		FileInputStream fis = null;
		InputStreamReader isr = null;
		BufferedReader br = null;
		server.setFeatureTypeValid(false);
		try {
			fis = new FileInputStream(outFile);
			isr = new InputStreamReader(fis, "UTF-8"); //$NON-NLS-1$
			br = new BufferedReader(isr);
			Pattern p = Pattern.compile("^[0-9]*:\\{(.*)\\}(.*)$"); //$NON-NLS-1$
			while (true) {
				String line = br.readLine();
				if (line == null)
					break;
				Matcher m = p.matcher(line);
				if (m.matches()) {
					DaRuMaFeatureType type = server.addNewFeatureType();
					type.setTargetNS(m.group(1));
					type.setTypeName(m.group(2));
				}
			}
			rc = true;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		if (br != null)
			try {
				br.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		if (isr != null)
			try {
				isr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		if (fis != null)
			try {
				fis.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
			
		server.makeTargetNSList();
		server.setFeatureTypeValid(rc);
		return rc;

	}

	public static boolean retriveFeatureTypeCount(
			DaRuMaFeatureTypeInfo featureTypeInfo, String outFile) {
		boolean rc = false;
		FileInputStream fis = null;
		InputStreamReader isr = null;
		BufferedReader br = null;
		try {
			fis = new FileInputStream(outFile);
			isr = new InputStreamReader(fis, "UTF-8"); //$NON-NLS-1$
			br = new BufferedReader(isr);
			String line = br.readLine();
			if (line != null) {
				int count = Integer.parseInt(line);
				featureTypeInfo.setCount(count);
				rc = true;
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		if (br != null)
			try {
				br.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		if (isr != null)
			try {
				isr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		if (fis != null)
			try {
				fis.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		return rc;

	}

	public static boolean retriveFeatureTypeSchema(
			DaRuMaFeatureTypeInfo featureTypeInfo, String outFile) {
		boolean rc = false;
		FileInputStream fis = null;
		InputStreamReader isr = null;
		try {
			fis = new FileInputStream(outFile);
			isr = new InputStreamReader(fis, "UTF-8"); //$NON-NLS-1$
			StringBuffer schema = new StringBuffer();
			char[] buf = new char[8092];
			while (true) {
				int len = isr.read(buf);
				if (len <= 0)
					break;
				schema.append(buf, 0, len);
			}
			featureTypeInfo.setSchema(schema.toString());
			rc = true;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		if (isr != null)
			try {
				isr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		if (fis != null)
			try {
				fis.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		return rc;
	}
}
