package daruma.client.darumaviewer.dialogs;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.views.SwtUtil;

/**
 * アプリケーション処理中表示する汎用ダイアログ ダイアログを表示したままで もう１個スレッドを起動して 指定されたRunnableを実行する
 * Runnableの実行が終わると ダイアログを閉じる
 */
public class ThreadDialog extends GenericDialog {
	private ThreadDialogThread thread = null;

	private ThreadDialogRunnable runner;

	private String displayMsg;

	private Label lblMsg;

	private Button btnClose;

	private Text txtStdIn;

	private StringBuffer bufStdIn = new StringBuffer();

	private String strStdInLatest = ""; //$NON-NLS-1$

	private Text txtStdErr;

	private StringBuffer bufStdErr = new StringBuffer();

	private String strStdErrLatest = ""; //$NON-NLS-1$

	public static int CONSOLE_MAX_SIZE = 128 * 1024;

	private int returnVal;

	private boolean autoClose = false;

	/**
	 * 汎用ダイアログを生成する
	 * 
	 * @param parentShell
	 *            親シェル
	 * @param title
	 *            タイトル
	 * @param displayMsg
	 *            メッセージ
	 * @param runner
	 *            処理するRunnableオブジェクト
	 */
	public ThreadDialog(Shell parentShell, String title, String displayMsg,
			ThreadDialogRunnable runner, boolean autoClose) {
		super(parentShell, title, 600, autoClose ? 160 : 440);
		super.setOkText(""); //$NON-NLS-1$
		super.setCancelText(""); //$NON-NLS-1$
		this.runner = runner;
		this.displayMsg = displayMsg;
		this.autoClose = autoClose;
	}

	/**
	 * ダイアログをオープンする
	 * 
	 * @return 処理の戻り値を返す
	 */
	public int open() {
		this.setAllowEscape(false);
		this.setAllowClose(false);
		thread = new ThreadDialogThread(this, runner);
		thread.start();
		super.open();
		runner.stop();
		runner = null;
		thread = null;
		return returnVal;
	}

	private class ThreadDialogThread extends Thread {
		ThreadDialog dialog;

		ThreadDialogRunnable runner;

		public ThreadDialogThread(ThreadDialog dialog,
				ThreadDialogRunnable runner) {
			this.dialog = dialog;
			this.runner = runner;
		}

		public void run() {
			try {
				returnVal = runner.run();
			} catch (Exception e) {
				returnVal = -1;
			}

			Display display = dialog.getShell().getDisplay();
			if (!display.isDisposed()) {
				Runnable r = new Runnable() {
					public void run() {
						if (dialog.autoClose)
							dialog.close();
						else {
							dialog.txtStdIn.append("\r\n");
							dialog.txtStdErr.append("\r\n");
							dialog.lblMsg.setText(Messages
									.getString("ThreadDialog.2")); //$NON-NLS-1$
							btnClose.setText(Messages
									.getString("ThreadDialog.3")); //$NON-NLS-1$
						}
					}
				};
				display.syncExec(r);
			}
		}
	}

	public void createPropertyDialogArea(Composite composite) {
		composite.setLayout(SwtUtil.makeGridLayout(1));

		new Label(composite, SWT.NULL).setText(""); //$NON-NLS-1$

		lblMsg = new Label(composite, SWT.NULL);
		lblMsg.setText(displayMsg);

		TabFolder tabFolder = new TabFolder(composite, SWT.NULL);
		tabFolder.setLayoutData(SwtUtil.makeVarGridData(500, 400, 1));
		Composite compTab;

		TabItem tabStdIn = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabStdIn.setText(Messages.getString("ThreadDialog.4")); //$NON-NLS-1$
		tabStdIn.setControl(compTab);
		compTab.setLayout(SwtUtil.makeGridLayout(1));
		txtStdIn = new Text(compTab, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL
				| SWT.READ_ONLY | SWT.BORDER);
		txtStdIn.setLayoutData(SwtUtil.makeVarGridData(500, 400, 1));

		TabItem tabStdErr = new TabItem(tabFolder, SWT.NULL);
		compTab = new Composite(tabFolder, SWT.NULL);
		tabStdErr.setText(Messages.getString("ThreadDialog.5")); //$NON-NLS-1$
		tabStdErr.setControl(compTab);
		compTab.setLayout(SwtUtil.makeGridLayout(1));
		txtStdErr = new Text(compTab, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL
				| SWT.READ_ONLY | SWT.BORDER);
		txtStdErr.setLayoutData(SwtUtil.makeVarGridData(500, 400, 1));

		tabFolder.setVisible(!autoClose);

		btnClose = new Button(composite, SWT.NULL);
		btnClose.addSelectionListener(new BtnCloseSelectionListener(this));
		btnClose.setText(Messages.getString("ThreadDialog.1")); //$NON-NLS-1$
	}

	/**
	 * ダイアログがクローズされたときの処理を行います
	 * 
	 * @param flgCancel
	 *            キャンセルフラグ
	 */
	public void dialogClose(boolean flgCancel) {
	}

	/**
	 * Selectイベントを処理する
	 * 
	 * @param e
	 *            イベント
	 */
	public void widgetSelected(SelectionEvent e) {
	}

	/**
	 * DefaultSelectイベントを処理する
	 * 
	 * @param e
	 *            イベント
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void addToConsole(char[] buf, int start, int len, boolean stderr) {
		if (stderr) {
			bufStdErr.append(buf, start, len);
			strStdErrLatest += new String(buf, start, len);
		} else {
			bufStdIn.append(buf, start, len);
			strStdInLatest += new String(buf, start, len);
		}

	}

	public void refreshConsole() {
		if (bufStdIn.length() > CONSOLE_MAX_SIZE) {
			bufStdIn.delete(0, bufStdIn.length() - CONSOLE_MAX_SIZE);
			txtStdIn.setText(bufStdIn.toString());
			txtStdIn.append(""); //$NON-NLS-1$
		} else {
			txtStdIn.append(strStdInLatest);
		}
		strStdInLatest = ""; //$NON-NLS-1$

		if (bufStdErr.length() > CONSOLE_MAX_SIZE) {
			bufStdErr.delete(0, bufStdErr.length() - CONSOLE_MAX_SIZE);
			txtStdErr.setText(bufStdErr.toString());
			txtStdErr.append(""); //$NON-NLS-1$
		} else {
			txtStdErr.append(strStdErrLatest);
		}
		strStdErrLatest = ""; //$NON-NLS-1$
	}

	public class BtnCloseSelectionListener implements SelectionListener {
		ThreadDialog dialog;

		public BtnCloseSelectionListener(ThreadDialog dialog) {
			this.dialog = dialog;
		}

		public void widgetSelected(SelectionEvent e) {
			if ((thread != null) && thread.isAlive())
				runner.stop();
			else
				dialog.close();
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
	}
}
