package daruma.client.darumaviewer.dialogs;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;
import daruma.client.darumaviewer.views.SwtUtil;
import daruma.client.darumaviewer.views.SwtUtil.DirectoryButtonListener;

public class PreferenceDialog  extends GenericDialog{
	private DaRuMaViewerPreference currPref;
	private Text txtClientDir;
	private Button btnClientDir;
	private Button btnWorkDir;
	private Text txtWorkDir;
	private Button chkDebug;
	private Button chkDisplayTargetNS;
	
	public PreferenceDialog(Shell parentShell, DaRuMaViewerPreference pref) {
		super(parentShell, Messages.getString("PreferenceDialog.0"), 500, 200); //$NON-NLS-1$
		currPref = pref;
	}

	public void createPropertyDialogArea(Composite composite) {
		int colNum = 3;

		composite.setLayout(SwtUtil.makeGridLayout(colNum));
			
		new Label(composite, SWT.NULL).setText(Messages.getString("PreferenceDialog.1")); //$NON-NLS-1$
		txtClientDir = new Text(composite, SWT.BORDER);
		txtClientDir.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		btnClientDir = new Button(composite, SWT.NULL);
		btnClientDir.setText(Messages.getString("PreferenceDialog.4")); //$NON-NLS-1$
		btnClientDir.addSelectionListener(new DirectoryButtonListener(txtClientDir));
		txtClientDir.setToolTipText(Messages.getString("PreferenceDialog.7")); //$NON-NLS-1$
			
		new Label(composite, SWT.NULL).setText(Messages.getString("PreferenceDialog.2")); //$NON-NLS-1$
		txtWorkDir = new Text(composite, SWT.BORDER);
		txtWorkDir.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		btnWorkDir = new Button(composite, SWT.NULL);
		btnWorkDir.addSelectionListener(new DirectoryButtonListener(txtWorkDir));
		btnWorkDir.setText(Messages.getString("PreferenceDialog.5")); //$NON-NLS-1$
		txtWorkDir.setToolTipText(Messages.getString("PreferenceDialog.8")); //$NON-NLS-1$
		
		
		chkDebug = new Button(composite, SWT.CHECK);
		chkDebug.setText(Messages.getString("PreferenceDialog.3")); //$NON-NLS-1$
		chkDebug.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));

		chkDisplayTargetNS = new Button(composite, SWT.CHECK);
		chkDisplayTargetNS.setText(Messages.getString("PreferenceDialog.6")); //$NON-NLS-1$
		chkDisplayTargetNS.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));

		txtClientDir.setText(currPref.getClientToolDir());
		txtWorkDir.setText(currPref.getWorkDir());
		chkDebug.setSelection(currPref.isDebug());
		chkDisplayTargetNS.setSelection(currPref.isDisplayTargetNS());
		
		SwtUtil.TextDropTargetListener
		.makeTextDropTargetListener(txtClientDir);
		SwtUtil.TextDropTargetListener
		.makeTextDropTargetListener(txtWorkDir);

	}

	public void dialogClose(boolean flgCancel) {
		if(!flgCancel)
		{
			currPref.setClientToolDir(txtClientDir.getText());
			currPref.setWorkDir(txtWorkDir.getText());
			currPref.setDebug(chkDebug.getSelection());	
			currPref.setDisplayTargetNS(chkDisplayTargetNS.getSelection());
			currPref.save();
		}
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

}
