package daruma.client.darumaviewer.datamodel;

import java.util.List;

import org.eclipse.core.runtime.IAdaptable;

/**
 * ツリーのノードオブジェクト 詳しいことはEclipseドキュメントを参照
 * 
 */
public class TreeObject implements IAdaptable {
	private TreeObject parent = null;

	private Object data;

	/**
	 * 指定されたデータのツリーオブジェクトを生成する
	 * 
	 * @param data
	 */
	public TreeObject(Object data) {
		this.parent = null;
		this.data = data;
	}

	/**
	 * 指定されたデータのツリーオブジェクトを生成する
	 * 
	 * @param data
	 */
	public TreeObject(TreeObject parent, Object data) {
		this.parent = parent;
		this.data = data;
	}

	/**
	 * ツリーで表示する名前を取得する
	 * 
	 * @return 名前を返す
	 */
	public String getName() {

		if (data == null) {
			return "NULL";
		} else {
			return data.toString();
		}
	}

	/**
	 * 親を設定する
	 * 
	 * @param parent
	 *            親
	 */
	public void setParent(TreeObject parent) {
		this.parent = parent;
	}

	/**
	 * 親を取得する
	 * 
	 * @return 親を返す
	 */
	public TreeObject getParent() {
		return parent;
	}

	public boolean hasParent() {
		return parent != null;
	}

	/**
	 * オブジェクトを記述する文字列を取得
	 * 
	 * @return 文字列を返す
	 */
	public String toString() {
		return getName();
	}

	public Object getAdapter(Class key) {
		return null;
	}

	/**
	 * データを取得
	 * 
	 * @return データを返す
	 */
	public Object getData() {
		return data;
	}

	/**
	 * データを設定する
	 * 
	 * @param data
	 *            データ
	 */
	public void setData(Object data) {
		this.data = data;
	}

	public Object[] toArray(Object[] srcArray) {
		try {
			if(srcArray == null) return new Object[0];
			Object[] dstArray = new Object[srcArray.length];
			for (int cnt = 0; cnt < srcArray.length; cnt++) {
				TreeObject child = new TreeObject(this, srcArray[cnt]);
				child.parent = this;
				dstArray[cnt] = child;
			}
			return dstArray;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Object[] toArray(List srcList) {
		try {
			if(srcList == null) return new Object[0];
			Object[] dstArray = new Object[srcList.size()];
			for (int cnt = 0; cnt < srcList.size(); cnt++) {
				TreeObject child = new TreeObject(this, srcList.get(cnt));
				child.parent = this;
				dstArray[cnt] = child;
			}
			return dstArray;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

}
