/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.components.registry.IExtensionPointMonitor;
import org.osgi.framework.Bundle;

public class ExtensionPointManager {
    private String namespace;
    private Map monitors = new HashMap();
    private IRegistryChangeListener listener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas();
            int i = 0;
            while (i < deltas.length) {
                IExtensionDelta delta = deltas[i];
                IExtensionPoint point = delta.getExtensionPoint();
                if (point.getNamespace().equals(ExtensionPointManager.this.namespace)) {
                    String extensionPoint = point.getSimpleIdentifier();
                    List listeners = (List)ExtensionPointManager.this.monitors.get(extensionPoint);
                    if (listeners != null) {
                        Iterator iter = listeners.iterator();
                        while (iter.hasNext()) {
                            IExtensionPointMonitor monitor = (IExtensionPointMonitor)iter.next();
                            ExtensionPointManager.notifyMonitor(monitor, delta.getExtension(), delta.getKind());
                        }
                    }
                }
                ++i;
            }
        }
    };

    private static void notifyMonitor(IExtensionPointMonitor monitor, IExtension extension, int kind) {
        if (kind == 1) {
            monitor.added(extension);
        } else if (kind == 2) {
            monitor.removed(extension);
        }
    }

    public ExtensionPointManager(Bundle bundle) {
        this.namespace = bundle.getSymbolicName();
        Platform.getExtensionRegistry().addRegistryChangeListener(this.listener);
    }

    public void dispose() {
        Set extensionPoints = this.monitors.keySet();
        Iterator iter = extensionPoints.iterator();
        while (iter.hasNext()) {
            String pointId = (String)iter.next();
            List listeners = (List)this.monitors.get(pointId);
            Iterator iter2 = listeners.iterator();
            while (iter2.hasNext()) {
                IExtensionPointMonitor monitor = (IExtensionPointMonitor)iter2.next();
                this.loadExtensionPoint(pointId, monitor, 2);
            }
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.listener);
    }

    public void addMonitor(String extensionPoint, IExtensionPointMonitor newMonitor) {
        ArrayList<IExtensionPointMonitor> listeners = (ArrayList<IExtensionPointMonitor>)this.monitors.get(extensionPoint);
        if (listeners == null) {
            listeners = new ArrayList<IExtensionPointMonitor>();
        }
        if (listeners.contains(newMonitor)) {
            return;
        }
        listeners.add(newMonitor);
        this.loadExtensionPoint(extensionPoint, newMonitor, 1);
    }

    public void removeMonitor(String extensionPoint, IExtensionPointMonitor oldMonitor) {
        List listeners = (List)this.monitors.get(extensionPoint);
        if (listeners == null) {
            return;
        }
        if (!listeners.contains(oldMonitor)) {
            return;
        }
        listeners.remove(oldMonitor);
        if (listeners.isEmpty()) {
            this.monitors.remove(extensionPoint);
        }
        this.loadExtensionPoint(extensionPoint, oldMonitor, 2);
    }

    private void loadExtensionPoint(String pointId, IExtensionPointMonitor monitor, int kind) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.namespace, pointId);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            ExtensionPointManager.notifyMonitor(monitor, extension, kind);
            ++i;
        }
    }
}

