/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.menus.ILayoutNode;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SMenuLayout;
import org.eclipse.ui.internal.menus.SWidget;
import org.eclipse.ui.internal.misc.Policy;

public class LegacyMenuManager
extends MenuManager {
    private final WorkbenchWindow fWindow;
    private IMenuService fMenuService;
    private SMenuLayout fLayout;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LegacyMenuManager(WorkbenchWindow window) {
        if (window == null) {
            throw new NullPointerException("The window cannot be null");
        }
        this.fWindow = window;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fMenuService = (IMenuService)this.fWindow.getService(clazz);
    }

    protected void update(boolean force, boolean recursive) {
        if (this.isDirty()) {
            this.generateMenus();
            this.fLayout = this.fMenuService.getLayout();
            Menu menu = this.getMenu();
            if (menu.getItemCount() > 0) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
            }
            SMenuBuilder builder = new SMenuBuilder(this.fLayout, menu, this.fWindow);
            builder.build();
            this.setDirty(false);
        }
    }

    private void generateMenus() {
        IContributionItem[] items = this.getItems();
        SLocation location = new SLocation(new SBar());
        this.processChildren(items, location);
    }

    private void createMenu(IContributionItem item, SLocation location) {
        if (item == null) {
            return;
        }
        if (item instanceof ActionContributionItem) {
            this.addActionContribution((ActionContributionItem)item, location);
        } else if (item instanceof ActionSetContributionItem) {
            this.addActionSetContribution((ActionSetContributionItem)item, location);
        } else if (item instanceof MenuManager) {
            this.addMenu((MenuManager)item, location);
        } else if (item instanceof SubMenuManager) {
            this.addSubMenuManager((SubMenuManager)item, location);
        } else if (item instanceof IContributionManager) {
            this.addContributionManager((IContributionManager)item, location);
        } else {
            if (Policy.EXPERIMENTAL_MENU) {
                System.err.println("createMenu: unknown: " + item.getClass().getName());
            }
            this.addWidget(item, location);
        }
    }

    private void addSubMenuManager(SubMenuManager manager, SLocation parentLocation) {
        this.processChildren(manager.getItems(), parentLocation);
    }

    private void addContributionManager(IContributionManager manager, SLocation parentLocation) {
        if (Policy.EXPERIMENTAL_MENU) {
            System.err.println("addContributionManager: unknown: " + manager.getClass().getName());
        }
        this.processChildren(manager.getItems(), parentLocation);
    }

    private void addMenu(MenuManager menu, SLocation parentLocation) {
        String id = this.normalizeId((IContributionItem)menu);
        SMenu smenu = this.fMenuService.getMenu(id);
        if (smenu.isDefined()) {
            smenu.addLocation(parentLocation);
        } else {
            smenu.define(LegacyActionTools.removeMnemonics((String)menu.getMenuText()), parentLocation);
        }
        char mnemonic = LegacyActionTools.extractMnemonic((String)menu.getMenuText());
        SLocation location = new SLocation(parentLocation, id, mnemonic);
        this.processChildren(menu.getItems(), location);
    }

    private void processChildren(IContributionItem[] items, SLocation location) {
        int i = 0;
        while (i < items.length) {
            if (items[i].isGroupMarker()) {
                this.addGroup(items[i], location);
            } else if (items[i].isSeparator()) {
                this.addWidget(items[i], location);
            } else {
                this.createMenu(items[i], location);
            }
            ++i;
        }
    }

    private void addWidget(final IContributionItem item, SLocation location) {
        String id = this.normalizeId(item);
        SWidget swidget = this.fMenuService.getWidget(id);
        if (swidget.isDefined()) {
            swidget.addLocation(location);
        } else {
            swidget.define(new IWidget(){

                public void dispose() {
                    item.dispose();
                }

                public void fill(Composite parent) {
                    item.fill(parent);
                }

                public void fill(Menu parent, int index) {
                    item.fill(parent, index);
                }

                public void fill(ToolBar parent, int index) {
                    item.fill(parent, index);
                }

                public void fill(CoolBar parent, int index) {
                    item.fill(parent, index);
                }
            }, location);
        }
    }

    private String normalizeId(IContributionItem item) {
        String id = item.getId();
        if (id == null || id.length() < 1) {
            id = String.valueOf(item.getClass().getName()) + "@" + item.hashCode();
        }
        return id;
    }

    private SLocation addGroup(IContributionItem marker, SLocation location) {
        String id = this.normalizeId(marker);
        return this.addGroup(id, marker.isSeparator(), location);
    }

    protected SLocation addGroup(IContributionManager manager, SLocation location) {
        String id = String.valueOf(manager.getClass().getName()) + "@" + manager.hashCode();
        return this.addGroup(id, false, location);
    }

    private SLocation addGroup(String id, boolean isSeparator, SLocation location) {
        SGroup group = this.fMenuService.getGroup(id);
        if (group.isDefined()) {
            group.addLocation(location);
        } else {
            group.define(isSeparator, location);
        }
        return new SLocation(location, group.getId());
    }

    private void addActionSetContribution(ActionSetContributionItem actionSetContribution, SLocation parentLocation) {
        this.createMenu(actionSetContribution.getInnerItem(), parentLocation);
    }

    private void addActionContribution(ActionContributionItem actionContribution, SLocation parentLocation) {
        String id = this.normalizeId((IContributionItem)actionContribution);
        String commandId = actionContribution.getAction().getActionDefinitionId();
        if (commandId == null && Policy.EXPERIMENTAL_MENU) {
            System.err.println("addActionContribution: When is a command not a command! " + actionContribution.getId());
            return;
        }
        SItem sitem = this.fMenuService.getItem(id);
        if (sitem.isDefined()) {
            sitem.addLocation(parentLocation);
        } else {
            ICommandService commandService;
            Command c;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((c = (commandService = (ICommandService)this.fWindow.getService(clazz)).getCommand(commandId)).isDefined()) {
                ParameterizedCommand pc = new ParameterizedCommand(c, null);
                sitem.define(pc, actionContribution.getAction().getText(), parentLocation);
            } else if (Policy.EXPERIMENTAL_MENU) {
                System.err.println("addActionContribution: undefined command " + commandId);
            }
        }
    }

    private static class SMenuBuilder {
        private SMenuLayout fLayout;
        private Menu fRootMenu;
        private WorkbenchWindow fWindow;

        public SMenuBuilder(SMenuLayout rootNode, Menu menu, WorkbenchWindow window) {
            this.fLayout = rootNode;
            this.fRootMenu = menu;
            this.fWindow = window;
        }

        public void build() {
            ILayoutNode root = this.fLayout.getMenuBar();
            List children = root.getChildrenSorted();
            IndexManager index = new IndexManager();
            Iterator i = children.iterator();
            while (i.hasNext()) {
                ILayoutNode child = (ILayoutNode)i.next();
                this.addNode(this.fRootMenu, child, index);
            }
        }

        public void addNode(Menu menu, ILayoutNode node, IndexManager index) {
            block19: {
                block23: {
                    MenuElement element;
                    block22: {
                        block21: {
                            block20: {
                                element = node.getMenuElement();
                                if (Policy.EXPERIMENTAL_MENU && node.getLocation().getPath().toString().indexOf("org.eclipse.search.menu") > -1) {
                                    System.err.println("addNode: tree: " + node.getLocation() + "\n\t" + (Object)((Object)element));
                                }
                                if (!(element instanceof SMenu)) break block20;
                                SMenu smenu = (SMenu)element;
                                if (!smenu.isVisible((Window)this.fWindow)) {
                                    return;
                                }
                                MenuItem item = new MenuItem(menu, 64, index.index++);
                                item.setData((Object)smenu);
                                try {
                                    item.setText(smenu.getLabel());
                                }
                                catch (NotDefinedException e) {
                                    e.printStackTrace();
                                }
                                Menu itemMenu = new Menu(menu);
                                item.setMenu(itemMenu);
                                List children = node.getChildrenSorted();
                                IndexManager childIndex = new IndexManager();
                                Iterator i = children.iterator();
                                while (i.hasNext()) {
                                    ILayoutNode child = (ILayoutNode)i.next();
                                    this.addNode(itemMenu, child, childIndex);
                                }
                                break block19;
                            }
                            if (!(element instanceof SItem)) break block21;
                            SItem sitem = (SItem)element;
                            if (!sitem.isVisible((Window)this.fWindow)) {
                                return;
                            }
                            MenuItem item = new MenuItem(menu, 8, index.index++);
                            item.setData((Object)element);
                            try {
                                item.setText(sitem.getCommand().getName());
                                item.addSelectionListener(new SelectionListener(this, sitem){
                                    final /* synthetic */ SMenuBuilder this$1;
                                    private final /* synthetic */ SItem val$sitem;
                                    {
                                        this.this$1 = sMenuBuilder;
                                        this.val$sitem = sItem;
                                    }

                                    public void widgetSelected(SelectionEvent e) {
                                        try {
                                            this.val$sitem.getCommand().executeWithChecks(null, null);
                                        }
                                        catch (ExecutionException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (NotDefinedException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (NotEnabledException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (NotHandledException e1) {
                                            e1.printStackTrace();
                                        }
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                    }
                                });
                            }
                            catch (NotDefinedException e1) {
                                e1.printStackTrace();
                            }
                            break block19;
                        }
                        if (!(element instanceof SWidget)) break block22;
                        SWidget swidget = (SWidget)element;
                        if (!swidget.isVisible((Window)this.fWindow)) {
                            return;
                        }
                        try {
                            swidget.getWidget().fill(menu, index.index);
                        }
                        catch (NotDefinedException e) {
                            e.printStackTrace();
                        }
                        break block19;
                    }
                    if (!(element instanceof SGroup)) break block23;
                    SGroup sgroup = (SGroup)element;
                    if (!sgroup.isVisible((Window)this.fWindow)) {
                        return;
                    }
                    try {
                        if (sgroup.isSeparatorsVisible()) {
                            MenuItem item = new MenuItem(menu, 2, index.index++);
                            item.setData((Object)sgroup);
                        }
                        List children = node.getChildrenSorted();
                        Iterator i = children.iterator();
                        while (i.hasNext()) {
                            ILayoutNode child = (ILayoutNode)i.next();
                            this.addNode(menu, child, index);
                        }
                        break block19;
                    }
                    catch (NotDefinedException e) {
                        e.printStackTrace();
                    }
                    break block19;
                }
                if (Policy.EXPERIMENTAL_MENU) {
                    System.err.println("addNode: no element for " + node.getLocation());
                }
                if (node.isEmpty()) {
                    return;
                }
                List children = node.getChildrenSorted();
                if (children.isEmpty()) break block19;
                MenuItem item = new MenuItem(menu, 64, index.index++);
                item.setData((Object)node);
                item.setText(node.getId() == null ? "node" + (index.index - 1) : node.getId());
                Menu itemMenu = new Menu(menu);
                item.setMenu(itemMenu);
                IndexManager childIndex = new IndexManager();
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    ILayoutNode child = (ILayoutNode)i.next();
                    this.addNode(itemMenu, child, childIndex);
                }
            }
        }

        private static class IndexManager {
            public int index = 0;

            private IndexManager() {
            }
        }
    }
}

