/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.expressions.Expression;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.EvaluationResultCache;
import org.eclipse.ui.internal.services.EvaluationResultCacheComparator;
import org.eclipse.ui.internal.services.ExpressionAuthority;

final class HandlerAuthority
extends ExpressionAuthority {
    private static final int ACTIVATIONS_BY_SOURCE_SIZE = 256;
    private static final int ACTIVATIONS_TO_RECOMPUTE_SIZE = 1024;
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_PERFORMANCE = Policy.DEBUG_HANDLERS_PERFORMANCE;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final String TRACING_COMPONENT = "HANDLERS";
    private final Map[] activationsByExpressionBySourcePriority = new Map[33];
    private final ICommandService commandService;
    private final Map handlerActivationsByCommandId = new HashMap();

    HandlerAuthority(ICommandService commandService) {
        if (commandService == null) {
            throw new NullPointerException("The handler authority needs a command service");
        }
        this.commandService = commandService;
    }

    final void activateHandler(IHandlerActivation activation) {
        TreeSet<IHandlerActivation> handlerActivations;
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof SortedSet) {
            handlerActivations = (TreeSet<IHandlerActivation>)value;
            if (!handlerActivations.contains(activation)) {
                handlerActivations.add(activation);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else if (value instanceof IHandlerActivation) {
            if (value != activation) {
                handlerActivations = new TreeSet<IHandlerActivation>(new EvaluationResultCacheComparator());
                handlerActivations.add((IHandlerActivation)value);
                handlerActivations.add(activation);
                this.handlerActivationsByCommandId.put(commandId, handlerActivations);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else {
            this.handlerActivationsByCommandId.put(commandId, activation);
            this.updateCommand(commandId, this.evaluate(activation) ? activation : null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            if ((sourcePriority & 1 << i) != 0) {
                Expression expression;
                HashSet<IHandlerActivation> activations;
                HashMap<Expression, HashSet<IHandlerActivation>> activationsByExpression = this.activationsByExpressionBySourcePriority[i];
                if (activationsByExpression == null) {
                    this.activationsByExpressionBySourcePriority[i] = activationsByExpression = new HashMap<Expression, HashSet<IHandlerActivation>>(256);
                }
                if ((activations = (HashSet<IHandlerActivation>)activationsByExpression.get(expression = activation.getExpression())) == null) {
                    activations = new HashSet<IHandlerActivation>();
                    activationsByExpression.put(expression, activations);
                }
                activations.add(activation);
            }
            ++i;
        }
    }

    final void deactivateHandler(IHandlerActivation activation) {
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof SortedSet) {
            SortedSet handlerActivations = (SortedSet)value;
            if (handlerActivations.contains(activation)) {
                handlerActivations.remove(activation);
                if (handlerActivations.isEmpty()) {
                    this.handlerActivationsByCommandId.remove(commandId);
                    this.updateCommand(commandId, null);
                } else if (handlerActivations.size() == 1) {
                    IHandlerActivation remainingActivation = (IHandlerActivation)handlerActivations.iterator().next();
                    this.handlerActivationsByCommandId.put(commandId, remainingActivation);
                    this.updateCommand(commandId, this.evaluate(remainingActivation) ? remainingActivation : null);
                } else {
                    this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
                }
            }
        } else if (value instanceof IHandlerActivation && value == activation) {
            this.handlerActivationsByCommandId.remove(commandId);
            this.updateCommand(commandId, null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            Map activationsByExpression;
            if ((sourcePriority & 1 << i) != 0 && (activationsByExpression = this.activationsByExpressionBySourcePriority[i]) != null) {
                Expression expression = activation.getExpression();
                Collection activations = (Collection)activationsByExpression.get(expression);
                activations.remove(activation);
                if (activations.isEmpty()) {
                    activationsByExpression.remove(expression);
                }
                if (activationsByExpression.isEmpty()) {
                    this.activationsByExpressionBySourcePriority[i] = null;
                }
            }
            ++i;
        }
    }

    final Shell getActiveShell() {
        return (Shell)this.getVariable("activeShell");
    }

    private final IHandlerActivation resolveConflicts(String commandId, SortedSet activations) {
        if (activations.isEmpty()) {
            return null;
        }
        Iterator activationItr = activations.iterator();
        IHandlerActivation bestActivation = null;
        boolean conflict = false;
        while (activationItr.hasNext()) {
            IHandlerActivation currentActivation = (IHandlerActivation)activationItr.next();
            if (!this.evaluate(currentActivation)) continue;
            if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    resolveConflicts: eval: " + currentActivation));
            }
            if (bestActivation == null) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            int comparison = bestActivation.compareTo(currentActivation);
            if (comparison > 0) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            if (comparison != 0) break;
            if (currentActivation.getHandler() == bestActivation.getHandler()) continue;
            conflict = true;
        }
        if (DEBUG) {
            if (conflict) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("Unresolved conflict detected for '" + commandId + '\''));
            } else if (bestActivation != null && DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)"Resolved conflict detected.  The following activation won: ");
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    " + bestActivation));
            }
        }
        if (conflict) {
            return null;
        }
        return bestActivation;
    }

    /*
     * Unable to fully structure code
     */
    protected final void sourceChanged(int sourcePriority) {
        startTime = 0L;
        if (HandlerAuthority.DEBUG_PERFORMANCE) {
            startTime = System.currentTimeMillis();
        }
        changedCommandIds = new HashSet<String>(1024);
        i = 1;
        while (i <= 32) {
            block14: {
                if ((sourcePriority & 1 << i) == 0 || (activationsByExpression = this.activationsByExpressionBySourcePriority[i]) == null) break block14;
                activationByExpressionItr = activationsByExpression.values().iterator();
                while (activationByExpressionItr.hasNext()) {
                    activations = (Collection)activationByExpressionItr.next();
                    activationItr = activations.iterator();
                    if (!activationItr.hasNext()) continue;
                    activation = (IHandlerActivation)activationItr.next();
                    currentActive = this.evaluate(activation);
                    activation.clearResult();
                    newActive = this.evaluate(activation);
                    if (newActive == currentActive) ** GOTO lbl38
                    changedCommandIds.add(activation.getCommandId());
                    while (activationItr.hasNext()) {
                        activation = (IHandlerActivation)activationItr.next();
                        if (activation instanceof EvaluationResultCache) {
                            ((EvaluationResultCache)activation).setResult(newActive);
                        } else {
                            activation.clearResult();
                        }
                        changedCommandIds.add(activation.getCommandId());
                    }
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        activation = (IHandlerActivation)activationItr.next();
                        if (newActive == this.evaluate(activation)) continue;
                        if (activation instanceof EvaluationResultCache) {
                            ((EvaluationResultCache)activation).setResult(newActive);
                        } else {
                            activation.clearResult();
                        }
                        changedCommandIds.add(activation.getCommandId());
lbl38:
                        // 3 sources

                        ** while (activationItr.hasNext())
                    }
lbl39:
                    // 1 sources

                }
            }
            ++i;
        }
        changedCommandIdItr = changedCommandIds.iterator();
        while (changedCommandIdItr.hasNext()) {
            commandId = (String)changedCommandIdItr.next();
            value = this.handlerActivationsByCommandId.get(commandId);
            if (value instanceof IHandlerActivation) {
                activation = (IHandlerActivation)value;
                this.updateCommand(commandId, this.evaluate(activation) != false ? activation : null);
                continue;
            }
            if (value instanceof SortedSet) {
                activation = this.resolveConflicts(commandId, (SortedSet)value);
                this.updateCommand(commandId, activation);
                continue;
            }
            this.updateCommand(commandId, null);
        }
        if (HandlerAuthority.DEBUG_PERFORMANCE) {
            elapsedTime = System.currentTimeMillis() - startTime;
            size = changedCommandIds.size();
            if (size > 0) {
                Tracing.printTrace((String)"HANDLERS", (String)(String.valueOf(size) + " command ids changed in " + elapsedTime + "ms"));
            }
        }
    }

    private final void updateCommand(String commandId, IHandlerActivation activation) {
        Command command = this.commandService.getCommand(commandId);
        if (activation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(activation.getHandler());
        }
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(1024);
    }
}

