/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.service;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.dialogs.ThreadDialog;
import daruma.client.darumaviewer.dialogs.ThreadDialogRunnable;
import daruma.client.darumaviewer.prefs.DaRuMaViewerPreference;
import daruma.client.darumaviewer.views.SwtUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class DaRuMaClientAgent {
    public static boolean osWindows = System.getProperty("os.name").startsWith("Windows");
    public static String CMD_EXT = osWindows ? ".cmd" : "";
    public static String CMD_DARUMACLIENT = "DarumaClient" + CMD_EXT;
    public static String CMD_SHOWFEATURETYPES = "ShowFeatureTypes" + CMD_EXT;
    public static String CMD_COUNTFEATURETYPE = "CountFeatureType" + CMD_EXT;
    public static String CMD_DESCRIBEFEATURETYPE = "DescribeFeatureType" + CMD_EXT;
    public static String CMD_REGISTERFEATURETYPE = "RegisterFeatureType" + CMD_EXT;
    public static String CMD_XMLGETFEATURE = "XmlGetFeature" + CMD_EXT;
    public static String CMD_CSVGETFEATURE = "CsvGetFeature" + CMD_EXT;
    public static String CMD_XMLINSERT = "XmlInsert" + CMD_EXT;
    public static String CMD_CSVINSERT = "CsvInsert" + CMD_EXT;
    public static String OPT_HOST = "-host";
    public static String OPT_IN = "-in";
    public static String OPT_OUT = "-out";
    public static String OPT_FEATURE = "-checkFeature";
    public static String OPT_CSVCFG = "-csvcfg";
    public static String OPT_DEBUG = "-debug";
    public static String OPT_NOTADDHEADER = "-notaddheader";
    public static String OPT_ONLYBODY = "-onlybody";
    public static String OPT_ATTATCH_DIR = "-attatchDir";
    public static String OPT_ENCODE = "-encode";
    public static final int MODE_NO_DIALOG = 0;
    public static final int MODE_DIALOG_AUTOCLOSE = 1;
    public static final int MODE_DIALOG = 2;
    public static final String DFT_ENCODE = System.getProperty("file.encoding");

    private int run(String[] args, int mode, String encode) {
        if (mode == 1) {
            return this.runWithDialog(args, true, encode);
        }
        if (mode == 2) {
            return this.runWithDialog(args, false, encode);
        }
        return this.runWithoutDialog(args, null, encode);
    }

    private int runWithoutDialog(String[] args, ThreadDialog dialog, String encode) {
        try {
            Process process = Runtime.getRuntime().exec(args);
            return this.waitProcess(process, dialog, encode);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int waitProcess(Process process, final ThreadDialog dialog, String encode) {
        try {
            InputStream in = process.getInputStream();
            InputStreamReader inIsr = new InputStreamReader(in, encode);
            InputStream err = process.getErrorStream();
            InputStreamReader errIsr = new InputStreamReader(err, encode);
            char[] buf = new char[8092];
            while (true) {
                Display display;
                int len;
                boolean refresh = false;
                if (inIsr.ready() && (len = inIsr.read(buf)) > 0 && dialog != null) {
                    dialog.addToConsole(buf, 0, len, false);
                    refresh = true;
                }
                if (errIsr.ready() && (len = errIsr.read(buf)) > 0 && dialog != null) {
                    dialog.addToConsole(buf, 0, len, true);
                    refresh = true;
                }
                if (refresh && !(display = dialog.getShell().getDisplay()).isDisposed()) {
                    Runnable r = new Runnable(){

                        public void run() {
                            dialog.refreshConsole();
                        }
                    };
                    display.syncExec(r);
                }
                try {
                    int rc = process.exitValue();
                    inIsr.close();
                    errIsr.close();
                    in.close();
                    err.close();
                    return rc;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int runWithDialog(String[] args, boolean autoClose, String encode) {
        DaRuMaAgentRunner runner = new DaRuMaAgentRunner(args);
        ThreadDialog threadDialog = new ThreadDialog(null, Messages.getString("DaRuMaClientAgent.8"), Messages.getString("DaRuMaClientAgent.9"), runner, autoClose);
        runner.setDialog(threadDialog);
        runner.setEncode(encode);
        int rc = threadDialog.open();
        return rc;
    }

    private String[] makeArgArray(List argList) {
        String[] args = new String[argList.size()];
        int cnt = 0;
        while (cnt < argList.size()) {
            args[cnt] = (String)argList.get(cnt);
            ++cnt;
        }
        return args;
    }

    public boolean doDaRuMaClient(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, boolean blAddSoapHeader, String outFile, boolean blDelSoapHeader, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_DARUMACLIENT);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        argList.add(OPT_IN);
        argList.add(inFile);
        if (!blAddSoapHeader) {
            argList.add(OPT_NOTADDHEADER);
        }
        if (blDelSoapHeader) {
            argList.add(OPT_ONLYBODY);
        }
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doShowFeatureTypes(DaRuMaViewerPreference pref, DaRuMaServer server, String outFile, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_SHOWFEATURETYPES);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        argList.add(OPT_OUT);
        argList.add(outFile);
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doDescribeFeatureType(DaRuMaViewerPreference pref, DaRuMaServer server, DaRuMaFeatureType featureType, String outFile, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_DESCRIBEFEATURETYPE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        argList.add(featureType.getName());
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doCountFeatureType(DaRuMaViewerPreference pref, DaRuMaServer server, DaRuMaFeatureType featureType, String outFile, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_COUNTFEATURETYPE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        argList.add(featureType.getName());
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doXmlGetFeature(DaRuMaViewerPreference pref, DaRuMaServer server, DaRuMaFeatureType featureType, String outFile, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_XMLGETFEATURE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        argList.add(OPT_FEATURE);
        argList.add(featureType.getName());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doXmlGetFeature(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_XMLGETFEATURE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        argList.add(OPT_IN);
        argList.add(inFile);
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doRegisterFeatureType(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_REGISTERFEATURETYPE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        argList.add(OPT_IN);
        argList.add(inFile);
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doXmlInsert(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, String outFile, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_XMLINSERT);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        argList.add(OPT_IN);
        argList.add(inFile);
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doCsvInsert(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, String csvcfgFile, String attatchedFileDir, String outFile, String encode, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_CSVINSERT);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        argList.add(OPT_IN);
        argList.add(inFile);
        argList.add(OPT_CSVCFG);
        argList.add(csvcfgFile);
        argList.add(OPT_ENCODE);
        argList.add(encode);
        if (attatchedFileDir != null && attatchedFileDir.length() > 0) {
            argList.add(OPT_ATTATCH_DIR);
            argList.add(attatchedFileDir);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, DFT_ENCODE) == 0;
        return rc;
    }

    public boolean doCsvGetFeature(DaRuMaViewerPreference pref, DaRuMaServer server, DaRuMaFeatureType featureType, String csvcfgFile, String attatchedFileDir, String outFile, String encode, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_CSVGETFEATURE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        if (featureType != null) {
            argList.add(OPT_FEATURE);
            argList.add(featureType.getName());
        }
        argList.add(OPT_CSVCFG);
        argList.add(csvcfgFile);
        argList.add(OPT_ENCODE);
        argList.add(encode);
        if (attatchedFileDir != null && attatchedFileDir.length() > 0) {
            argList.add(OPT_ATTATCH_DIR);
            argList.add(attatchedFileDir);
        }
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, encode) == 0;
        return rc;
    }

    public boolean doCsvGetFeature(DaRuMaViewerPreference pref, DaRuMaServer server, String inFile, String csvcfgFile, String attatchedFileDir, String outFile, String encode, boolean blMakebatFile, String batFile, boolean blViewCommand, int mode) {
        boolean rc = false;
        ArrayList<String> argList = new ArrayList<String>();
        if (outFile != null) {
            File file = new File(outFile);
            file.delete();
        }
        argList.add(String.valueOf(pref.getClientToolDir()) + "/" + CMD_CSVGETFEATURE);
        if (pref.isDebug()) {
            argList.add(OPT_DEBUG);
        }
        argList.add(OPT_HOST);
        argList.add(server.getHost());
        argList.add(OPT_IN);
        argList.add(inFile);
        argList.add(OPT_CSVCFG);
        argList.add(csvcfgFile);
        argList.add(OPT_ENCODE);
        argList.add(encode);
        if (attatchedFileDir != null && attatchedFileDir.length() > 0) {
            argList.add(OPT_ATTATCH_DIR);
            argList.add(attatchedFileDir);
        }
        if (outFile != null) {
            argList.add(OPT_OUT);
            argList.add(outFile);
        }
        if (blViewCommand && !this.viewCommand(argList)) {
            return false;
        }
        if (blMakebatFile && !this.createbatFile(batFile, argList)) {
            return false;
        }
        rc = this.run(this.makeArgArray(argList), mode, encode) == 0;
        return rc;
    }

    public boolean createbatFile(String cmdFile, List args) {
        boolean rc = false;
        try {
            File batfile = new File(cmdFile);
            batfile.createNewFile();
            FileWriter fw = new FileWriter(batfile);
            if (!osWindows) {
                Runtime rt = Runtime.getRuntime();
                String[] command = new String[]{"chmod", "755", cmdFile};
                rt.exec(command);
            }
            String commandcsv = args.toString();
            int len = commandcsv.length();
            char[] command = null;
            command = commandcsv.toCharArray();
            String str = "";
            String com = null;
            String comall = osWindows ? "" : "#!/bin/sh\n";
            int i = 0;
            while (i <= len - 1) {
                if (command[i] != '[' && command[i] != ']' && command[i] != ',') {
                    com = String.valueOf(str) + command[i];
                    comall = String.valueOf(comall) + com;
                }
                ++i;
            }
            fw.write(comall);
            fw.close();
            rc = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public boolean viewCommand(List args) {
        boolean rc = false;
        String commandcsv = args.toString();
        int len = commandcsv.length();
        char[] command = null;
        command = commandcsv.toCharArray();
        String str = "";
        String com = null;
        String comall = "";
        int i = 0;
        while (i <= len - 1) {
            if (command[i] != '[' && command[i] != ']' && command[i] != ',') {
                com = String.valueOf(str) + command[i];
                comall = String.valueOf(comall) + com;
            }
            ++i;
        }
        if (!SwtUtil.showQuestion(String.valueOf(Messages.getString("DaRuMaClientAgent.10")) + comall)) {
            return false;
        }
        rc = true;
        return rc;
    }

    class DaRuMaAgentRunner
    implements ThreadDialogRunnable {
        String[] args;
        ThreadDialog dialog;
        String encode = DFT_ENCODE;
        Process process = null;

        DaRuMaAgentRunner(String[] args) {
            this.args = args;
        }

        public int run() {
            try {
                this.process = Runtime.getRuntime().exec(this.args);
                return DaRuMaClientAgent.this.waitProcess(this.process, this.dialog, this.encode);
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }

        public void setDialog(ThreadDialog dialog) {
            this.dialog = dialog;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public void stop() {
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }
}

