/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class GenericDialog
extends Dialog
implements SelectionListener {
    private Composite composite;
    private String title;
    private int width;
    private int height;
    private String okText = IDialogConstants.OK_LABEL;
    private String cancelText = IDialogConstants.CANCEL_LABEL;
    private boolean allowEscape = true;
    private boolean allowClose = true;

    protected GenericDialog(Shell parentShell, String title, int width, int height) {
        super(parentShell);
        this.title = title;
        this.width = width;
        this.height = height;
    }

    protected Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.createPropertyDialogArea(this.composite);
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.okText.length() > 0) {
            this.createButton(parent, 0, this.okText, true);
        }
        if (this.cancelText.length() > 0) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void handleShellCloseEvent() {
        if (this.allowEscape) {
            super.handleShellCloseEvent();
        }
    }

    public int open() {
        if (!this.allowClose) {
            this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
        }
        return super.open();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12 || buttonId == 16) {
            this.dialogClose(true);
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 0) {
            this.dialogClose(false);
        } else if (buttonId == 1) {
            this.dialogClose(true);
        }
        super.buttonPressed(buttonId);
    }

    public boolean isAllowClose() {
        return this.allowClose;
    }

    public void setAllowClose(boolean allowClose) {
        this.allowClose = allowClose;
    }

    public boolean isAllowEscape() {
        return this.allowEscape;
    }

    public void setAllowEscape(boolean allowEscape) {
        this.allowEscape = allowEscape;
    }

    public String getCancelText() {
        return this.cancelText;
    }

    public void setCancelText(String cancelText) {
        this.cancelText = cancelText;
    }

    public String getOkText() {
        return this.okText;
    }

    public void setOkText(String okText) {
        this.okText = okText;
    }

    public abstract void createPropertyDialogArea(Composite var1);

    public abstract void dialogClose(boolean var1);
}

