/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.datamodel;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaTargetNS;
import java.util.ArrayList;
import java.util.List;

public class DaRuMaServer {
    public static final int DARUMA_SERVER_STS_NOT_CONNECTED = 0;
    public static final int DARUMA_SERVER_STS_OK = 1;
    public static final int DARUMA_SERVER_STS_ERR = 2;
    private String host;
    private int port;
    private int sts = 0;
    private boolean featureTypeValid = false;
    private List featureTypeList = new ArrayList();
    private List targetNSList = new ArrayList();

    public DaRuMaServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getSts() {
        return this.sts;
    }

    public void setSts(int sts) {
        this.sts = sts;
    }

    public String getStsName() {
        String stsName = "";
        switch (this.sts) {
            case 1: {
                stsName = Messages.getString("DaRuMaServer.1");
                break;
            }
            case 2: {
                stsName = Messages.getString("DaRuMaServer.2");
                break;
            }
            case 0: {
                stsName = Messages.getString("DaRuMaServer.3");
            }
        }
        return stsName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getName() {
        return this.host;
    }

    public int getFeatureTypeSize() {
        return this.featureTypeValid ? this.featureTypeList.size() : -1;
    }

    public DaRuMaFeatureType getFeatureType(int index) {
        return this.featureTypeValid ? (DaRuMaFeatureType)this.featureTypeList.get(index) : null;
    }

    public DaRuMaFeatureType addNewFeatureType() {
        DaRuMaFeatureType featureType = new DaRuMaFeatureType(this);
        this.featureTypeList.add(featureType);
        return featureType;
    }

    public List getFeatureTypeList() {
        return this.featureTypeList;
    }

    public int getTargetNSSize() {
        return this.featureTypeValid ? this.targetNSList.size() : -1;
    }

    public DaRuMaTargetNS getTargetNS(int index) {
        return this.featureTypeValid ? (DaRuMaTargetNS)this.targetNSList.get(index) : null;
    }

    public List getTargetNSList() {
        return this.targetNSList;
    }

    public boolean isFeatureTypeValid() {
        return this.featureTypeValid;
    }

    public void setFeatureTypeValid(boolean featureTypeValid) {
        this.featureTypeValid = featureTypeValid;
        if (!featureTypeValid) {
            this.featureTypeList.clear();
            this.targetNSList.clear();
        }
    }

    public void makeTargetNSList() {
        this.targetNSList.clear();
        int cnt = 0;
        while (cnt < this.featureTypeList.size()) {
            DaRuMaFeatureType featureType = (DaRuMaFeatureType)this.featureTypeList.get(cnt);
            DaRuMaTargetNS targetNS = new DaRuMaTargetNS();
            targetNS.setTargetNS(featureType.getTargetNS());
            int index = this.targetNSList.indexOf(targetNS);
            if (index >= 0) {
                targetNS = (DaRuMaTargetNS)this.targetNSList.get(index);
            } else {
                this.targetNSList.add(targetNS);
            }
            targetNS.addFeatureType(featureType);
            ++cnt;
        }
    }
}

