/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.PrintWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class Counter
extends DefaultHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected static final boolean DEFAULT_TAGGINESS = false;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected long fTagCharacters;
    protected long fOtherCharacters;

    public void printResults(PrintWriter printWriter, String string, long l, long l2, boolean bl, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.print(" (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        if (bl) {
            printWriter.print(' ');
            long l3 = this.fTagCharacters + this.fOtherCharacters + this.fCharacters + this.fIgnorableWhitespace;
            long l4 = this.fTagCharacters * 100L / l3;
            printWriter.print(l4);
            printWriter.print("% tagginess");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void startDocument() throws SAXException {
        this.fElements = 0L;
        this.fAttributes = 0L;
        this.fCharacters = 0L;
        this.fIgnorableWhitespace = 0L;
        this.fTagCharacters = 0L;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.fElements;
        ++this.fTagCharacters;
        this.fTagCharacters += (long)string3.length();
        if (attributes != null) {
            int n = attributes.getLength();
            this.fAttributes += (long)n;
            int n2 = 0;
            while (n2 < n) {
                ++this.fTagCharacters;
                this.fTagCharacters += (long)attributes.getQName(n2).length();
                ++this.fTagCharacters;
                ++this.fTagCharacters;
                this.fOtherCharacters += (long)attributes.getValue(n2).length();
                ++this.fTagCharacters;
                ++n2;
            }
        }
        ++this.fTagCharacters;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.fCharacters += (long)n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.fIgnorableWhitespace += (long)n2;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.fTagCharacters += 2L;
        this.fTagCharacters += (long)string.length();
        if (string2 != null && string2.length() > 0) {
            ++this.fTagCharacters;
            this.fOtherCharacters += (long)string2.length();
        }
        this.fTagCharacters += 2L;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        String string2;
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        if (sAXParseException == null) {
            System.out.println("!!!");
        }
        if ((string2 = sAXParseException.getSystemId()) != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        Counter counter = new Counter();
        PrintWriter printWriter = new PrintWriter(System.out);
        XMLReader xMLReader = null;
        int n = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        boolean bl10 = true;
        boolean bl11 = false;
        boolean bl12 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            block85: {
                String string = stringArray[n2];
                if (string.startsWith("-")) {
                    String string2;
                    String string3 = string.substring(1);
                    if (string3.equals("p")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -p option.");
                        } else {
                            string2 = stringArray[n2];
                            try {
                                xMLReader = XMLReaderFactory.createXMLReader(string2);
                            }
                            catch (Exception exception) {
                                try {
                                    Parser parser = ParserFactory.makeParser(string2);
                                    xMLReader = new ParserAdapter(parser);
                                    System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                                }
                                catch (Exception exception2) {
                                    xMLReader = null;
                                    System.err.println("error: Unable to instantiate parser (" + string2 + ")");
                                }
                            }
                        }
                    } else if (string3.equals("x")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -x option.");
                        } else {
                            string2 = stringArray[n2];
                            try {
                                int n3 = Integer.parseInt(string2);
                                if (n3 < 1) {
                                    System.err.println("error: Repetition must be at least 1.");
                                    break block85;
                                }
                                n = n3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("error: invalid number (" + string2 + ").");
                            }
                        }
                    } else if (string3.equalsIgnoreCase("n")) {
                        bl = string3.equals("n");
                    } else if (string3.equalsIgnoreCase("np")) {
                        bl2 = string3.equals("np");
                    } else if (string3.equalsIgnoreCase("v")) {
                        bl3 = string3.equals("v");
                    } else if (string3.equalsIgnoreCase("s")) {
                        bl4 = string3.equals("s");
                    } else if (string3.equalsIgnoreCase("f")) {
                        bl5 = string3.equals("f");
                    } else if (string3.equalsIgnoreCase("va")) {
                        bl6 = string3.equals("va");
                    } else if (string3.equalsIgnoreCase("dv")) {
                        bl7 = string3.equals("dv");
                    } else if (string3.equalsIgnoreCase("xi")) {
                        bl8 = string3.equals("xi");
                    } else if (string3.equalsIgnoreCase("xb")) {
                        bl9 = string3.equals("xb");
                    } else if (string3.equalsIgnoreCase("xl")) {
                        bl10 = string3.equals("xl");
                    } else if (string3.equalsIgnoreCase("m")) {
                        bl11 = string3.equals("m");
                    } else if (string3.equalsIgnoreCase("t")) {
                        bl12 = string3.equals("t");
                    } else if (string3.equals("-rem")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -# option.");
                        } else {
                            System.out.print("# ");
                            System.out.println(stringArray[n2]);
                        }
                    } else if (string3.equals("h")) {
                        Counter.printUsage();
                    } else {
                        System.err.println("error: unknown option (" + string3 + ").");
                    }
                } else {
                    if (xMLReader == null) {
                        try {
                            xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                        }
                        catch (Exception exception) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            break block85;
                        }
                    }
                    try {
                        xMLReader.setFeature(NAMESPACES_FEATURE_ID, bl);
                    }
                    catch (SAXException sAXException) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, bl2);
                    }
                    catch (SAXException sAXException) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
                    }
                    try {
                        xMLReader.setFeature(VALIDATION_FEATURE_ID, bl3);
                    }
                    catch (SAXException sAXException) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl4);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        xMLReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl5);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        xMLReader.setFeature(VALIDATE_ANNOTATIONS_ID, bl6);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    try {
                        xMLReader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, bl7);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        xMLReader.setFeature(XINCLUDE_FEATURE_ID, bl8);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                    }
                    try {
                        xMLReader.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, bl9);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    try {
                        xMLReader.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, bl10);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    xMLReader.setContentHandler(counter);
                    xMLReader.setErrorHandler(counter);
                    try {
                        long l = System.currentTimeMillis();
                        long l2 = Runtime.getRuntime().freeMemory();
                        int n4 = 0;
                        while (n4 < n) {
                            xMLReader.parse(string);
                            ++n4;
                        }
                        long l3 = Runtime.getRuntime().freeMemory();
                        long l4 = System.currentTimeMillis();
                        long l5 = l4 - l;
                        long l6 = bl11 ? l2 - l3 : Long.MIN_VALUE;
                        counter.printResults(printWriter, string, l5, l6, bl12, n);
                    }
                    catch (SAXParseException sAXParseException) {
                    }
                    catch (Exception exception) {
                        System.err.println("error: Parse error occurred - " + exception.getMessage());
                        Exception exception3 = exception;
                        if (exception instanceof SAXException) {
                            exception3 = ((SAXException)exception).getException();
                        }
                        if (exception3 != null) {
                            exception3.printStackTrace(System.err);
                        }
                        exception.printStackTrace(System.err);
                    }
                }
            }
            ++n2;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -m  | -M    Turn on/off memory usage report");
        System.err.println("  -t  | -T    Turn on/off \"tagginess\" report.");
        System.err.println("  --rem text  Output user defined comment before next parse.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
        System.err.print("  Memory:     ");
        System.err.println("off");
        System.err.print("  Tagginess:  ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document parses within the same");
        System.err.println("  virtual machine to remove class loading from parse time and memory usage.");
        System.err.println();
        System.err.println("  The \"tagginess\" measurement gives a rough estimate of the percentage of");
        System.err.println("  markup versus content in the XML document. The percent tagginess of a ");
        System.err.println("  document is equal to the minimum amount of tag characters required for ");
        System.err.println("  elements, attributes, and processing instructions divided by the total");
        System.err.println("  amount of characters (characters, ignorable whitespace, and tag characters)");
        System.err.println("  in the document.");
        System.err.println();
        System.err.println("  Not all features are supported by different parsers.");
    }
}

