/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Counter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected ParserWrapper.DocumentInfo fDocumentInfo;

    public void setDocumentInfo(ParserWrapper.DocumentInfo documentInfo) {
        this.fDocumentInfo = documentInfo;
    }

    public void count(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fElements = 0L;
                this.fAttributes = 0L;
                this.fCharacters = 0L;
                this.fIgnorableWhitespace = 0L;
                Document document = (Document)node;
                this.count(document.getDocumentElement());
                break;
            }
            case 1: {
                ++this.fElements;
                Object object = node.getAttributes();
                if (object != null) {
                    this.fAttributes += (long)object.getLength();
                }
            }
            case 5: {
                Object object = node.getFirstChild();
                while (object != null) {
                    this.count((Node)object);
                    object = object.getNextSibling();
                }
                break;
            }
            case 4: {
                this.fCharacters += (long)((Text)node).getLength();
                break;
            }
            case 3: {
                if (this.fDocumentInfo == null) break;
                Text text = (Text)node;
                int n = text.getLength();
                if (this.fDocumentInfo.isIgnorableWhitespace(text)) {
                    this.fIgnorableWhitespace += (long)n;
                    break;
                }
                this.fCharacters += (long)n;
            }
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, long l3, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(';');
        printWriter.print(l2);
        printWriter.print(';');
        printWriter.print(l3);
        printWriter.print(" ms (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        printWriter.println();
        printWriter.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        var1_1 = new Counter();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = 1;
        var5_5 = true;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = false;
        var12_12 = true;
        var13_13 = true;
        var14_14 = 0;
        while (var14_14 < var0.length) {
            block61: {
                var15_15 = var0[var14_14];
                if (!var15_15.startsWith("-")) ** GOTO lbl-1000
                var16_16 = var15_15.substring(1);
                if (var16_16.equals("p")) {
                    if (++var14_14 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var17_29 = var0[var14_14];
                    try {
                        var3_3 = (ParserWrapper)Class.forName(var17_29).newInstance();
                    }
                    catch (Exception var18_31) {
                        var3_3 = null;
                        System.err.println("error: Unable to instantiate parser (" + var17_29 + ")");
                    }
                } else if (var16_16.equals("x")) {
                    if (++var14_14 == var0.length) {
                        System.err.println("error: Missing argument to -x option.");
                    } else {
                        var17_29 = var0[var14_14];
                        try {
                            var18_32 = Integer.parseInt(var17_29);
                            if (var18_32 < 1) {
                                System.err.println("error: Repetition must be at least 1.");
                                break block61;
                            }
                            var4_4 = var18_32;
                        }
                        catch (NumberFormatException var18_33) {
                            System.err.println("error: invalid number (" + var17_29 + ").");
                        }
                    }
                } else if (var16_16.equalsIgnoreCase("n")) {
                    var5_5 = var16_16.equals("n");
                } else if (var16_16.equalsIgnoreCase("v")) {
                    var6_6 = var16_16.equals("v");
                } else if (var16_16.equalsIgnoreCase("s")) {
                    var7_7 = var16_16.equals("s");
                } else if (var16_16.equalsIgnoreCase("f")) {
                    var8_8 = var16_16.equals("f");
                } else if (var16_16.equalsIgnoreCase("va")) {
                    var9_9 = var16_16.equals("va");
                } else if (var16_16.equalsIgnoreCase("dv")) {
                    var10_10 = var16_16.equals("dv");
                } else if (var16_16.equalsIgnoreCase("xi")) {
                    var11_11 = var16_16.equals("xi");
                } else if (var16_16.equalsIgnoreCase("xb")) {
                    var12_12 = var16_16.equals("xb");
                } else if (var16_16.equalsIgnoreCase("xl")) {
                    var13_13 = var16_16.equals("xl");
                } else if (var16_16.equals("h")) {
                    Counter.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception var16_17) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block61;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var5_5);
                    }
                    catch (SAXException var16_18) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var6_6);
                    }
                    catch (SAXException var16_19) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var7_7);
                    }
                    catch (SAXException var16_20) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var8_8);
                    }
                    catch (SAXException var16_21) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validate-annotations", var9_9);
                    }
                    catch (SAXException var16_22) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/dynamic", var10_10);
                    }
                    catch (SAXException var16_23) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude", var11_11);
                    }
                    catch (SAXException var16_24) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", var12_12);
                    }
                    catch (SAXException var16_25) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude/fixup-language", var13_13);
                    }
                    catch (SAXException var16_26) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    try {
                        var16_27 = System.currentTimeMillis();
                        var18_34 = null;
                        var19_35 = 0;
                        while (var19_35 < var4_4) {
                            var18_34 = var3_3.parse(var15_15);
                            ++var19_35;
                        }
                        var20_36 = System.currentTimeMillis();
                        var22_37 = var20_36 - var16_27;
                        var24_38 = var3_3.getDocumentInfo();
                        var1_1.setDocumentInfo(var24_38);
                        var25_39 = System.currentTimeMillis();
                        var1_1.count((Node)var18_34);
                        var27_40 = System.currentTimeMillis();
                        var29_41 = var27_40 - var25_39;
                        var31_42 = System.currentTimeMillis();
                        var1_1.count((Node)var18_34);
                        var33_43 = System.currentTimeMillis();
                        var35_44 = var33_43 - var31_42;
                        var1_1.printResults(var2_2, var15_15, var22_37, var29_41, var35_44, var4_4);
                    }
                    catch (SAXParseException var16_28) {
                    }
                    catch (Exception var17_30) {
                        System.err.println("error: Parse error occurred - " + var17_30.getMessage());
                        var18_34 = var17_30;
                        if (var17_30 instanceof SAXException) {
                            var18_34 = ((SAXException)var17_30).getException();
                        }
                        if (var18_34 != null) {
                            var18_34.printStackTrace(System.err);
                        }
                        var17_30.printStackTrace(System.err);
                    }
                }
            }
            ++var14_14;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

