//---------------------------------------------------------------------------
// WG[o͂\tH[
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "StdError.h"
#include "KRegexp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Base"
#pragma resource "*.dfm"
TFStdError *FStdError;
//---------------------------------------------------------------------------
__fastcall
TFStdError::TFStdError(TComponent* Owner)
    : TFBase(Owner) {
  //hbLO
  Caption = "Error";
  Width = 400;
  Height = 400;
  ManualDock(FMain->PStdError,FMain->PStdError,alClient);
  Visible = true;
}
//---------------------------------------------------------------------------
void
TFStdError::LoadFromStream(TStream *Stream) {
  LBStdError->Items->LoadFromStream(Stream);
  if(Stream->Size!=0) {
    FMain->OpenError();
  }
}
//---------------------------------------------------------------------------
void
TFStdError::Find(void) {
  FMain->ChangeWindow(SCRIPT_WINDOW);
  FScript->Find();
}
//---------------------------------------------------------------------------
bool
TFStdError::IsEmpty(void) {
  if(LBStdError->Items->Text.Length()==0){
    return true;
  }else{
    return false;
  }
}
//---------------------------------------------------------------------------
// Nbv{[h
//---------------------------------------------------------------------------
/**
 * Rs[
 */
void
TFStdError::Copy(void) {
  TClipboard *Co = Clipboard();
  AnsiString as1;
  for (int i=0;i<LBStdError->Items->Count;i++) {
    if(LBStdError->Selected[i]) {
      as1 = as1 + LBStdError->Items->Strings[i]+"\r\n";
    }
  }
  if(as1.Length()==0) {
    return;
  }
  Co->AsText = as1;
}
//---------------------------------------------------------------------------
/**
 * \t
 */
void
TFStdError::Paste(void) {
  ShowMessage("Error window is read only.");
}
//---------------------------------------------------------------------------
/**
 * ؂
 */
void
TFStdError::Cut(void) {
  ShowMessage("Error window is read only.");
}
//---------------------------------------------------------------------------
/**
 * ۑ
 */
void
TFStdError::Save(void) {
  FMain->SaveDialog->Filter = "All Files(*.*)|*.*";
  FMain->SaveDialog->Title = "G[ʂۑ";
  if(!FMain->SaveDialog->Execute()) {
    return;
  }
  LBStdError->Items->SaveToFile(FMain->SaveDialog->FileName);
}
//---------------------------------------------------------------------------
/**
 * Xe[^Xo[\p̕Ԃ
 */
AnsiString
TFStdError::GetCaretString(void) {
  int line = LBStdError->ItemIndex;
  int selected = 0;
  for (int i=0;i<LBStdError->Items->Count;i++) {
    if(LBStdError->Selected[i]) {
      selected ++;
    }
  }
  if(line ==-1) {
    return "";
  }
  if(selected >1){
    return IntToStr(line+1) + " (" + IntToStr(selected) + ")";
  }else{
    return IntToStr(line+1);
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::FormActivate(TObject *Sender) {
  FMain->ChangeWindow(ERROR_WINDOW);
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::FormHide(TObject *Sender) {
  FMain->CloseError();
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::LBStdErrorDblClick(TObject *Sender) {

  int line = GetErrorLineNumber();
  if (line == -1) {
    return;
  }

  AnsiString FileName = FScript->GetFileName();
  //OGfB^Ƀ^OWv
  if(FileName!="" && FMain->GetCopalConfig()->UseTagJump) {

    //ۑ̊mF
    //ۑĂȂ΃^OWvȂ
    if (!FScript->SaveQuery()) {
      return;
    }

    //قȂt@CɃ^OWv
    if(FMain->GetCopalConfig()->GetUseTagJumpToOtherFile()) {
      AnsiString asLine = LBStdError->Items->Strings[LBStdError->ItemIndex];
      AnsiString asRegExp = FMain->GetCopalConfig()->GetRegExpFile();
      if(!KRegexp::GetMatchStr(asLine,asRegExp) || KRegexp::Pattern[1] =="") {
        return;
      }
      FileName = KRegexp::Pattern[1];
      if(FileName.LowerCase() == FMain->GetCopalConfig()->GetTempFile().LowerCase()) {
        FileName = FScript->GetFileName();
      }
    }

    if(FMain->GetCopalConfig()->UseDoubleQuotes) {
      FileName = "\""+FileName+"\"";
    }

    char *editor = FMain->GetCopalConfig()->Editor.c_str();
    char *option = GetTagJumpText(FileName,line).c_str();

    if(!FileExists(FMain->GetCopalConfig()->Editor)) {
      ShowMessage(FMain->GetCopalConfig()->Editor+"܂BpXmFĂB");
      return;
    }
    ShellExecute(this->Handle,NULL,editor,option,NULL,SW_SHOW);
  } else {
    //Copal̃GfB^ŃG[sWv
    FMain->ChangeWindow(SCRIPT_WINDOW);
    FScript->LineJump(line);
  }

}
//---------------------------------------------------------------------------
int
TFStdError::GetErrorLineNumber(void) {

  AnsiString asLine = LBStdError->Items->Strings[LBStdError->ItemIndex];
  AnsiString asRegExp = FMain->GetCopalConfig()->GetRegExpErr();
  if(!KRegexp::GetMatchStr(asLine,asRegExp)) {
    return -1;
  }
  asLine = KRegexp::Pattern[0];
  if(!KRegexp::GetMatchStr(asLine,"[0-9]+")) {
    return -1;
  }

  int line = StrToIntDef(KRegexp::Pattern[0],-1);
  return line;
}
//---------------------------------------------------------------------------
/**
 * ^OWvp̃IvVԂ
 * line  G[s
 * FileName t@C
 */
AnsiString
TFStdError::GetTagJumpText(AnsiString FileName,int line) {
  KCopalConfig *CopalConfig = FMain->GetCopalConfig();
  AnsiString TagJumpText = CopalConfig->GetTagJumpText();
  AnsiString as;
  char *buf = TagJumpText.c_str();
  int length = TagJumpText.Length();

  for(int i=0;i<length;i++) {
    if(buf[i]=='%' && i<length-1 ) {
      switch(buf[i+1]) {
      case 'L':
        as += IntToStr(line);
        i++;
        break;
      case 'F':
        as += FileName;
        i++;
        break;
      }
    } else {
      as += buf[i];
    }
  }
  return as;
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::PMCopyClick(TObject *Sender) {
  FMain->MMCopy->Click();
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::LBStdErrorMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::LBStdErrorKeyPress(TObject *Sender, char &Key) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::LBStdErrorKeyDown(TObject *Sender, WORD &Key, TShiftState Shift) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFStdError::LBStdErrorKeyUp(TObject *Sender, WORD &Key, TShiftState Shift) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------

