/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.editor;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.text.IStructuredPartitions;
import org.eclipse.wst.xml.core.text.IXMLPartitions;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;

/**
 * カスタム XML 構成。
 *
 * <UL>
 * <LI>XML のコンテンツ・アシスタントにカスタム XML アシスト・プロセッサーを設定するクラスです。
 * </UL>
 *
 * @author YAMAMOTO Koji
 */
public class CustomXMLConfiguration extends StructuredTextViewerConfigurationXML {

	@Override
	public IContentAssistant getContentAssistant(final ISourceViewer sourceViewer) {
		final IContentAssistant ca = super.getContentAssistant(sourceViewer);
		if (ca != null && ca instanceof ContentAssistant) {
			final ContentAssistant contentAssistant = (ContentAssistant) ca;
			final IContentAssistProcessor contentAssistProcessor = new CustomXMLAssistProccessor();
			contentAssistant.setContentAssistProcessor(contentAssistProcessor, IStructuredPartitions.DEFAULT_PARTITION);
			contentAssistant.setContentAssistProcessor(contentAssistProcessor, IXMLPartitions.XML_DEFAULT);
		}
		return ca;
	}
}
