#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    echo  "関数一覧："
    echo  T_CallStack_Error_func
    echo  T_CallStack_StepError_func
    echo  T_Step_func
    echo  T_EchoStep_func
    Error_func  "呼び出すスクリプト内の関数を指定してください。例 $BASH_SOURCE --T_Test1_func"
  fi
  $g_FuncName  "$@"
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_CallStack_Error_func] >>>
#//*********************************************************************
function  T_CallStack_Error_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  echo  "次に発生するエラーによって表示されるコールツリーのファイル名と行番号をチェックしてください。"
  Pause_func
  Error_func
}


 
#//*********************************************************************
#// <<< [T_CallStack_StepError_func] >>>
#//*********************************************************************
function  T_CallStack_StepError_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  echo  "次に発生するエラーによって表示されるコールツリーのファイル名と行番号をチェックしてください。"
  Pause_func
debugger
  Error_func
}


 
#//*********************************************************************
#// <<< [T_Step_func] >>>
#//*********************************************************************
function  T_Step_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  echo  "ステップ実行を開始します。"
  echo  "ステップ実行開始時に表示されるコールツリーのファイル名と行番号をチェックしてください。"
  echo  "次の順でステップすることを確認してください。"
  echo  "・echo \"stepping1...\""
  echo  "・echo \"stepping2...\""
  echo  "・EchoOff_func"
  Pause_func

de
  echo  "stepping1..."
  echo  "stepping2..."
  EchoOff_func
}


 
#//*********************************************************************
#// <<< [T_EchoStep_func] >>>
#//*********************************************************************
function  T_EchoStep_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  echo  "ステップ実行を開始します。"
  echo  "ステップ実行開始前に、debugger 関数の呼び出しが echo 出力されることを確認してください。"
  echo  "次の順でステップすることを確認してください。"
  echo  "・echo \"stepping...\""
  echo  "・EchoOff_func"
  Pause_func

  EchoOn_func
debugger
  echo  "stepping..."
  EchoOff_func
}


 







#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
