#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"

  if [ "$g_FuncName" == "" ]; then
    T_Assert_func  "$@"
    T_CheckPipeStatus_func  "$@"
    T_CheckMaxArgCount_func  "$@"
    T_CheckOutParamIsConflictToLocal_func  "$@"
    T_CheckEvalParamIsConflictToLocal_func  "$@"
    T_TryLv0_func  "$@"
    T_TryLv1_func  "$@"
    T_TryLv1Clear_func  "$@"
    T_TryLv2_func  "$@"
    T_TryLv2Change_func  "$@"
    T_TryLv1Proc1_func  "$@"
    T_NotTryLoop_func  "$@"
    T_DoneInErrMode_func  "$@"
    T_ErrorInErrMode_func  "$@"
    T_TryEnd2NoParam_func  "$@"
    T_DoneNoParam_func  "$@"
    T_AnyTypeError_func  "$@"
    T_WS_func  "$@"
  else
    $g_FuncName  "$@"
  fi
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_Assert_func] >>> 
#//*********************************************************************
function  T_Assert_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_AssertSub_func"  "ans/T_Assert_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_CheckPipeStatus_func] >>> 
#//*********************************************************************
function  T_CheckPipeStatus_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_CheckPipeStatusSub_func"  "ans/T_CheckPipeStatus_ans.txt"

  local  out ; out=`./T_Err_Sub.sh  --T_CheckPipeStatusSub2_func  2>&1`
  echo  "$out"
  echo  "$out" | grep '\${PIPESTATUS\[@\]} = 1 0'    #// check the keyword
  echo  "$out" | grep '\${PIPESTATUS\[@\]} = 1 1 0'  #// check the keyword
  echo  "$out" | grep 'last of T_CheckPipeStatusSubInFunc_func'  #// check the keyword
  echo  "$out" | grep 'after T_CheckPipeStatusSubInFunc_func'    #// check the keyword
}


 
#//*********************************************************************
#// <<< [T_CheckMaxArgCount_func] >>> 
#//*********************************************************************
function  T_CheckMaxArgCount_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_CheckMaxArgCountSub_func"  "ans/T_CheckMaxArgCount_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_CheckOutParamIsConflictToLocal_func] >>> 
#//*********************************************************************
function  T_CheckOutParamIsConflictToLocal_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var1
  local  var2

  T_CheckOutParamIsConflictToLocal_Sub_func  var1
  Assert_func  '"$var1" == "bbb"'

  while TryStart_func; do
    T_CheckOutParamIsConflictToLocal_Sub_func  var2
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  StringClass.substring_method  "$g_Err_Desc"  "var2"
  if [ "$g_Ret" == "-1" ];then  Error_func  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


function  T_CheckOutParamIsConflictToLocal_Sub_func()
{
  local  out_Var="$1"
  local  var2

  local  locals="out_Var  var2  locals"
  CheckOutParamIsConflictToLocal_func  $out_Var  $locals
  SetOutput_func  $out_Var  "bbb"
}


 
#//*********************************************************************
#// <<< [T_CheckEvalParamIsConflictToLocal_func] >>> 
#//*********************************************************************
function  T_CheckEvalParamIsConflictToLocal_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  local_a="aaa"
  T_CheckEvalParamIsConflictToLocal_Sub_func  'local_a is $local_a'

  while TryStart_func; do
    local  local_b="aaa"
    T_CheckEvalParamIsConflictToLocal_Sub_func  'local_b is $local_b'
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  StringClass.substring_method  "$g_Err_Desc"  "local_b"
  if [ "$g_Ret" == "-1" ];then  Error_func  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


function  T_CheckEvalParamIsConflictToLocal_Sub_func()
{
  local  EvalExpr="$1"
  local  local_b

  local  locals="EvalExpr  local_b  locals"
  CheckEvalParamIsConflictToLocal_func  $EvalExpr  $locals
  eval  echo  "$EvalExpr"
}


 
#//*********************************************************************
#// <<< [T_TryLv0_func] >>> 
#//*********************************************************************
function  T_TryLv0_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv0Sub_func"  "ans/T_TryLv0_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryLv1_func] >>> 
#//*********************************************************************
function  T_TryLv1_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv1Sub_func"  "ans/T_TryLv1_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryLv1Clear_func] >>> 
#//*********************************************************************
function  T_TryLv1Clear_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv1ClearSub_func"  "ans/T_TryLv1Clear_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryLv2_func] >>> 
#//*********************************************************************
function  T_TryLv2_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv2Sub_func"  "ans/T_TryLv2_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryLv2Change_func] >>> 
#//*********************************************************************
function  T_TryLv2Change_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv2ChangeSub_func"  "ans/T_TryLv2Change_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryLv1Proc1_func] >>> 
#//*********************************************************************
function  T_TryLv1Proc1_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_TryLv1Proc1Sub_func"  "ans/T_TryLv1Proc1_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_NotTryLoop_func] >>> 
#//*********************************************************************
function  T_NotTryLoop_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_NotTryLoopSub_func"  "ans/T_NotTryLoop_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_DoneInErrMode_func] >>> 
#//*********************************************************************
function  T_DoneInErrMode_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_DoneInErrModeSub_func"  "ans/T_DoneInErrMode_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_ErrorInErrMode_func] >>> 
#//*********************************************************************
function  T_ErrorInErrMode_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_ErrorInErrModeSub_func"  "ans/T_ErrorInErrMode_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_TryEnd2NoParam_func] >>> 
#//*********************************************************************
function  T_TryEnd2NoParam_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    T_TryEnd2NoParamSub_func
  TryEnd1_func; done ;TryEnd2_func $?
  StringClass.indexOf_method  "$g_Err_Desc"  "パラメーターの数"
  if [ "$g_Ret" == "-1" ]; then
    StringClass.indexOf_method  "$g_Err_Desc"  "parameters length"
    if [ "$g_Ret" == "-1" ]; then  Error_func  ;fi
  fi
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


function  T_TryEnd2NoParamSub_func()
{
  while TryStart_func; do
    EchoTestStart_func  "${FUNCNAME[0]}"
  TryEnd1_func; done ;TryEnd2_func
}


 
#//*********************************************************************
#// <<< [T_DoneNoParam_func] >>> 
#//*********************************************************************
function  T_DoneNoParam_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  while TryStart_func; do
    T_DoneNoParamSub_func
  TryEnd1_func; done ;TryEnd2_func $?
  StringClass.indexOf_method  "$g_Err_Desc"  "パラメーターの数"
  if [ "$g_Ret" == "-1" ]; then
    StringClass.indexOf_method  "$g_Err_Desc"  "parameters length"
    if [ "$g_Ret" == "-1" ]; then  Error_func  ;fi
  fi
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


function  T_DoneNoParamSub_func()
{
  local  num
  for (( num = 0;  $num < 1;  num ++ )) ;do
    EchoTestStart_func  "${FUNCNAME[0]}"
  done ; done_func
}


 
#//*********************************************************************
#// <<< [T_AnyTypeError_func] >>> 
#//*********************************************************************
function  T_AnyTypeError_func()
{
  local  a1

  EchoTestStart_func  "${FUNCNAME[0]}"

  a1=`NotDefined_func 2>&1 || :`
  StringClass.indexOf_method  "$a1"  "command not found"
  if [ "$g_Ret" -gt "0" ];then
    RunAndLogCheck_func  "T_AnyTypeErrorSub_func"  "ans/T_AnyTypeError_en_ans.txt"
  else
    RunAndLogCheck_func  "T_AnyTypeErrorSub_func"  "ans/T_AnyTypeError_ans.txt"
  fi
}


 
#//*********************************************************************
#// <<< [T_WS_func] >>> 
#//*********************************************************************
function  T_WS_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"
  RunAndLogCheck_func  "T_WSSub_func"  "ans/T_WS_ans.txt"
}


 
#//*********************************************************************
#// <<< [RunAndLogCheck_func] >>> 
#//*********************************************************************
function  RunAndLogCheck_func()
{
  local  SubProcessFuncName="$1"
  local  AnswerLogFileName="$2"

  while TryStart_func; do
    ./T_Err_Sub.sh  --$SubProcessFuncName  2>&1  | tee  out.txt
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "0" ];then  echo  "This error is OK"  ;fi
  sed -i.bak -e "s/:[0-9][0-9]*$/:xx/" \
             -e "s/line [0-9]*: NotDefined/line xx: NotDefined/" \
             -e   "s/行 [0-9]*: NotDefined/line xx: NotDefined/" \
    out.txt ; rm out.txt.bak
  echo  "check out.txt and $AnswerLogFileName" >&2
  diff  "out.txt"  "$AnswerLogFileName"  #// raise error, if not same
  rm_func  "out.txt"
}


 







 
#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
