/*
	Auther:		Satoshi Yasuda	7m3tjz/ad6gz
*/

#include	"dsgwd_pi.h"
#include	"dprs.h"


void	config(int argc, char **argv)
{
	char	buff[128];
	char	*delmi = "=\n\r\t\0";
	char	*delmit = "\n\r\t\0";
	char	*pnt;
	FILE	*config_file;
	int	len;

	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			logfile = fopen (LOGFILE, "a");
			now = time(NULL);
			fprintf (logfile, "%24.24s config file not found (%s)\n", ctime(&now), argv[1]);
			fclose (logfile);
			exit (1);
		}
	} 
	else
	{
		config_file = fopen ("/etc/dsgwd_pi.conf","r");
		if (!config_file)
		{
			logfile = fopen (LOGFILE, "a");
			now = time(NULL);
			fprintf (logfile, "%24.24s config file not found (/etc/dsgwd_pi.conf)\n", 
				ctime(&now));
			fclose (logfile);
			exit (1);
		}
	}

	while (fgets (buff, 127, config_file))
	{
		if (buff[0] != '#')
		{
			pnt = strtok(buff, delmi);
			pnt = strtok(NULL, delmit);

			if (!memcmp (buff, "REPEATER_CALL", 13))
			{
                                memset (client_call, 0x20, 8);
				len = strlen(pnt);
				if (len > 8) len = 8;
                                memcpy (client_call, pnt, len);
			}
			else if (!memcmp (buff, "PASSWORD", 8))
			{
				memset (client_password, 0x00, 64);
				memcpy (client_password, pnt, strlen(pnt));
			}
                        else if (!memcmp (buff, "TRUST_DOMAIN_NAME", 17))
                        {
                                memset (TrustDomainName, 0x00, 128);
                                memcpy (TrustDomainName, pnt, strlen(pnt));
                        }
                        else if (!memcmp (buff, "TRUST_DB_DOMAIN_NAME", 20))
                        {
                                memset (TrustDbDomainName, 0x00, 128);
                                memcpy (TrustDbDomainName, pnt, strlen(pnt));
                        }
                        else if (!memcmp (buff, "REPEATER_MODE", 13))
                        {
                                if (memcmp (pnt, "YES", 3) == 0)
					repeater_mode = 1;
                        }
			else if (!memcmp (buff, "CMD_MODE", 8))
			{
				/* 0 stdin */
				/* 1 fifo  */
				cmdmode = atoi (pnt);
			}
			else if (!memcmp (buff, "PORT", 4))
			{
				client_port = atoi(pnt);
			}
                        else if (!memcmp (buff, "TRUST_PORT", 10))
                        {
                                trust_port = htons(atoi(pnt));
                        }
			else if (!memcmp (buff, "TRUST_DB_PORT", 13))
			{
				trust_db_port = htons(atoi(pnt));
			}
                        else if (!memcmp (buff, "NODE_ADAPTER_VENDOR_ID", 22))
                        {
                                NodeVendorID = atoi(pnt);
                        }
			else if (!memcmp (buff, "NODE_ADAPTER_PRODUCT_ID", 23))
                        {
                                NodeProductID = atoi(pnt);
                        }
                        else if (!memcmp (buff, "CALL_CHECK", 10))
                        {
                                if (atoi(pnt)) CallCheck = TRUE;
                        }
			/* DPRS  Setting */
                        else if (!memcmp (buff, "DPRS_MODE", 9))
                        {
                                if (atoi(pnt)) DPRS.DprsSW = TRUE;
                        }
                        else if (!memcmp (buff, "DPRS_STRIP", 10))
                        {
                                if (atoi(pnt)) DPRS.DprsStrip = TRUE;
                        }
			else if (!memcmp (buff, "APRS_SERVER_DOMAIN_NAME", 23))
			{
                                memset (DPRS.AprsServerDomainName, 0x00, 128);
                                memcpy (DPRS.AprsServerDomainName, pnt, strlen(pnt));
			}
                        else if (!memcmp (buff, "APRS_SERVER_PORT", 16))
                        {
				DPRS.Port = htons(atoi(pnt));
                        }
			else if (!memcmp (buff, "APRS_STATION_CALLSIGN", 21))
			{
				memset (DPRS.CallSign, 0x00, 8);
				memcpy (DPRS.CallSign, pnt, strlen(pnt));
			}
                        else if (!memcmp (buff, "APRS_STATION_VALIDATION_CODE", 28))
                        {
				memset (DPRS.ValidCode, 0x00, 8);
				memcpy (DPRS.ValidCode, pnt, strlen(pnt));
                        }
			else if (!memcmp (buff, "APRS_STATION_BEACON_INTERVAL", 28))
                        {
                                DPRS.Interval = atoi(pnt);
                        }
                        else if (!memcmp (buff, "APRS_STATION_COMMENT", 20))
                        {
                                memset (DPRS.Comment, 0x00, 20);
                                memcpy (DPRS.Comment, pnt, strlen(pnt));
                        }
                        else if (!memcmp (buff, "APRS_STATION_LATITUDE", 21))
                        {
				DPRS.Lat = atof(pnt) * 10000;
                        }
                        else if (!memcmp (buff, "APRS_STATION_LONGITUDE", 22))
                        {
				DPRS.Long = atof(pnt) * 10000;
                        }
			else if (!memcmp (buff, "APRS_STATION_BEACON_SEND", 24))
			{
				DPRS.ClientID = FALSE;
				if (!memcmp (pnt, "ON", 2)) DPRS.ClientID = TRUE;
			}
		}
	}
	fclose (config_file);
}
