/*
 *  Aramaki Online
 *  Copyright (C) 2005 - 2011  superbacker
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

package net.scaltinof.aramaki.client.engine3d.objects.avatar;

import net.scaltinof.aramaki.client.engine3d.core.Object3D;
import net.scaltinof.aramaki.client.engine3d.core.Renderer;
import net.scaltinof.aramaki.client.engine3d.geom.Vector2D;
import net.scaltinof.aramaki.client.engine3d.geom.Vector3;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;

public class Avatar extends Object3D {
	private final String DEFAULT_NAME = "名無しさん";
	
	private final Sprite sprite = new Sprite("aramaki.png", new Vector2D(62, 37), new Vector2D(0.5, 0));
	private AvatarOverlay overlay;
	
	public Avatar(Logger logger) {
		overlay = new AvatarOverlay(logger);
		setName("");
	}
	
	public Avatar(Logger logger, String name, String balloon) {
		overlay = new AvatarOverlay(logger);
		setName(name);
		setBalloon(balloon);
	}
	
	public void setName(String name) {
		if (name.length() == 0) {
			name = DEFAULT_NAME;
		}
		
		overlay.setName(name);
		updateOverlayPositionLater();
	}
	
	public void setBalloon(String balloon) {
		overlay.setBalloon(balloon);
		updateOverlayPositionLater();
	}
	
	private void updateOverlayPositionLater() {
		if (isAddedToSpace()) {
			Scheduler.get().scheduleDeferred(new ScheduledCommand() {
				@Override
				public void execute() {
					updateOverlayPosition();
				}
			});
		}
	}
	
	private void updateOverlayPosition() {
		final Vector2D center = new Vector2D(overlay.getOffsetWidth() / 2, overlay.getOffsetHeight());
		
		final Vector3 overlayPosition = new Vector3(getPosition());
		overlayPosition.y += sprite.height() + 10;
		getRenderer().updateOverlayPosition(overlay, overlayPosition, center);
	}
	
	@Override
	public void setPosition(Vector3 position) {
		super.setPosition(position);
		updateOverlayPosition();
	}

	@Override
	public void attachTo(Renderer renderer) {
		super.attachTo(renderer);
		renderer.attachSprite(this, getMatrix(), sprite);
		renderer.addOverlay(overlay);
		updateOverlayPositionLater();
	}
	
	@Override
	public void detachFromRenderer() {
		final Renderer renderer = getRenderer();
		renderer.removeOverlay(overlay);
		renderer.detachSprite(this);
		super.detachFromRenderer();
	}
}
