/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is automagically generated by hashgen, do not edit

/** \file IID_to_MPH.c Interface ID to MPH mapping */

#include <SLES/OpenSLES.h>
#include "MPH.h"
#include <assert.h>
#include <string.h>

extern const struct SLInterfaceID_ SL_IID_array[MPH_MAX];

/** \brief Map SLInterfaceID to its minimal perfect hash (MPH), or -1 if unknown */

int IID_to_MPH(const SLInterfaceID iid)
{
#define MAX_HASH_VALUE 180
  static const unsigned char asso_values[] =
    {
       35,  20,  54,  84, 181, 181,  59, 181, 181, 181,
      181, 181, 181, 181,  69, 181,  64,  44, 181, 181,
      181, 181,  39, 181,  54,  14, 181, 181,  14, 181,
      181, 125,   5, 181, 181, 181, 181, 181, 181, 181,
      127, 181, 181, 181,   9, 181, 112, 181, 181, 181,
      181, 181, 122, 181, 181, 181, 181, 181,  14, 100,
      181,   9,  24, 181,  50, 181, 181, 181, 181, 117,
      181, 181,  97,  85, 181, 181, 181, 181, 181, 181,
      181, 181, 181, 181, 181, 181, 117, 181,  19, 181,
      181, 181,   9, 181, 181, 181,  25, 181,  14, 102,
      181, 181, 181, 181, 181, 181, 181,   4, 181,  97,
      181, 181,   0, 181,   4,  92, 117, 181,  67,  45,
      181, 181, 110, 181, 181, 181,  72, 181,  40, 181,
      181, 181, 181, 181, 181, 102,  52, 181, 181, 181,
      181, 181,  57,  67, 181,  62, 181, 125, 181, 181,
      181, 181, 181,  82, 181, 181,  72, 181, 181,  65,
        5, 181,  32, 181, 181,  67, 120, 181, 181,  37,
      181,  57,  55, 181, 181,  47, 181,  45, 181, 181,
      181, 181,   7, 181,  17,  30, 181, 181, 181, 181,
      181, 181,   0, 181, 181, 181, 105,  32, 181, 181,
      181, 181, 181, 181, 181, 181, 115, 181, 181, 181,
       95,  32, 181, 181, 181,  22, 181, 181,   2, 181,
      181, 181, 181,  12,  10, 181, 181,  12, 181, 181,
      181, 181, 181, 181,   2, 181,  70, 181, 181, 181,
       10,   2, 181, 181,  70, 181, 120, 115, 181, 181,
      181,  80, 105, 100, 181, 181
    };
    static const signed char hash_to_MPH[] = {
        MPH_ANDROIDEFFECTSEND,
        -1,
        MPH_XADYNAMICINTERFACEMANAGEMENT,
        -1,
        MPH_XAAUDIODECODERCAPABILITIES,
        MPH_XALED,
        -1,
        MPH_XATHREADSYNC,
        -1,
        MPH_XAOUTPUTMIX,
        MPH_MIDITIME,
        -1,
        MPH_XAIMAGECONTROLS,
        -1,
        MPH_AUDIOIODEVICECAPABILITIES,
        MPH_MUTESOLO,
        -1,
        MPH_XAVOLUME,
        -1,
        MPH_ANDROIDCONFIGURATION,
        MPH_XASNAPSHOT,
        -1,
        MPH_XAPLAY,
        -1,
        MPH_SEEK,
        MPH_3DLOCATION,
        -1,
        MPH_XACONFIGEXTENSION,
        -1,
        MPH_XAIMAGEDECODERCAPABILITIES,
        MPH_XACAMERACAPABILITIES,
        -1,
        MPH_3DMACROSCOPIC,
        -1,
        MPH_VIBRA,
        MPH_XAIMAGEEFFECTS,
        -1,
        MPH_XAMETADATAEXTRACTION,
        -1,
        MPH_PRESETREVERB,
        MPH_XAOBJECT,
        -1,
        MPH_RATEPITCH,
        -1,
        MPH_PITCH,
        MPH_XAVIBRA,
        -1,
        MPH_XARADIO,
        -1,
        MPH_OUTPUTMIXEXT,
        MPH_ENGINECAPABILITIES,
        -1,
        MPH_XAVIDEOPOSTPROCESSING,
        -1,
        MPH_3DCOMMIT,
        MPH_XAVIDEODECODERCAPABILITIES,
        -1,
        MPH_METADATATRAVERSAL,
        -1,
        MPH_XASEEK,
        MPH_AUDIODECODERCAPABILITIES,
        -1,
        MPH_DEVICEVOLUME,
        -1,
        MPH_OBJECT,
        MPH_ENVIRONMENTALREVERB,
        -1,
        MPH_XARDS,
        -1,
        MPH_XAVIDEOENCODER,
        MPH_OUTPUTMIX,
        -1,
        MPH_XADYNAMICSOURCE,
        -1,
        MPH_3DGROUPING,
        MPH_XASTREAMINFORMATION,
        -1,
        MPH_XAPREFETCHSTATUS,
        -1,
        MPH_XAMETADATATRAVERSAL,
        MPH_VIRTUALIZER,
        -1,
        MPH_BUFFERQUEUE,
        -1,
        MPH_ANDROIDBUFFERQUEUESOURCE,
        MPH_PLAY,
        -1,
        MPH_XAMETADATAINSERTION,
        -1,
        MPH_XADEVICEVOLUME,
        MPH_XAVIDEOENCODERCAPABILITIES,
        -1,
        MPH_ENGINE,
        -1,
        MPH_MIDIMUTESOLO,
        MPH_XAEQUALIZER,
        -1,
        MPH_METADATAEXTRACTION,
        -1,
        -1,
        MPH_XARECORD,
        -1,
        MPH_XAIMAGEENCODER,
        -1,
        -1,
        MPH_VISUALIZATION,
        -1,
        MPH_XACAMERA,
        -1,
        -1,
        MPH_BASSBOOST,
        -1,
        MPH_LED,
        -1,
        -1,
        MPH_EFFECTSEND,
        -1,
        MPH_XAENGINE,
        -1,
        -1,
        MPH_RECORD,
        -1,
        MPH_MIDIMESSAGE,
        -1,
        -1,
        MPH_ANDROIDEFFECTCAPABILITIES,
        -1,
        MPH_3DSOURCE,
        -1,
        -1,
        MPH_VOLUME,
        -1,
        MPH_XAAUDIOENCODERCAPABILITIES,
        -1,
        -1,
        MPH_PLAYBACKRATE,
        -1,
        MPH_XAAUDIOIODEVICECAPABILITIES,
        -1,
        -1,
        MPH_NULL,
        -1,
        MPH_ANDROIDEFFECT,
        -1,
        -1,
        MPH_XAIMAGEENCODERCAPABILITIES,
        -1,
        MPH_XAPLAYBACKRATE,
        -1,
        -1,
        MPH_MIDITEMPO,
        -1,
        MPH_DYNAMICSOURCE,
        -1,
        -1,
        MPH_DYNAMICINTERFACEMANAGEMENT,
        -1,
        MPH_EQUALIZER,
        -1,
        -1,
        MPH_XAAUDIOENCODER,
        -1,
        MPH_THREADSYNC,
        -1,
        -1,
        MPH_PREFETCHSTATUS,
        -1,
        MPH_3DDOPPLER,
        -1,
        -1,
        MPH_ANDROIDSIMPLEBUFFERQUEUE,
        -1,
        -1,
        -1,
        -1,
        MPH_AUDIOENCODERCAPABILITIES,
        -1,
        -1,
        -1,
        -1,
        MPH_AUDIOENCODER
    };
    if (&SL_IID_array[0] <= iid && &SL_IID_array[MPH_MAX] > iid)
        return iid - &SL_IID_array[0];
    if (NULL != iid) {
        static const unsigned len = sizeof(struct SLInterfaceID_);
        unsigned key = asso_values[((unsigned char *)iid)[8]] +
            asso_values[((unsigned char *)iid)[0]];
        if (key <= MAX_HASH_VALUE) {
            int MPH = hash_to_MPH[key];
            if (MPH >= 0) {
                assert(MPH < MPH_MAX);
                SLInterfaceID trial = &SL_IID_array[MPH];
                if (!memcmp(iid, trial, sizeof(struct SLInterfaceID_)))
                    return MPH;
            }
        }
    }
    return -1;
}
