/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* AndroidConfiguration implementation */

#include "sles_allinclusive.h"


static SLresult IAndroidConfiguration_SetConfiguration(SLAndroidConfigurationItf self,
        const SLchar *configKey,
        const void *pConfigValue,
        SLuint32 valueSize)
{
    SL_ENTER_INTERFACE

    IAndroidConfiguration *this = (IAndroidConfiguration *) self;
    interface_lock_exclusive(this);

    // route key configuration to the appropriate object
    // FIXME implement
#if 0
    // is SLAndroidConfigurationItf on an AudioPlayer?
    CAudioPlayer *ap = (SL_OBJECTID_AUDIOPLAYER == InterfaceToObjectID(this)) ?
            (CAudioPlayer *) this->mThis : NULL;
#endif
    result = SL_RESULT_SUCCESS;

    interface_unlock_exclusive(this);

    SL_LEAVE_INTERFACE
}


static SLresult IAndroidConfiguration_GetConfiguration(SLAndroidConfigurationItf self,
        const SLchar *configKey,
        SLuint32 *pValueSize,
        void *pConfigValue)
{
    SL_ENTER_INTERFACE

    if (NULL == configKey) {
        result = SL_RESULT_PARAMETER_INVALID;
    } else {
        IAndroidConfiguration *this = (IAndroidConfiguration *) self;
        interface_lock_shared(this);
        // route key configuration to the appropriate object
        // FIXME implement
        result = SL_RESULT_SUCCESS;

        interface_unlock_shared(this);
    }

    SL_LEAVE_INTERFACE
}


static const struct SLAndroidConfigurationItf_ IAndroidConfiguration_Itf = {
    IAndroidConfiguration_SetConfiguration,
    IAndroidConfiguration_GetConfiguration
};

void IAndroidConfiguration_init(void *self)
{
    IAndroidConfiguration *this = (IAndroidConfiguration *) self;
    this->mItf = &IAndroidConfiguration_Itf;
}
