# Copyright (C) 2009 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

LOCAL_PATH := $(call my-dir)

##
# Build native code
##
include $(CLEAR_VARS)

LOCAL_MODULE_TAGS := optional

LOCAL_MODULE := libfilterpack_imageproc

LOCAL_SRC_FILES += native/brightness.c \
                   native/contrast.c \
                   native/invert.c \
                   native/to_rgba.c

LOCAL_SHARED_LIBRARIES := libutils libfilterfw2

LOCAL_PRELINK_MODULE := false

include $(LOCAL_PATH)/../../filterfw/native/filterfw_ndk.mk

include $(BUILD_SHARED_LIBRARY)

##
# Build java lib
##
include $(CLEAR_VARS)
LOCAL_PATH:= $(TOP_LOCAL_PATH)

include $(CLEAR_VARS)

LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES := $(call all-subdir-java-files)

LOCAL_MODULE := filterpack_imageproc

LOCAL_PROGUARD_ENABLED := disabled

LOCAL_STATIC_JAVA_LIBRARIES := filterfw

LOCAL_JNI_SHARED_LIBRARIES := libfilterpack_imageproc

include $(BUILD_STATIC_JAVA_LIBRARY)

