# Helper script to let mksh/Build.sh generate Makefrag.inc
# which we in turn use in the manual creation of Android.mk
#
# This script is supposed to be run from the NDK root
# directory, like so: sh .../system/core/sh/mkmf.sh

ndkdir=$(pwd)
cd "$(dirname "$0")"
srcdir=$(pwd)
rm -rf tmp
mkdir tmp
cp *.c tmp/
cd tmp

addvar() {
	_vn=$1; shift

	eval $_vn=\"\$$_vn '$*"'
}

CFLAGS=
CPPFLAGS=
LDFLAGS=
LIBS=

# These are added manually.
addvar LIBS arc4rootdom.c				# disable for mksh-small

# The definitions below were generated by examining the
# output of the following command in the NDK root directory:
# make APP=hello-native V=1 2>&1 | tee log
#
# They are only used to let Build.sh find the compiler, header
# files, linker and libraries to generate Makefrag.inc (similar
# to what GNU autotools’ configure scripts do), and never used
# during the real build process. We need this to port mksh to
# the Android platform and it is crucial these are as close as
# possible to the values used later. (You also must example the
# results gathered from Makefrag.inc to see they are the same
# across all Android platforms, or add appropriate ifdefs.)
#
# Note: someone might want to change this to use the headers
# and libraries built during the last run of the SDK make.

_platpath=$ndkdir/build/platforms/android-3/arch-arm
_gccpath=$ndkdir/build/prebuilt/linux-x86/arm-eabi-4.2.1/bin

# from compiling
CC=$_gccpath/arm-eabi-gcc
addvar CPPFLAGS -I$_platpath/usr/include
addvar CFLAGS -march=armv5te -mtune=xscale -msoft-float -fpic \
    -mthumb-interwork -ffunction-sections -funwind-tables \
    -fno-short-enums #-fstack-protector see below for Android-x86 note
addvar CPPFLAGS -D__ARM_ARCH_5__ -D__ARM_ARCH_5T__ -D__ARM_ARCH_5E__ \
    -D__ARM_ARCH_5TE__
addvar CFLAGS -mthumb -Os -fomit-frame-pointer -fno-strict-aliasing \
    -finline-limit=64
addvar CPPFLAGS -DANDROID -DNDEBUG

# from linking
addvar LDFLAGS -nostdlib -Bdynamic -Wl,-dynamic-linker,/system/bin/linker \
    -Wl,--gc-sections -Wl,-z,nocopyreloc
addvar LIBS -L$_platpath/usr/lib -lc
#addvar LIBS -lstdc++		# not needed for mksh
#addvar LIBS -lm		# not needed for mksh
addvar LDFLAGS $_platpath/usr/lib/crtbegin_dynamic.o
addvar LDFLAGS -Wl,--no-undefined -Wl,-rpath-link=$_platpath/usr/lib
addvar LIBS $_gccpath/../lib/gcc/arm-eabi/4.2.1/interwork/libgcc.a
addvar LIBS $_platpath/usr/lib/crtend_android.o


### Override flags
# We don’t even *support* UTF-8 by default ☹
addvar CPPFLAGS -DMKSH_ASSUME_UTF8=0
# Add printf as a builtin, like other shells do (optional)
USE_PRINTF_BUILTIN=1; export USE_PRINTF_BUILTIN		# disable for mksh-small
# Disable printf’s floating point stuff
addvar CPPFLAGS -DNO_STRTOD				# disable for mksh-small
# No getpwnam() calls (affects "cd ~username/" only)
addvar CPPFLAGS -DMKSH_NOPWNAM				# disable for mksh-small
# Compile an extra small mksh (optional)
#addvar CPPFLAGS -DMKSH_SMALL				# enable for mksh-small
# Leave out the ulimit builtin
#addvar CPPFLAGS -DMKSH_NO_LIMITS			# enable for mksh-small

# Set target platform
TARGET_OS=Linux
# Building with -std=c99 or -std=gnu99 clashes with Bionic headers
HAVE_CAN_STDG99=0
HAVE_CAN_STDC99=0
export HAVE_CAN_STDG99 HAVE_CAN_STDC99

# Android-x86 does not have helper functions for ProPolice SSP
HAVE_CAN_FSTACKPROTECTORALL=0; export HAVE_CAN_FSTACKPROTECTORALL

# Android-current has sys_signame[] but NDK 1.5 doesn’t,
# so override (comment this out if building for 1.[56])
HAVE_SYS_SIGNAME=1; export HAVE_SYS_SIGNAME

# disable the mknod(8) built-in to get rid of needing setmode.c
HAVE_MKNOD=0; export HAVE_MKNOD=0

# ... and run it!
export CC CPPFLAGS CFLAGS LDFLAGS LIBS TARGET_OS
sh ../mksh/Build.sh -M
rv=$?
test x0 = x"$rv" && mv -f Makefrag.inc ../
cd ..
rm -rf tmp
exit $rv
