/*
 * Copyright (C) 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <vector>

#include <gtest/gtest.h>

#include "wificond/scanning/scan_result.h"

using ::com::android::server::wifi::wificond::NativeScanResult;
using std::vector;

namespace android {
namespace wificond {

namespace {


const uint8_t kFakeSsid[] =
    {'G', 'o', 'o', 'g', 'l', 'e', 'G', 'u', 'e', 's', 't'};
const uint8_t kFakeBssid[] = {0x45, 0x54, 0xad, 0x67, 0x98, 0xf6};
const uint8_t kFakeIE[] = {0x05, 0x11, 0x32, 0x11};
constexpr uint32_t kFakeFrequency = 5240;
constexpr int32_t kFakeSignalMbm= -32;
constexpr uint64_t kFakeTsf = 1200;
constexpr int16_t kFakeCapability = 0;
constexpr bool kFakeAssociated = true;

}  // namespace

class ScanResultTest : public ::testing::Test {
};

TEST_F(ScanResultTest, ParcelableTest) {
  std::vector<uint8_t> ssid(kFakeSsid, kFakeSsid + sizeof(kFakeSsid));
  std::vector<uint8_t> bssid(kFakeBssid, kFakeBssid + sizeof(kFakeBssid));
  std::vector<uint8_t> ie(kFakeIE, kFakeIE + sizeof(kFakeIE));

  NativeScanResult scan_result(ssid, bssid, ie, kFakeFrequency,
      kFakeSignalMbm, kFakeTsf, kFakeCapability, kFakeAssociated);
  Parcel parcel;
  EXPECT_EQ(::android::OK, scan_result.writeToParcel(&parcel));

  NativeScanResult scan_result_copy;
  parcel.setDataPosition(0);
  EXPECT_EQ(::android::OK, scan_result_copy.readFromParcel(&parcel));

  EXPECT_EQ(ssid, scan_result_copy.ssid);
  EXPECT_EQ(bssid, scan_result_copy.bssid);
  EXPECT_EQ(ie, scan_result_copy.info_element);
  EXPECT_EQ(kFakeFrequency, scan_result_copy.frequency);
  EXPECT_EQ(kFakeSignalMbm, scan_result_copy.signal_mbm);
  EXPECT_EQ(kFakeTsf, scan_result_copy.tsf);
  EXPECT_EQ(kFakeCapability, scan_result_copy.capability);
  EXPECT_EQ(kFakeAssociated, scan_result_copy.associated);
}

}  // namespace wificond
}  // namespace android
