/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#include <cstdint>

namespace test_vendor_lib {
namespace hci {

using CommandGroups = enum {
  LINK_CONTROL = 0x01 << 10,             /* 0x0400 */
  LINK_POLICY = 0x02 << 10,              /* 0x0800 */
  CONTROLLER_AND_BASEBAND = 0x03 << 10,  /* 0x0C00 */
  INFORMATIONAL_PARAMETERS = 0x04 << 10, /* 0x1000 */
  STATUS_PARAMETERS = 0x05 << 10,        /* 0x1400 */
  TESTING = 0x06 << 10,                  /* 0x1800 */
  LE_CONTROLLER = 0x08 << 10,            /* 0x2000 */
  VENDOR_SPECIFIC = 0x3F << 10,          /* 0xFC00 */
};

enum class OpCode : uint16_t {
  NONE = 0x0000,

  /* LINK_CONTROL */
  INQUIRY = LINK_CONTROL | 0x0001,
  INQUIRY_CANCEL = LINK_CONTROL | 0x0002,
  PERIODIC_INQUIRY_MODE = LINK_CONTROL | 0x0003,
  EXIT_PERIODIC_INQUIRY_MODE = LINK_CONTROL | 0x0004,
  CREATE_CONNECTION = LINK_CONTROL | 0x0005,
  DISCONNECT = LINK_CONTROL | 0x0006,
  CREATE_CONNECTION_CANCEL = LINK_CONTROL | 0x0008,
  ACCEPT_CONNECTION_REQUEST = LINK_CONTROL | 0x0009,
  REJECT_CONNECTION_REQUEST = LINK_CONTROL | 0x000A,
  LINK_KEY_REQUEST_REPLY = LINK_CONTROL | 0x000B,
  LINK_KEY_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x000C,
  PIN_CODE_REQUEST_REPLY = LINK_CONTROL | 0x000D,
  PIN_CODE_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x000E,
  CHANGE_CONNECTION_PACKET_TYPE = LINK_CONTROL | 0x000F,
  AUTHENTICATION_REQUESTED = LINK_CONTROL | 0x0011,
  SET_CONNECTION_ENCRYPTION = LINK_CONTROL | 0x0013,
  CHANGE_CONNECTION_LINK_KEY = LINK_CONTROL | 0x0015,
  MASTER_LINK_KEY = LINK_CONTROL | 0x0017,
  REMOTE_NAME_REQUEST = LINK_CONTROL | 0x0019,
  REMOTE_NAME_REQUEST_CANCEL = LINK_CONTROL | 0x001A,
  READ_REMOTE_SUPPORTED_FEATURES = LINK_CONTROL | 0x001B,
  READ_REMOTE_EXTENDED_FEATURES = LINK_CONTROL | 0x001C,
  READ_REMOTE_VERSION_INFORMATION = LINK_CONTROL | 0x001D,
  READ_CLOCK_OFFSET = LINK_CONTROL | 0x001F,
  READ_LMP_HANDLE = LINK_CONTROL | 0x0020,
  SETUP_SYNCHRONOUS_CONNECTION = LINK_CONTROL | 0x0028,
  ACCEPT_SYNCHRONOUS_CONNECTION = LINK_CONTROL | 0x0029,
  REJECT_SYNCHRONOUS_CONNECTION = LINK_CONTROL | 0x002A,
  IO_CAPABILITY_REQUEST_REPLY = LINK_CONTROL | 0x002B,
  USER_CONFIRMATION_REQUEST_REPLY = LINK_CONTROL | 0x002C,
  USER_CONFIRMATION_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x002D,
  USER_PASSKEY_REQUEST_REPLY = LINK_CONTROL | 0x002E,
  USER_PASSKEY_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x002F,
  REMOTE_OOB_DATA_REQUEST_REPLY = LINK_CONTROL | 0x0030,
  REMOTE_OOB_DATA_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x0033,
  IO_CAPABILITY_REQUEST_NEGATIVE_REPLY = LINK_CONTROL | 0x0034,
  ENHANCED_SETUP_SYNCHRONOUS_CONNECTION = LINK_CONTROL | 0x003D,
  ENHANCED_ACCEPT_SYNCHRONOUS_CONNECTION = LINK_CONTROL | 0x003E,

  /* LINK_POLICY */
  HOLD_MODE = LINK_POLICY | 0x0001,
  SNIFF_MODE = LINK_POLICY | 0x0003,
  EXIT_SNIFF_MODE = LINK_POLICY | 0x0004,
  QOS_SETUP = LINK_POLICY | 0x0007,
  ROLE_DISCOVERY = LINK_POLICY | 0x0009,
  SWITCH_ROLE = LINK_POLICY | 0x000B,
  READ_LINK_POLICY_SETTINGS = LINK_POLICY | 0x000C,
  WRITE_LINK_POLICY_SETTINGS = LINK_POLICY | 0x000D,
  READ_DEFAULT_LINK_POLICY_SETTINGS = LINK_POLICY | 0x000E,
  WRITE_DEFAULT_LINK_POLICY_SETTINGS = LINK_POLICY | 0x000F,
  FLOW_SPECIFICATION = LINK_POLICY | 0x0010,
  SNIFF_SUBRATING = LINK_POLICY | 0x0011,

  /* CONTROLLER_AND_BASEBAND */
  SET_EVENT_MASK = CONTROLLER_AND_BASEBAND | 0x0001,
  RESET = CONTROLLER_AND_BASEBAND | 0x0003,
  SET_EVENT_FILTER = CONTROLLER_AND_BASEBAND | 0x0005,
  FLUSH = CONTROLLER_AND_BASEBAND | 0x0008,
  READ_PIN_TYPE = CONTROLLER_AND_BASEBAND | 0x0009,
  WRITE_PIN_TYPE = CONTROLLER_AND_BASEBAND | 0x000A,
  CREATE_NEW_UNIT_KEY = CONTROLLER_AND_BASEBAND | 0x000B,
  READ_STORED_LINK_KEY = CONTROLLER_AND_BASEBAND | 0x000D,
  WRITE_STORED_LINK_KEY = CONTROLLER_AND_BASEBAND | 0x0011,
  DELETE_STORED_LINK_KEY = CONTROLLER_AND_BASEBAND | 0x0012,
  WRITE_LOCAL_NAME = CONTROLLER_AND_BASEBAND | 0x0013,
  READ_LOCAL_NAME = CONTROLLER_AND_BASEBAND | 0x0014,
  READ_CONNECTION_ACCEPT_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0015,
  WRITE_CONNECTION_ACCEPT_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0016,
  READ_PAGE_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0017,
  WRITE_PAGE_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0018,
  READ_SCAN_ENABLE = CONTROLLER_AND_BASEBAND | 0x0019,
  WRITE_SCAN_ENABLE = CONTROLLER_AND_BASEBAND | 0x001A,
  READ_PAGE_SCAN_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x001B,
  WRITE_PAGE_SCAN_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x001C,
  READ_INQUIRY_SCAN_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x001D,
  WRITE_INQUIRY_SCAN_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x001E,
  READ_AUTHENTICATION_ENABLE = CONTROLLER_AND_BASEBAND | 0x001F,
  WRITE_AUTHENTICATION_ENABLE = CONTROLLER_AND_BASEBAND | 0x0020,
  READ_CLASS_OF_DEVICE = CONTROLLER_AND_BASEBAND | 0x0023,
  WRITE_CLASS_OF_DEVICE = CONTROLLER_AND_BASEBAND | 0x0024,
  READ_VOICE_SETTING = CONTROLLER_AND_BASEBAND | 0x0025,
  WRITE_VOICE_SETTING = CONTROLLER_AND_BASEBAND | 0x0026,
  READ_AUTOMATIC_FLUSH_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0027,
  WRITE_AUTOMATIC_FLUSH_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0028,
  READ_NUM_BROADCAST_RETRANSMITS = CONTROLLER_AND_BASEBAND | 0x0029,
  WRITE_NUM_BROADCAST_RETRANSMITS = CONTROLLER_AND_BASEBAND | 0x002A,
  READ_HOLD_MODE_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x002B,
  WRITE_HOLD_MODE_ACTIVITY = CONTROLLER_AND_BASEBAND | 0x002C,
  READ_TRANSMIT_POWER_LEVEL = CONTROLLER_AND_BASEBAND | 0x002D,
  READ_SYNCHRONOUS_FLOW_CONTROL_ENABLE = CONTROLLER_AND_BASEBAND | 0x002E,
  WRITE_SYNCHRONOUS_FLOW_CONTROL_ENABLE = CONTROLLER_AND_BASEBAND | 0x002F,
  SET_CONTROLLER_TO_HOST_FLOW_CONTROL = CONTROLLER_AND_BASEBAND | 0x0031,
  HOST_BUFFER_SIZE = CONTROLLER_AND_BASEBAND | 0x0033,
  HOST_NUM_COMPLETED_PACKETS = CONTROLLER_AND_BASEBAND | 0x0035,
  READ_LINK_SUPERVISION_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0036,
  WRITE_LINK_SUPERVISION_TIMEOUT = CONTROLLER_AND_BASEBAND | 0x0037,
  READ_NUMBER_OF_SUPPORTED_IAC = CONTROLLER_AND_BASEBAND | 0x0038,
  READ_CURRENT_IAC_LAP = CONTROLLER_AND_BASEBAND | 0x0039,
  WRITE_CURRENT_IAC_LAP = CONTROLLER_AND_BASEBAND | 0x003A,
  SET_AFH_HOST_CHANNEL_CLASSIFICATION = CONTROLLER_AND_BASEBAND | 0x003F,
  READ_LE_HOST_SUPPORT = CONTROLLER_AND_BASEBAND | 0x6C,
  WRITE_LE_HOST_SUPPORT = CONTROLLER_AND_BASEBAND | 0x6D,
  READ_INQUIRY_SCAN_TYPE = CONTROLLER_AND_BASEBAND | 0x0042,
  WRITE_INQUIRY_SCAN_TYPE = CONTROLLER_AND_BASEBAND | 0x0043,
  READ_INQUIRY_MODE = CONTROLLER_AND_BASEBAND | 0x0044,
  WRITE_INQUIRY_MODE = CONTROLLER_AND_BASEBAND | 0x0045,
  READ_PAGE_SCAN_TYPE = CONTROLLER_AND_BASEBAND | 0x0046,
  WRITE_PAGE_SCAN_TYPE = CONTROLLER_AND_BASEBAND | 0x0047,
  READ_AFH_CHANNEL_ASSESSMENT_MODE = CONTROLLER_AND_BASEBAND | 0x0048,
  WRITE_AFH_CHANNEL_ASSESSMENT_MODE = CONTROLLER_AND_BASEBAND | 0x0049,
  READ_EXTENDED_INQUIRY_RESPONSE = CONTROLLER_AND_BASEBAND | 0x0051,
  WRITE_EXTENDED_INQUIRY_RESPONSE = CONTROLLER_AND_BASEBAND | 0x0052,
  REFRESH_ENCRYPTION_KEY = CONTROLLER_AND_BASEBAND | 0x0053,
  READ_SIMPLE_PAIRING_MODE = CONTROLLER_AND_BASEBAND | 0x0055,
  WRITE_SIMPLE_PAIRING_MODE = CONTROLLER_AND_BASEBAND | 0x0056,
  READ_LOCAL_OOB_DATA = CONTROLLER_AND_BASEBAND | 0x0057,
  READ_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL = CONTROLLER_AND_BASEBAND | 0x0058,
  WRITE_INQUIRY_TRANSMIT_POWER_LEVEL = CONTROLLER_AND_BASEBAND | 0x0059,
  SEND_KEYPRESS_NOTIFICATION = CONTROLLER_AND_BASEBAND | 0x0060,

  READ_SECURE_CONNECTIONS_HOST_SUPPORT = CONTROLLER_AND_BASEBAND | 0x0079,
  WRITE_SECURE_CONNECTIONS_HOST_SUPPORT = CONTROLLER_AND_BASEBAND | 0x007A,

  /* INFORMATIONAL_PARAMETERS */
  READ_LOCAL_VERSION_INFORMATION = INFORMATIONAL_PARAMETERS | 0x0001,
  READ_LOCAL_SUPPORTED_COMMANDS = INFORMATIONAL_PARAMETERS | 0x0002,
  READ_LOCAL_SUPPORTED_FEATURES = INFORMATIONAL_PARAMETERS | 0x0003,
  READ_LOCAL_EXTENDED_FEATURES = INFORMATIONAL_PARAMETERS | 0x0004,
  READ_BUFFER_SIZE = INFORMATIONAL_PARAMETERS | 0x0005,
  READ_BD_ADDR = INFORMATIONAL_PARAMETERS | 0x0009,
  READ_DATA_BLOCK_SIZE = INFORMATIONAL_PARAMETERS | 0x000A,
  READ_LOCAL_SUPPORTED_CODECS = INFORMATIONAL_PARAMETERS | 0x000B,

  /* STATUS_PARAMETERS */
  READ_FAILED_CONTACT_COUNTER = STATUS_PARAMETERS | 0x0001,
  RESET_FAILED_CONTACT_COUNTER = STATUS_PARAMETERS | 0x0002,
  READ_LINK_QUALITY = STATUS_PARAMETERS | 0x0003,
  READ_RSSI = STATUS_PARAMETERS | 0x0005,
  READ_AFH_CHANNEL_MAP = STATUS_PARAMETERS | 0x0006,
  READ_CLOCK = STATUS_PARAMETERS | 0x0007,
  READ_ENCRYPTION_KEY_SIZE = STATUS_PARAMETERS | 0x0008,

  /* TESTING */
  READ_LOOPBACK_MODE = TESTING | 0x0001,
  WRITE_LOOPBACK_MODE = TESTING | 0x0002,
  ENABLE_DEVICE_UNDER_TEST_MODE = TESTING | 0x0003,
  WRITE_SIMPLE_PAIRING_DEBUG_MODE = TESTING | 0x0004,
  WRITE_SECURE_CONNECTIONS_TEST_MODE = TESTING | 0x000A,

  /* LE_CONTROLLER */
  LE_SET_EVENT_MASK = LE_CONTROLLER | 0x0001,
  LE_READ_BUFFER_SIZE = LE_CONTROLLER | 0x0002,
  LE_READ_LOCAL_SUPPORTED_FEATURES = LE_CONTROLLER | 0x0003,
  LE_WRITE_LOCAL_SUPPORTED_FEATURES = LE_CONTROLLER | 0x0004,
  LE_SET_RANDOM_ADDRESS = LE_CONTROLLER | 0x0005,
  LE_SET_ADVERTISING_PARAMETERS = LE_CONTROLLER | 0x0006,
  LE_READ_ADVERTISING_CHANNEL_TX_POWER = LE_CONTROLLER | 0x0007,
  LE_SET_ADVERTISING_DATA = LE_CONTROLLER | 0x0008,
  LE_SET_SCAN_RSPONSE_DATA = LE_CONTROLLER | 0x0009,
  LE_SET_ADVERTISING_ENABLE = LE_CONTROLLER | 0x000A,
  LE_SET_SCAN_PARAMETERS = LE_CONTROLLER | 0x000B,
  LE_SET_SCAN_ENABLE = LE_CONTROLLER | 0x000C,
  LE_CREATE_CONNECTION = LE_CONTROLLER | 0x000D,
  LE_CREATE_CONNECTION_CANCEL = LE_CONTROLLER | 0x000E,
  LE_READ_WHITE_LIST_SIZE = LE_CONTROLLER | 0x000F,
  LE_CLEAR_WHITE_LIST = LE_CONTROLLER | 0x0010,
  LE_ADD_DEVICE_TO_WHITE_LIST = LE_CONTROLLER | 0x0011,
  LE_REMOVE_DEVICE_FROM_WHITE_LIST = LE_CONTROLLER | 0x0012,
  LE_CONNECTION_UPDATE = LE_CONTROLLER | 0x0013,
  LE_SET_HOST_CHANNEL_CLASSIFICATION = LE_CONTROLLER | 0x0014,
  LE_READ_CHANNEL_MAP = LE_CONTROLLER | 0x0015,
  LE_READ_REMOTE_FEATURES = LE_CONTROLLER | 0x0016,
  LE_ENCRYPT = LE_CONTROLLER | 0x0017,
  LE_RAND = LE_CONTROLLER | 0x0018,
  LE_START_ENCRYPTION = LE_CONTROLLER | 0x0019,
  LE_LONG_TERM_KEY_REQUEST_REPLY = LE_CONTROLLER | 0x001A,
  LE_LONG_TERM_KEY_REQUEST_NEGATIVE_REPLY = LE_CONTROLLER | 0x001B,
  LE_READ_SUPPORTED_STATES = LE_CONTROLLER | 0x001C,
  LE_RECEIVER_TEST = LE_CONTROLLER | 0x001D,
  LE_TRANSMITTER_TEST = LE_CONTROLLER | 0x001E,
  LE_TEST_END = LE_CONTROLLER | 0x001F,
  LE_REMOTE_CONNECTION_PARAMETER_REQUEST_REPLY = LE_CONTROLLER | 0x0020,
  LE_REMOTE_CONNECTION_PARAMETER_REQUEST_NEGATIVE_REPLY = LE_CONTROLLER | 0x0021,

  LE_SET_DATA_LENGTH = LE_CONTROLLER | 0x0022,
  LE_READ_SUGGESTED_DEFAULT_DATA_LENGTH = LE_CONTROLLER | 0x0023,
  LE_WRITE_SUGGESTED_DEFAULT_DATA_LENGTH = LE_CONTROLLER | 0x0024,
  LE_READ_LOCAL_P_256_PUBLIC_KEY_COMMAND = LE_CONTROLLER | 0x0025,
  LE_GENERATE_DHKEY_COMMAND = LE_CONTROLLER | 0x0026,
  LE_ADD_DEVICE_TO_RESOLVING_LIST = LE_CONTROLLER | 0x0027,
  LE_REMOVE_DEVICE_FROM_RESOLVING_LIST = LE_CONTROLLER | 0x0028,
  LE_CLEAR_RESOLVING_LIST = LE_CONTROLLER | 0x0029,
  LE_READ_RESOLVING_LIST_SIZE = LE_CONTROLLER | 0x002A,
  LE_READ_PEER_RESOLVABLE_ADDRESS = LE_CONTROLLER | 0x002B,
  LE_READ_LOCAL_RESOLVABLE_ADDRESS = LE_CONTROLLER | 0x002C,
  LE_SET_ADDRESS_RESOLUTION_ENABLE = LE_CONTROLLER | 0x002D,
  LE_SET_RESOLVABLE_PRIVATE_ADDRESS_TIMEOUT = LE_CONTROLLER | 0x002E,
  LE_READ_MAXIMUM_DATA_LENGTH = LE_CONTROLLER | 0x002F,
  LE_READ_PHY = LE_CONTROLLER | 0x0030,
  LE_SET_DEFAULT_PHY = LE_CONTROLLER | 0x0031,
  LE_SET_PHY = LE_CONTROLLER | 0x0032,
  LE_ENHANCED_RECEIVER_TEST = LE_CONTROLLER | 0x0033,
  LE_ENHANCED_TRANSMITTER_TEST = LE_CONTROLLER | 0x0034,
  LE_SET_EXTENDED_ADVERTISING_RANDOM_ADDRESS = LE_CONTROLLER | 0x35,
  LE_SET_EXTENDED_ADVERTISING_PARAMETERS = LE_CONTROLLER | 0x36,
  LE_SET_EXTENDED_ADVERTISING_DATA = LE_CONTROLLER | 0x37,
  LE_SET_EXTENDED_ADVERTISING_SCAN_RESPONSE = LE_CONTROLLER | 0x38,
  LE_SET_EXTENDED_ADVERTISING_ENABLE = LE_CONTROLLER | 0x39,
  LE_READ_MAXIMUM_ADVERTISING_DATA_LENGTH = LE_CONTROLLER | 0x003A,
  LE_READ_NUMBER_OF_SUPPORTED_ADVERTISING_SETS = LE_CONTROLLER | 0x003B,
  LE_REMOVE_ADVERTISING_SET = LE_CONTROLLER | 0x003C,
  LE_CLEAR_ADVERTISING_SETS = LE_CONTROLLER | 0x003D,
  LE_SET_PERIODIC_ADVERTISING_PARAM = LE_CONTROLLER | 0x003E,
  LE_SET_PERIODIC_ADVERTISING_DATA = LE_CONTROLLER | 0x003F,
  LE_SET_PERIODIC_ADVERTISING_ENABLE = LE_CONTROLLER | 0x0040,
  LE_SET_EXTENDED_SCAN_PARAMETERS = LE_CONTROLLER | 0x0041,
  LE_SET_EXTENDED_SCAN_ENABLE = LE_CONTROLLER | 0x0042,
  LE_EXTENDED_CREATE_CONNECTION = LE_CONTROLLER | 0x0043,
  LE_PERIODIC_ADVERTISING_CREATE_SYNC = LE_CONTROLLER | 0x0044,
  LE_PERIODIC_ADVERTISING_CREATE_SYNC_CANCEL = LE_CONTROLLER | 0x0045,
  LE_PERIODIC_ADVERTISING_TERMINATE_SYNC = LE_CONTROLLER | 0x0046,
  LE_ADD_DEVICE_TO_PERIODIC_ADVERTISING_LIST = LE_CONTROLLER | 0x0047,
  LE_REMOVE_DEVICE_FROM_PERIODIC_ADVERTISING_LIST = LE_CONTROLLER | 0x0048,
  LE_CLEAR_PERIODIC_ADVERTISING_LIST = LE_CONTROLLER | 0x0049,
  LE_READ_PERIODIC_ADVERTISING_LIST_SIZE = LE_CONTROLLER | 0x004A,
  LE_READ_TRANSMIT_POWER = LE_CONTROLLER | 0x004B,
  LE_READ_RF_PATH_COMPENSATION_POWER = LE_CONTROLLER | 0x004C,
  LE_WRITE_RF_PATH_COMPENSATION_POWER = LE_CONTROLLER | 0x004D,
  LE_SET_PRIVACY_MODE = LE_CONTROLLER | 0x004E,

  /* VENDOR_SPECIFIC */
  LE_GET_VENDOR_CAPABILITIES = VENDOR_SPECIFIC | 0x0153,
  LE_MULTI_ADVT = VENDOR_SPECIFIC | 0x0154,
  LE_BATCH_SCAN = VENDOR_SPECIFIC | 0x0156,
  LE_ADV_FILTER = VENDOR_SPECIFIC | 0x0157,
  LE_TRACK_ADV = VENDOR_SPECIFIC | 0x0158,
  LE_ENERGY_INFO = VENDOR_SPECIFIC | 0x0159,
  LE_EXTENDED_SCAN_PARAMS = VENDOR_SPECIFIC | 0x015A,
  CONTROLLER_DEBUG_INFO = VENDOR_SPECIFIC | 0x015B,
  CONTROLLER_A2DP_OPCODE = VENDOR_SPECIFIC | 0x015D,
};

}  // namespace hci
}  // namespace test_vendor_lib
