/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Eclipse Public License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.eclipse.org/org/documents/epl-v10.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.ide.eclipse.adt.internal.editors.color;

import static com.android.ide.common.layout.LayoutConstants.ANDROID_NS_NAME;
import static com.android.sdklib.SdkConstants.NS_RESOURCES;

import com.android.ide.common.api.IAttributeInfo.Format;
import com.android.ide.common.resources.platform.AttributeInfo;
import com.android.ide.common.resources.platform.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.editors.animator.AnimatorDescriptors;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.resources.ResourceType;
import com.android.sdklib.SdkConstants;

import java.util.Map;

/** Descriptors for /res/color XML files */
public class ColorDescriptors implements IDescriptorProvider {
    private static final String SDK_URL =
        "http://d.android.com/guide/topics/resources/color-list-resource.html"; //$NON-NLS-1$

    /** The root element descriptor */
    private ElementDescriptor mDescriptor = new ElementDescriptor(
            "selector", "Selector",
            "Required. This must be the root element. Contains one or more <item> elements.",
            SDK_URL,
            new AttributeDescriptor[] { new XmlnsAttributeDescriptor(ANDROID_NS_NAME,
                    NS_RESOURCES) },
            null /*children: added later*/, true /*mandatory*/);

    /** @return the root descriptor. */
    public ElementDescriptor getDescriptor() {
        if (mDescriptor == null) {
            mDescriptor = new ElementDescriptor("", getRootElementDescriptors()); //$NON-NLS-1$
        }

        return mDescriptor;
    }

    public ElementDescriptor[] getRootElementDescriptors() {
        return new ElementDescriptor[] { mDescriptor };
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> styleMap) {
        if (styleMap == null) {
            return;
        }

        // Selector children
        ElementDescriptor selectorItem = AnimatorDescriptors.addElement(null, styleMap,
            "item", "Item", "DrawableStates", null, //$NON-NLS-1$ //$NON-NLS-3$
            "Defines a drawable to use during certain states, as described by "
                 + "its attributes. Must be a child of a <selector> element.",
            SDK_URL,
            new ReferenceAttributeDescriptor(
                    ResourceType.COLOR, "color", "color", //$NON-NLS-1$ //$NON-NLS-2$
                    SdkConstants.NS_RESOURCES,
                    "Hexadeximal color. Required. The color is specified with an RGB value and "
                        + "optional alpha channel.\n"
                        + "The value always begins with a pound (#) character and then "
                        + "followed by the Alpha-Red-Green-Blue information in one of "
                        + "the following formats:\n"
                        + "* RGB\n"
                        + "* ARGB\n"
                        + "* RRGGBB\n"
                        + "* AARRGGBB",
                    new AttributeInfo("drawable", new Format[] { Format.COLOR })),
            null, /* This is wrong -- we can now embed any above drawable
                        (but without xmlns as extra) */
            false /*mandatory*/);

        if (selectorItem != null) {
            mDescriptor.setChildren(new ElementDescriptor[] { selectorItem });
        }
    }
}
