/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    long handle;
    int index;
    byte[] settingsData;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyleBit(shell, n));
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyleBit(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        if ((n & n2) == 0) {
            n |= 0x10000;
        }
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    public PrinterData open() {
        long l;
        Object[] objectArray;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] byArray = Converter.wcsToMbcs(null, this.getText(), true);
        long l2 = this.getParent().handle;
        while (l2 != 0L && !OS.GTK_IS_WINDOW(l2)) {
            l2 = OS.gtk_widget_get_parent(l2);
        }
        this.handle = OS.gtk_print_unix_dialog_new(byArray, l2);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7L);
        long l3 = OS.gtk_print_settings_new();
        long l4 = OS.gtk_page_setup_new();
        if (this.printerData.otherData != null) {
            Printer.restore(this.printerData.otherData, l3, l4);
        }
        switch (this.printerData.scope) {
            case 0: {
                OS.gtk_print_settings_set_print_pages(l3, 0);
                break;
            }
            case 1: {
                OS.gtk_print_settings_set_print_pages(l3, 2);
                objectArray = new int[]{this.printerData.startPage - 1, this.printerData.endPage - 1};
                OS.gtk_print_settings_set_page_ranges(l3, objectArray, 1);
                break;
            }
            case 2: {
                OS.gtk_print_settings_set_print_pages(l3, 0);
            }
        }
        if (this.printerData.fileName != null) {
            if (this.printerData.printToFile) {
                objectArray = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, (byte[])objectArray);
            }
            if (this.printerData.driver != null && this.printerData.name != null && this.printerData.driver.equals("GtkPrintBackendFile") && this.printerData.name.equals("Print to File")) {
                objectArray = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, (byte[])objectArray);
            }
        }
        if (this.printerData.printToFile) {
            objectArray = Converter.wcsToMbcs(null, "Print to File", true);
            OS.gtk_print_settings_set_printer(l3, (byte[])objectArray);
        }
        OS.gtk_print_settings_set_n_copies(l3, this.printerData.copyCount);
        OS.gtk_print_settings_set_collate(l3, this.printerData.collate);
        int n = this.printerData.orientation == 2 ? 1 : 0;
        OS.gtk_print_settings_set_orientation(l3, n);
        OS.gtk_page_setup_set_orientation(l4, n);
        OS.gtk_print_unix_dialog_set_settings(this.handle, l3);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, l4);
        OS.g_object_unref(l3);
        OS.g_object_unref(l4);
        OS.gtk_window_set_modal(this.handle, true);
        PrinterData printerData = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        int n2 = 0;
        long l5 = 0L;
        if ((this.getStyle() & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l5 = OS.g_signal_add_emission_hook(n2, 0, ((LONG)display.getData((String)GET_EMISSION_PROC_KEY)).value, this.handle, 0L);
        }
        display.setData(ADD_IDLE_PROC_KEY, null);
        Object object = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            object = display.getData(GET_MODAL_DIALOG);
            display.setData(SET_MODAL_DIALOG, this);
        }
        int n3 = OS.gtk_dialog_run(this.handle);
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setData(SET_MODAL_DIALOG, object);
        }
        if ((this.getStyle() & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l5);
        }
        if (n3 == -5 && (l = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0L) {
            Object[] objectArray2;
            long l6;
            Object object2;
            l3 = OS.gtk_print_unix_dialog_get_settings(this.handle);
            l4 = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            printerData = Printer.printerDataFromGtkPrinter(l);
            int n4 = OS.gtk_print_settings_get_print_pages(l3);
            switch (n4) {
                case 0: {
                    printerData.scope = 0;
                    break;
                }
                case 2: {
                    printerData.scope = 1;
                    object2 = new int[1];
                    l6 = OS.gtk_print_settings_get_page_ranges(l3, (int[])object2);
                    objectArray2 = new int[2];
                    int n5 = object2[0];
                    int n6 = Integer.MAX_VALUE;
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < n5) {
                        OS.memmove(objectArray2, l6 + (long)(n8 * objectArray2.length * 4), (long)(objectArray2.length * 4));
                        n6 = Math.min(n6, objectArray2[0] + 1);
                        n7 = Math.max(n7, objectArray2[1] + 1);
                        ++n8;
                    }
                    OS.g_free(l6);
                    printerData.startPage = n6 == Integer.MAX_VALUE ? 1 : n6;
                    printerData.endPage = n7 == 0 ? 1 : n7;
                    break;
                }
                case 1: {
                    printerData.scope = 2;
                    printerData.startPage = printerData.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            printerData.printToFile = printerData.name.equals("Print to File");
            if (printerData.printToFile) {
                long l7 = OS.gtk_print_settings_get(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                int n9 = OS.strlen(l7);
                objectArray2 = new byte[n9];
                OS.memmove((byte[])objectArray2, l7, (long)n9);
                printerData.fileName = new String(Converter.mbcsToWcs(null, (byte[])objectArray2));
            }
            printerData.copyCount = OS.gtk_print_settings_get_n_copies(l3);
            printerData.collate = OS.gtk_print_settings_get_collate(l3);
            printerData.orientation = OS.gtk_page_setup_get_orientation(l4) == 1 ? 2 : 1;
            object2 = new Callback(this, "GtkPrintSettingsFunc", 3);
            l6 = ((Callback)object2).getAddress();
            if (l6 == 0L) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(l3, l6, 0L);
            ((Callback)object2).dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(l4));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(l4, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(l4, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(l4, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(l4, 3));
            long l8 = OS.gtk_page_setup_get_paper_size(l4);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(l8));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(l8));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(l8));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(l8, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(l8, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(l8));
            printerData.otherData = this.settingsData;
            OS.g_object_unref(l3);
            this.printerData = printerData;
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return printerData;
    }

    long GtkPrintSettingsFunc(long l, long l2, long l3) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        n = OS.strlen(l2);
        byte[] byArray2 = new byte[n];
        OS.memmove(byArray2, l2, (long)n);
        this.store(byArray, byArray2);
        return 0L;
    }

    void store(String string, int n) {
        this.store(string, String.valueOf(n));
    }

    void store(String string, double d) {
        this.store(string, String.valueOf(d));
    }

    void store(String string, boolean bl) {
        this.store(string, String.valueOf(bl));
    }

    void storeBytes(String string, long l) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        this.store(string.getBytes(), byArray);
    }

    void store(String string, String string2) {
        this.store(string.getBytes(), string2.getBytes());
    }

    void store(byte[] byArray, byte[] byArray2) {
        int n = byArray.length + 1 + byArray2.length + 1;
        if (this.index + n + 1 > this.settingsData.length) {
            byte[] byArray3 = new byte[this.settingsData.length + Math.max(n + 1, 1024)];
            System.arraycopy(this.settingsData, 0, byArray3, 0, this.settingsData.length);
            this.settingsData = byArray3;
        }
        System.arraycopy(byArray, 0, this.settingsData, this.index, byArray.length);
        this.index += byArray.length + 1;
        System.arraycopy(byArray2, 0, this.settingsData, this.index, byArray2.length);
        this.index += byArray2.length + 1;
    }
}

