/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        long l = theme.notebookHandle;
        long l2 = OS.gtk_widget_get_style(l);
        long l3 = gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        n4 -= this.tabsHeight;
        int n5 = this.selectedX;
        int n6 = this.selectedWidth;
        int n7 = 2;
        if ((this.style & 0x400) != 0) {
            n7 = 3;
        } else {
            n2 += this.tabsHeight;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "notebook", true);
        OS.gtk_paint_box_gap(l2, l3, this.getStateType(0), 2, null, l, byArray, n, n2, n3, n4, n7, n5, n6);
        if (this.tabsArea != null) {
            this.tabsArea.x = rectangle.x;
            this.tabsArea.y = rectangle.y;
            this.tabsArea.width = rectangle.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += rectangle.height - this.tabsHeight;
            }
        }
    }

    int getStateType(int n) {
        return 0;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

