/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;

public class FileTransfer
extends ByteArrayTransfer {
    static FileTransfer _instance = new FileTransfer();
    static final String ID_NAME = OS.NSFilenamesPboardType.getString();
    static final int ID = FileTransfer.registerType(ID_NAME);

    FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        int n = stringArray.length;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            NSString nSString = NSString.stringWith(string);
            nSMutableArray.addObject(nSString);
            ++n2;
        }
        transferData.data = nSMutableArray;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSArray nSArray = (NSArray)transferData.data;
        if (nSArray.count() == 0L) {
            return null;
        }
        int n = (int)nSArray.count();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            NSString nSString = new NSString(nSArray.objectAtIndex(n2));
            stringArray[n2] = nSString.getString();
            ++n2;
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{ID};
    }

    protected String[] getTypeNames() {
        return new String[]{ID_NAME};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

