/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class ContainsSelector
extends BaseExtendSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    public String toString() {
        StringBuffer buf = new StringBuffer("{containsselector text: ");
        buf.append(this.contains);
        buf.append(" casesensitive: ");
        if (this.casesensitive) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append(" ignorewhitespace: ");
        if (this.ignorewhitespace) {
            buf.append("true");
        } else {
            buf.append("false");
        }
        buf.append("}");
        return buf.toString();
    }

    public void setText(String contains) {
        this.contains = contains;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setIgnorewhitespace(boolean ignorewhitespace) {
        this.ignorewhitespace = ignorewhitespace;
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                String paramname = parameters[i].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(paramname)) {
                    this.setText(parameters[i].getValue());
                    continue;
                }
                if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Project.toBoolean(parameters[i].getValue()));
                    continue;
                }
                if (WHITESPACE_KEY.equalsIgnoreCase(paramname)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameters[i].getValue()));
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        if (file.isDirectory()) {
            return true;
        }
        String userstr = this.contains;
        if (!this.casesensitive) {
            userstr = this.contains.toLowerCase();
        }
        if (this.ignorewhitespace) {
            userstr = SelectorUtils.removeWhitespace(userstr);
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String teststr = in.readLine();
            while (teststr != null) {
                if (!this.casesensitive) {
                    teststr = teststr.toLowerCase();
                }
                if (this.ignorewhitespace) {
                    teststr = SelectorUtils.removeWhitespace(teststr);
                }
                if (teststr.indexOf(userstr) > -1) {
                    boolean bl = true;
                    return bl;
                }
                teststr = in.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw new BuildException("Could not read file " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    throw new BuildException("Could not close file " + filename);
                }
            }
        }
    }
}

