/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ManifestTask
extends Task {
    private Manifest nestedManifest = new Manifest();
    private File manifestFile;
    private Mode mode = new Mode();
    private String encoding;

    public ManifestTask() {
        this.mode.setValue("replace");
    }

    public void addConfiguredSection(Manifest.Section section) throws ManifestException {
        this.nestedManifest.addConfiguredSection(section);
    }

    public void addConfiguredAttribute(Manifest.Attribute attribute) throws ManifestException {
        this.nestedManifest.addConfiguredAttribute(attribute);
    }

    public void setFile(File f) {
        this.manifestFile = f;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.manifestFile == null) {
            throw new BuildException("the file attribute is required");
        }
        Manifest toWrite = Manifest.getDefaultManifest();
        Manifest current = null;
        BuildException error = null;
        if (this.manifestFile.exists()) {
            FileInputStream fis = null;
            InputStreamReader isr = null;
            try {
                fis = new FileInputStream(this.manifestFile);
                isr = this.encoding == null ? new InputStreamReader((InputStream)fis, "UTF-8") : new InputStreamReader((InputStream)fis, this.encoding);
                current = new Manifest(isr);
            }
            catch (ManifestException m) {
                error = new BuildException("Existing manifest " + this.manifestFile + " is invalid", m, this.getLocation());
            }
            catch (IOException e) {
                error = new BuildException("Failed to read " + this.manifestFile, e, this.getLocation());
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            if (this.mode.getValue().equals("update") && this.manifestFile.exists()) {
                if (current != null) {
                    toWrite.merge(current);
                } else if (error != null) {
                    throw error;
                }
            }
            toWrite.merge(this.nestedManifest);
        }
        catch (ManifestException m) {
            throw new BuildException("Manifest is invalid", m, this.getLocation());
        }
        if (toWrite.equals(current)) {
            this.log("Manifest has not changed, do not recreate", 3);
            return;
        }
        PrintWriter w = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.manifestFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            w = new PrintWriter(osw);
            toWrite.write(w);
        }
        catch (IOException e) {
            throw new BuildException("Failed to write " + this.manifestFile, e, this.getLocation());
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public static class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"update", "replace"};
        }
    }
}

