/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public class Delete
extends MatchingTask {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    protected File file = null;
    protected File dir = null;
    protected Vector filesets = new Vector();
    protected boolean usedMatchingTask = false;
    protected boolean includeEmpty = false;
    private int verbosity = 3;
    private boolean quiet = false;
    private boolean failonerror = true;
    private boolean deleteOnExit = false;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
        if (quiet) {
            this.failonerror = false;
        }
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        this.usedMatchingTask = true;
        return super.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        this.usedMatchingTask = true;
        return super.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.usedMatchingTask = true;
        super.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.usedMatchingTask = true;
        super.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(useDefaultExcludes);
    }

    public void setIncludesfile(File includesfile) {
        this.usedMatchingTask = true;
        super.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.usedMatchingTask = true;
        super.setExcludesfile(excludesfile);
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.usedMatchingTask = true;
        super.setCaseSensitive(isCaseSensitive);
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.usedMatchingTask = true;
        super.setFollowSymlinks(followSymlinks);
    }

    public void addSelector(SelectSelector selector) {
        this.usedMatchingTask = true;
        super.addSelector(selector);
    }

    public void addAnd(AndSelector selector) {
        this.usedMatchingTask = true;
        super.addAnd(selector);
    }

    public void addOr(OrSelector selector) {
        this.usedMatchingTask = true;
        super.addOr(selector);
    }

    public void addNot(NotSelector selector) {
        this.usedMatchingTask = true;
        super.addNot(selector);
    }

    public void addNone(NoneSelector selector) {
        this.usedMatchingTask = true;
        super.addNone(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.usedMatchingTask = true;
        super.addMajority(selector);
    }

    public void addDate(DateSelector selector) {
        this.usedMatchingTask = true;
        super.addDate(selector);
    }

    public void addSize(SizeSelector selector) {
        this.usedMatchingTask = true;
        super.addSize(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.usedMatchingTask = true;
        super.addFilename(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.usedMatchingTask = true;
        super.addCustom(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.usedMatchingTask = true;
        super.addContains(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.usedMatchingTask = true;
        super.addPresent(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.usedMatchingTask = true;
        super.addDepth(selector);
    }

    public void addDepend(DependSelector selector) {
        this.usedMatchingTask = true;
        super.addDepend(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.usedMatchingTask = true;
        super.addContainsRegexp(selector);
    }

    public void addModified(ModifiedSelector selector) {
        this.usedMatchingTask = true;
        super.addModified(selector);
    }

    public void add(FileSelector selector) {
        this.usedMatchingTask = true;
        super.add(selector);
    }

    public void execute() throws BuildException {
        if (this.usedMatchingTask) {
            this.log("DEPRECATED - Use of the implicit FileSet is deprecated.  Use a nested fileset element instead.");
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.quiet && this.failonerror) {
            throw new BuildException("quiet and failonerror cannot both be set to true", this.getLocation());
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " cannot be removed using the file attribute.  " + "Use dir instead.");
                } else {
                    this.log("Deleting: " + this.file.getAbsolutePath());
                    if (!this.delete(this.file)) {
                        String message = "Unable to delete file " + this.file.getAbsolutePath();
                        if (this.failonerror) {
                            throw new BuildException(message);
                        }
                        this.log(message, this.quiet ? 3 : 1);
                    }
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to delete.", 3);
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            if (this.verbosity == 3) {
                this.log("Deleting directory " + this.dir.getAbsolutePath());
            }
            this.removeDir(this.dir);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            try {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                this.removeFiles(fs.getDir(this.getProject()), files, dirs);
                continue;
            }
            catch (BuildException be) {
                if (this.failonerror) {
                    throw be;
                }
                this.log(be.getMessage(), this.quiet ? 3 : 1);
            }
        }
        if (this.usedMatchingTask && this.dir != null) {
            try {
                DirectoryScanner ds = super.getDirectoryScanner(this.dir);
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                this.removeFiles(this.dir, files, dirs);
            }
            catch (BuildException be) {
                if (this.failonerror) {
                    throw be;
                }
                this.log(be.getMessage(), this.quiet ? 3 : 1);
            }
        }
    }

    private boolean delete(File f) {
        if (!f.delete()) {
            if (Os.isFamily("windows")) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!f.delete()) {
                if (this.deleteOnExit) {
                    int level = this.quiet ? 3 : 2;
                    this.log("Failed to delete " + f + ", calling deleteOnExit." + " This attempts to delete the file when the ant jvm" + " has exited and might not succeed.", level);
                    f.deleteOnExit();
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                this.removeDir(f);
                continue;
            }
            this.log("Deleting " + f.getAbsolutePath(), this.verbosity);
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            if (this.failonerror) {
                throw new BuildException(message);
            }
            this.log(message, this.quiet ? 3 : 1);
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!this.delete(d)) {
            String message = "Unable to delete directory " + this.dir.getAbsolutePath();
            if (this.failonerror) {
                throw new BuildException(message);
            }
            this.log(message, this.quiet ? 3 : 1);
        }
    }

    protected void removeFiles(File d, String[] files, String[] dirs) {
        if (files.length > 0) {
            this.log("Deleting " + files.length + " files from " + d.getAbsolutePath());
            for (int j = 0; j < files.length; ++j) {
                File f = new File(d, files[j]);
                this.log("Deleting " + f.getAbsolutePath(), this.verbosity);
                if (this.delete(f)) continue;
                String message = "Unable to delete file " + f.getAbsolutePath();
                if (this.failonerror) {
                    throw new BuildException(message);
                }
                this.log(message, this.quiet ? 3 : 1);
            }
        }
        if (dirs.length > 0 && this.includeEmpty) {
            int dirCount = 0;
            for (int j = dirs.length - 1; j >= 0; --j) {
                File currDir = new File(d, dirs[j]);
                String[] dirFiles = currDir.list();
                if (dirFiles != null && dirFiles.length != 0) continue;
                this.log("Deleting " + currDir.getAbsolutePath(), this.verbosity);
                if (!this.delete(currDir)) {
                    String message = "Unable to delete directory " + currDir.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException(message);
                    }
                    this.log(message, this.quiet ? 3 : 1);
                    continue;
                }
                ++dirCount;
            }
            if (dirCount > 0) {
                this.log("Deleted " + dirCount + " director" + (dirCount == 1 ? "y" : "ies") + " from " + d.getAbsolutePath());
            }
        }
    }
}

