/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemePopupArrowDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeSeparatorDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 9;
    static final int INSET = 3;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        int n = this.clientArea.x - 3;
        int n2 = this.clientArea.y - 3;
        int n3 = this.clientArea.width + 6;
        int n4 = this.clientArea.height + 6;
        if ((this.style & 4) != 0) {
            n3 += 9;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        Object object;
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        if ((this.style & 2) != 0) {
            object = this.getSeparatorInfo();
            OS.HIThemeDrawSeparator(cGRect, (HIThemeSeparatorDrawInfo)object, gC.handle, 0);
        } else if ((this.state[0] & 2) != 0) {
            OS.CGContextSaveGState(gC.handle);
            OS.CGContextSetFillColor(gC.handle, new float[]{0.025f, 0.025f, 0.025f, 0.025f});
            OS.CGContextFillRect(gC.handle, cGRect);
            OS.CGContextSetStrokeColor(gC.handle, new float[]{0.2f, 0.2f, 0.2f, 0.2f});
            cGRect.x += 0.5f;
            cGRect.y += 0.5f;
            cGRect.width -= 1.0f;
            cGRect.height -= 1.0f;
            OS.CGContextStrokeRect(gC.handle, cGRect);
            OS.CGContextRestoreGState(gC.handle);
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x;
            this.clientArea.y = rectangle.y;
            this.clientArea.width = rectangle.width;
            this.clientArea.height = rectangle.height;
        }
        if ((this.style & 4) != 0) {
            cGRect.y = (float)rectangle.y + cGRect.height / 2.0f - 1.0f;
            cGRect.x = (float)rectangle.x + cGRect.width - 9.0f;
            object = this.getArrowInfo();
            OS.HIThemeDrawPopupArrow(cGRect, (HIThemePopupArrowDrawInfo)object, gC.handle, 0);
            if (this.clientArea != null) {
                this.clientArea.width -= 9;
            }
        }
    }

    HIThemePopupArrowDrawInfo getArrowInfo() {
        HIThemePopupArrowDrawInfo hIThemePopupArrowDrawInfo = new HIThemePopupArrowDrawInfo();
        int n = this.state[1];
        hIThemePopupArrowDrawInfo.state = (n & 8) != 0 ? 2 : ((n & 0x10) != 0 ? ((n & 0x20) == 0 ? 1 : 7) : ((n & 0x20) == 0 ? 0 : 8));
        hIThemePopupArrowDrawInfo.orientation = 1;
        hIThemePopupArrowDrawInfo.size = 1;
        return hIThemePopupArrowDrawInfo;
    }

    HIThemeSeparatorDrawInfo getSeparatorInfo() {
        HIThemeSeparatorDrawInfo hIThemeSeparatorDrawInfo = new HIThemeSeparatorDrawInfo();
        int n = this.state[0];
        hIThemeSeparatorDrawInfo.state = (n & 0x10) != 0 ? ((n & 0x20) == 0 ? 1 : 7) : ((n & 0x20) == 0 ? 0 : 8);
        return hIThemeSeparatorDrawInfo;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        if ((this.style & 4) != 0 && rectangle.x + rectangle.width - 9 <= point.x) {
            return 1;
        }
        return 0;
    }
}

