/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int increment;
    int pageIncrement;

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
    }

    void destroyWidget() {
        int n = this.hwndScrollBar();
        int n2 = this.scrollBarType();
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 3;
            sCROLLINFO.nPage = 101;
            sCROLLINFO.nMax = 100;
            sCROLLINFO.nMin = 0;
            OS.SetScrollInfo(n, n2, sCROLLINFO, true);
        } else {
            OS.ShowScrollBar(n, n2, false);
        }
        this.parent.destroyScrollBar(this.style);
        this.releaseHandle();
    }

    Rectangle getBounds() {
        int n;
        int n2;
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n4 = rECT.bottom - rECT.top;
            n2 = rECT.right - rECT.left;
            n = OS.GetSystemMetrics(3);
        } else {
            n3 = rECT.right - rECT.left;
            n2 = OS.GetSystemMetrics(2);
            n = rECT.bottom - rECT.top;
        }
        return new Rectangle(n3, n4, n2, n);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n = this.hwndScrollBar();
        int n2 = this.scrollBarType();
        OS.GetScrollInfo(n, n2, sCROLLINFO);
        return sCROLLINFO.nMax;
    }

    public int getMinimum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n = this.hwndScrollBar();
        int n2 = this.scrollBarType();
        OS.GetScrollInfo(n, n2, sCROLLINFO);
        return sCROLLINFO.nMin;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        int n = this.hwndScrollBar();
        int n2 = this.scrollBarType();
        OS.GetScrollInfo(n, n2, sCROLLINFO);
        return sCROLLINFO.nPos;
    }

    public Point getSize() {
        int n;
        int n2;
        this.checkWidget();
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        if ((this.style & 0x100) != 0) {
            n2 = rECT.right - rECT.left;
            n = OS.GetSystemMetrics(3);
        } else {
            n2 = OS.GetSystemMetrics(2);
            n = rECT.bottom - rECT.top;
        }
        return new Point(n2, n);
    }

    public int getThumb() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 2;
        int n = this.hwndScrollBar();
        int n2 = this.scrollBarType();
        OS.GetScrollInfo(n, n2, sCROLLINFO);
        if (sCROLLINFO.nPage != 0) {
            --sCROLLINFO.nPage;
        }
        return sCROLLINFO.nPage;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
            sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
            int n = (this.style & 0x200) != 0 ? -5 : -6;
            OS.GetScrollBarInfo(this.hwndScrollBar(), n, sCROLLBARINFO);
            return (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
        }
        return (this.state & 0x10) == 0;
    }

    int hwndScrollBar() {
        return this.parent.scrolledHandle();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int scrollBarType() {
        return (this.style & 0x200) != 0 ? 1 : 0;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (!OS.IsWinCE) {
            int n = this.hwndScrollBar();
            int n2 = this.scrollBarType();
            int n3 = bl ? 0 : 3;
            OS.EnableScrollBar(n, n2, n3);
            this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        if (n - sCROLLINFO.nMin - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMax = n;
        this.SetScrollInfo(n2, n3, sCROLLINFO, true);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        if (sCROLLINFO.nMax - n - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMin = n;
        this.SetScrollInfo(n2, n3, sCROLLINFO, true);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    boolean SetScrollInfo(int n, int n2, SCROLLINFO sCROLLINFO, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = this.getVisible();
        ScrollBar scrollBar = null;
        if (!OS.IsWinCE) {
            switch (n2) {
                case 0: {
                    scrollBar = this.parent.getVerticalBar();
                    break;
                }
                case 1: {
                    scrollBar = this.parent.getHorizontalBar();
                }
            }
            boolean bl4 = bl2 = scrollBar != null && scrollBar.getVisible();
        }
        if (!bl3 || (this.state & 8) != 0) {
            bl = false;
        }
        boolean bl5 = OS.SetScrollInfo(n, n2, sCROLLINFO, bl);
        if (!bl3 && !OS.IsWinCE) {
            OS.ShowScrollBar(n, !bl2 ? 3 : n2, false);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && bl3 && scrollBar != null && !bl2) {
            OS.ShowScrollBar(n, n2 == 0 ? 1 : 0, false);
        }
        if ((this.state & 8) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(n, n2, 3);
        }
        return bl5;
    }

    public void setSelection(int n) {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        sCROLLINFO.fMask = 4;
        sCROLLINFO.nPos = n;
        this.SetScrollInfo(n2, n3, sCROLLINFO, true);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        sCROLLINFO.fMask = 11;
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        sCROLLINFO.nPage = n;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        this.SetScrollInfo(n2, n3, sCROLLINFO, true);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        this.increment = n5;
        this.pageIncrement = n6;
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 15;
        sCROLLINFO.nPos = n;
        sCROLLINFO.nMin = n2;
        sCROLLINFO.nMax = n3;
        sCROLLINFO.nPage = n4;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        int n7 = this.hwndScrollBar();
        int n8 = this.scrollBarType();
        this.SetScrollInfo(n7, n8, sCROLLINFO, true);
    }

    public void setVisible(boolean bl) {
        int n;
        this.checkWidget();
        if (bl == this.getVisible()) {
            return;
        }
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            int n2 = this.hwndScrollBar();
            int n3 = this.scrollBarType();
            sCROLLINFO.fMask = 3;
            if (bl) {
                sCROLLINFO.fMask |= 8;
            }
            OS.GetScrollInfo(n2, n3, sCROLLINFO);
            if (sCROLLINFO.nPage == sCROLLINFO.nMax - sCROLLINFO.nMin + 1) {
                int n4 = sCROLLINFO.nMax++;
                OS.SetScrollInfo(n2, n3, sCROLLINFO, false);
                sCROLLINFO.nMax = n4;
                OS.SetScrollInfo(n2, n3, sCROLLINFO, true);
            }
            return;
        }
        this.state = bl ? this.state & 0xFFFFFFEF : this.state | 0x10;
        int n5 = this.hwndScrollBar();
        if (OS.ShowScrollBar(n5, n = this.scrollBarType(), bl)) {
            if ((this.state & 8) == 0) {
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 3;
                OS.GetScrollInfo(n5, n, sCROLLINFO);
                if (sCROLLINFO.nMax - sCROLLINFO.nMin - sCROLLINFO.nPage >= 0) {
                    OS.EnableScrollBar(n5, n, 0);
                }
            }
            this.sendEvent(bl ? 22 : 23);
        }
    }

    LRESULT wmScrollChild(int n, int n2) {
        int n3 = OS.LOWORD(n);
        if (n3 == 8) {
            return null;
        }
        Event event = new Event();
        switch (n3) {
            case 4: {
                event.detail = 0;
                break;
            }
            case 5: {
                event.detail = 1;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                break;
            }
            case 7: {
                event.detail = 0x1000008;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                break;
            }
            case 0: {
                event.detail = 0x1000001;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
            }
        }
        this.sendEvent(13, event);
        return null;
    }
}

