/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Pointer;
import java.io.FileDescriptor;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.LibC;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.SolarisHeapFileStat;
import org.python.posix.SolarisPasswd;

public class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new SolarisPasswd((Pointer)arg) : null;
        }
    };

    public SolarisPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public FileStat allocateStat() {
        return new SolarisHeapFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc.fstat64(fd, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat;
    }

    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.lstat64(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.stat64(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }
}

