/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.cst;

import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstInterfaceMethodRef;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.CstUtf8;
import com.android.dx.rop.cst.StdConstantPool;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public final class ConstantPoolParser {
    private final ByteArray bytes;
    private final StdConstantPool pool;
    private final int[] offsets;
    private int endOffset;
    private ParseObserver observer;

    public ConstantPoolParser(ByteArray bytes) {
        int size = bytes.getUnsignedShort(8);
        this.bytes = bytes;
        this.pool = new StdConstantPool(size);
        this.offsets = new int[size];
        this.endOffset = -1;
    }

    public void setObserver(ParseObserver observer) {
        this.observer = observer;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public StdConstantPool getPool() {
        this.parseIfNecessary();
        return this.pool;
    }

    private void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    private void parse() {
        int i;
        this.determineOffsets();
        if (this.observer != null) {
            this.observer.parsed(this.bytes, 8, 2, "constant_pool_count: " + Hex.u2(this.offsets.length));
            this.observer.parsed(this.bytes, 10, 0, "\nconstant_pool:");
            this.observer.changeIndent(1);
        }
        for (i = 1; i < this.offsets.length; ++i) {
            int offset = this.offsets[i];
            if (offset == 0 || this.pool.getOrNull(i) != null) continue;
            this.parse0(i);
        }
        if (this.observer != null) {
            for (i = 1; i < this.offsets.length; ++i) {
                Constant cst = this.pool.getOrNull(i);
                if (cst == null) continue;
                int offset = this.offsets[i];
                int nextOffset = this.endOffset;
                for (int j = i + 1; j < this.offsets.length; ++j) {
                    int off = this.offsets[j];
                    if (off == 0) continue;
                    nextOffset = off;
                    break;
                }
                this.observer.parsed(this.bytes, offset, nextOffset - offset, Hex.u2(i) + ": " + cst.toString());
            }
            this.observer.changeIndent(-1);
            this.observer.parsed(this.bytes, this.endOffset, 0, "end constant_pool");
        }
    }

    private void determineOffsets() {
        int lastCategory;
        int at = 10;
        block6: for (int i = 1; i < this.offsets.length; i += lastCategory) {
            this.offsets[i] = at;
            int tag = this.bytes.getUnsignedByte(at);
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    lastCategory = 1;
                    at += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    lastCategory = 2;
                    at += 9;
                    continue block6;
                }
                case 7: 
                case 8: {
                    lastCategory = 1;
                    at += 3;
                    continue block6;
                }
                case 1: {
                    lastCategory = 1;
                    at += this.bytes.getUnsignedShort(at + 1) + 3;
                    continue block6;
                }
                default: {
                    ParseException ex = new ParseException("unknown tag byte: " + Hex.u1(tag));
                    ex.addContext("...while preparsing cst " + Hex.u2(i) + " at offset " + Hex.u4(at));
                    throw ex;
                }
            }
        }
        this.endOffset = at;
    }

    private Constant parse0(int idx) {
        Constant cst = this.pool.getOrNull(idx);
        if (cst != null) {
            return cst;
        }
        int at = this.offsets[idx];
        try {
            int tag = this.bytes.getUnsignedByte(at);
            switch (tag) {
                case 1: {
                    cst = this.parseUtf8(at);
                    break;
                }
                case 3: {
                    int value = this.bytes.getInt(at + 1);
                    cst = CstInteger.make(value);
                    break;
                }
                case 4: {
                    int bits = this.bytes.getInt(at + 1);
                    cst = CstFloat.make(bits);
                    break;
                }
                case 5: {
                    long value = this.bytes.getLong(at + 1);
                    cst = CstLong.make(value);
                    break;
                }
                case 6: {
                    long bits = this.bytes.getLong(at + 1);
                    cst = CstDouble.make(bits);
                    break;
                }
                case 7: {
                    int nameIndex = this.bytes.getUnsignedShort(at + 1);
                    CstUtf8 name = (CstUtf8)this.parse0(nameIndex);
                    cst = new CstType(Type.internClassName(name.getString()));
                    break;
                }
                case 8: {
                    int stringIndex = this.bytes.getUnsignedShort(at + 1);
                    CstUtf8 string = (CstUtf8)this.parse0(stringIndex);
                    cst = new CstString(string);
                    break;
                }
                case 9: {
                    int classIndex = this.bytes.getUnsignedShort(at + 1);
                    CstType type = (CstType)this.parse0(classIndex);
                    int natIndex = this.bytes.getUnsignedShort(at + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex);
                    cst = new CstFieldRef(type, nat);
                    break;
                }
                case 10: {
                    int classIndex = this.bytes.getUnsignedShort(at + 1);
                    CstType type = (CstType)this.parse0(classIndex);
                    int natIndex = this.bytes.getUnsignedShort(at + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex);
                    cst = new CstMethodRef(type, nat);
                    break;
                }
                case 11: {
                    int classIndex = this.bytes.getUnsignedShort(at + 1);
                    CstType type = (CstType)this.parse0(classIndex);
                    int natIndex = this.bytes.getUnsignedShort(at + 3);
                    CstNat nat = (CstNat)this.parse0(natIndex);
                    cst = new CstInterfaceMethodRef(type, nat);
                    break;
                }
                case 12: {
                    int nameIndex = this.bytes.getUnsignedShort(at + 1);
                    CstUtf8 name = (CstUtf8)this.parse0(nameIndex);
                    int descriptorIndex = this.bytes.getUnsignedShort(at + 3);
                    CstUtf8 descriptor = (CstUtf8)this.parse0(descriptorIndex);
                    cst = new CstNat(name, descriptor);
                    break;
                }
            }
        }
        catch (ParseException ex) {
            ex.addContext("...while parsing cst " + Hex.u2(idx) + " at offset " + Hex.u4(at));
            throw ex;
        }
        catch (RuntimeException ex) {
            ParseException pe = new ParseException(ex);
            pe.addContext("...while parsing cst " + Hex.u2(idx) + " at offset " + Hex.u4(at));
            throw pe;
        }
        this.pool.set(idx, cst);
        return cst;
    }

    private CstUtf8 parseUtf8(int at) {
        int length = this.bytes.getUnsignedShort(at + 1);
        ByteArray ubytes = this.bytes.slice(at += 3, at + length);
        try {
            return new CstUtf8(ubytes);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex);
        }
    }
}

