/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name;
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static long cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GNOME_24 = 2;
    static final int DESKTOP_CDE = 3;
    static final int PREFERRED_ICON_SIZE = 16;

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }

    Program() {
    }

    static int getDesktop(final Display display) {
        byte[] byArray;
        long l;
        if (display == null) {
            return 0;
        }
        Integer n = (Integer)display.getData(DESKTOP_DATA);
        if (n != null) {
            return n;
        }
        int n2 = 0;
        long l2 = OS.GDK_DISPLAY();
        long l3 = OS.XDefaultRootWindow(l2);
        int[] nArray = new int[1];
        long l4 = OS.XListProperties(l2, l3, nArray);
        long[] lArray = new long[nArray[0]];
        if (l4 != 0L) {
            OS.memmove(lArray, l4, (long)(lArray.length * OS.PTR_SIZEOF));
            OS.XFree(l4);
        }
        if (n2 == 0 && (l = OS.XInternAtom(l2, byArray = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0L && Program.gnome_init()) {
            n2 = 1;
            long l5 = GNOME.gnome_icon_theme_new();
            display.setData(ICON_THEME_DATA, new LONG(l5));
            display.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    LONG lONG = (LONG)display.getData(Program.ICON_THEME_DATA);
                    if (lONG == null) {
                        return;
                    }
                    display.setData(Program.ICON_THEME_DATA, null);
                    if (lONG.value != 0L) {
                        GNOME.g_object_unref(lONG.value);
                    }
                }
            });
            byte[] byArray2 = Converter.wcsToMbcs(null, "libgnomevfs-2.so.0", true);
            long l6 = OS.dlopen(byArray2, 1);
            if (l6 != 0L) {
                byArray2 = Converter.wcsToMbcs(null, "gnome_vfs_url_show", true);
                long l7 = OS.dlsym(l6, byArray2);
                if (l7 != 0L) {
                    n2 = 2;
                }
                OS.dlclose(l6);
            }
        }
        if (n2 == 0) {
            byArray = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            l = OS.XInternAtom(l2, byArray, true);
            int n3 = 0;
            while (n2 == 0 && n3 < lArray.length) {
                if (lArray[n3] != 0L && lArray[n3] == l && Program.cde_init(display)) {
                    n2 = 3;
                }
                ++n3;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(n2));
        return n2;
    }

    boolean cde_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.command, true);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_malloc(byArray2.length);
        OS.memmove(l, byArray2, (long)byArray2.length);
        DtActionArg dtActionArg = new DtActionArg();
        dtActionArg.argClass = 1;
        dtActionArg.name = l;
        long l2 = CDE.DtActionInvoke(cdeShell, byArray, dtActionArg, 1, null, null, null, 1, 0L, 0L);
        OS.g_free(l);
        return l2 != 0L;
    }

    static String cde_getAction(String string) {
        String string2 = null;
        String string3 = Program.cde_getAttribute(string, "ACTIONS");
        if (string3 != null) {
            int n = string3.indexOf("Open");
            string2 = n != -1 ? string3.substring(n, n + 4) : ((n = string3.indexOf(",")) != -1 ? string3.substring(0, n) : string3);
        }
        return string2;
    }

    static String cde_getAttribute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
        long l = CDE.DtDtsDataTypeToAttributeValue(byArray3, byArray2 = Converter.wcsToMbcs(null, string2, true), byArray = (byte[])null);
        if (l == 0L) {
            return null;
        }
        int n = OS.strlen(l);
        byte[] byArray4 = new byte[n];
        OS.memmove(byArray4, l, (long)n);
        CDE.DtDtsFreeAttributeValue(l);
        return new String(Converter.mbcsToWcs(null, byArray4));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable hashtable = new Hashtable();
        long l = CDE.DtDtsDataTypeNames();
        if (l != 0L) {
            int n = 0;
            long[] lArray = new long[1];
            OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            while (lArray[0] != 0L) {
                int n2 = OS.strlen(lArray[0]);
                byte[] byArray = new byte[n2];
                OS.memmove(byArray, lArray[0], (long)n2);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                String string2 = Program.cde_getExtension(string);
                if (!CDE.DtDtsDataTypeIsAction(byArray) && string2 != null && Program.cde_getAction(string) != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string2);
                    hashtable.put(string, vector);
                }
                OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            }
            CDE.DtDtsFreeDataTypeNames(l);
        }
        return hashtable;
    }

    static String cde_getExtension(String string) {
        String string2 = Program.cde_getAttribute(string, "NAME_TEMPLATE");
        if (string2 == null || string2.indexOf("%s.") == -1) {
            return null;
        }
        int n = string2.indexOf(".");
        return string2.substring(n);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static String cde_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.cde_getDataTypeInfo();
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        block0: while (string2 == null && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string3);
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    string2 = string3;
                    continue block0;
                }
                ++n;
            }
        }
        return string2;
    }

    static Program cde_getProgram(Display display, String string) {
        Program program = new Program();
        program.display = display;
        program.name = string;
        program.command = Program.cde_getAction(string);
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        long l = CDE.XtCreateApplicationContext();
        long l2 = OS.GDK_DISPLAY();
        byte[] byArray = Converter.wcsToMbcs(null, "CDE", true);
        byte[] byArray2 = Converter.wcsToMbcs(null, "CDE", true);
        long[] lArray = new long[1];
        CDE.XtDisplayInitialize(l, l2, byArray, byArray2, 0L, 0, lArray, 0);
        long l3 = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell(byArray, byArray2, l3, l2, null, 0);
        CDE.XtSetMappedWhenManaged(cdeShell, false);
        CDE.XtResizeWidget(cdeShell, 10, 10, 0);
        CDE.XtRealizeWidget(cdeShell);
        boolean bl = CDE.DtAppInitialize(l, l2, cdeShell, byArray, byArray);
        if (bl) {
            CDE.DtDbLoad();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseCommand(String var0) {
        var1_1 = new Vector<String>();
        var2_2 = 0;
        ** GOTO lbl25
        {
            ++var2_2;
            do {
                if (var2_2 < var0.length() && Compatibility.isWhitespace(var0.charAt(var2_2))) continue block0;
                if (var2_2 >= var0.length()) continue;
                if (var0.charAt(var2_2) == '\"' || var0.charAt(var2_2) == '\'') {
                    var3_3 = var2_2 + 1;
                    while (var3_3 < var0.length() && var0.charAt(var3_3) != var0.charAt(var2_2)) {
                        ++var3_3;
                    }
                    if (var3_3 >= var0.length()) {
                        var1_1.addElement(var0.substring(var2_2, var3_3));
                    } else {
                        var1_1.addElement(var0.substring(var2_2 + 1, var3_3));
                    }
                    var2_2 = var3_3 + 1;
                    continue;
                }
                var3_3 = var2_2;
                while (var3_3 < var0.length() && !Compatibility.isWhitespace(var0.charAt(var3_3))) {
                    ++var3_3;
                }
                var1_1.addElement(var0.substring(var2_2, var3_3));
                var2_2 = var3_3 + 1;
lbl25:
                // 4 sources

            } while (var2_2 < var0.length());
        }
        var4_4 = new String[var1_1.size()];
        var5_5 = 0;
        while (var5_5 < var1_1.size()) {
            var4_4[var5_5] = (String)var1_1.elementAt(var5_5);
            ++var5_5;
        }
        return var4_4;
    }

    boolean gnome_24_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.name, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l2 = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray2, 2);
        long l3 = GNOME.g_list_append(0L, l2);
        int n = GNOME.gnome_vfs_mime_application_launch(l, l3);
        GNOME.gnome_vfs_mime_application_free(l);
        GNOME.g_free(l2);
        GNOME.g_list_free(l3);
        return n == 0;
    }

    static boolean gnome_24_launch(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray, 2);
        int n = GNOME.gnome_vfs_url_show(l);
        GNOME.g_free(l);
        return n == 0;
    }

    boolean gnome_execute(String string) {
        Object object;
        int n;
        String[] stringArray;
        long l;
        if (this.gnomeExpectUri && (l = GNOME.gnome_vfs_make_uri_from_input((byte[])(stringArray = (String[])Converter.wcsToMbcs(null, string, true)))) != 0L) {
            n = OS.strlen(l);
            if (n > 0) {
                object = new byte[n];
                OS.memmove((byte[])object, l, (long)n);
                string = new String(Converter.mbcsToWcs(null, (byte[])object));
            }
            GNOME.g_free(l);
        }
        stringArray = Program.parseCommand(this.command);
        int n2 = -1;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n = stringArray[n3].indexOf("%f");
            if (n != -1) {
                object = stringArray[n3];
                n2 = n3;
                stringArray[n3] = String.valueOf(((String)object).substring(0, n)) + string + ((String)object).substring(n + 2);
            }
            ++n3;
        }
        if (string.length() > 0 && n2 < 0) {
            String[] stringArray2 = new String[stringArray.length + 1];
            n3 = 0;
            while (n3 < stringArray.length) {
                stringArray2[n3] = stringArray[n3];
                ++n3;
            }
            stringArray2[stringArray.length] = string;
            stringArray = stringArray2;
        }
        try {
            Compatibility.exec(stringArray);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable gnome_getMimeInfo() {
        long l;
        Hashtable hashtable = new Hashtable();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l2 = l = GNOME.gnome_vfs_get_registered_mime_types();
        while (l2 != 0L) {
            OS.memmove(lArray, l2, (long)OS.PTR_SIZEOF);
            long l3 = lArray[0];
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            long l4 = GNOME.gnome_vfs_mime_get_extensions_list(l3);
            if (l4 != 0L) {
                Vector<String> vector = new Vector<String>();
                long l5 = l4;
                while (l5 != 0L) {
                    OS.memmove(lArray2, l5, (long)OS.PTR_SIZEOF);
                    long l6 = lArray2[0];
                    int n2 = OS.strlen(l6);
                    byte[] byArray2 = new byte[n2];
                    OS.memmove(byArray2, l6, (long)n2);
                    String string2 = new String(Converter.mbcsToWcs(null, byArray2));
                    string2 = String.valueOf('.') + string2;
                    vector.addElement(string2);
                    l5 = GNOME.g_list_next(l5);
                }
                GNOME.gnome_vfs_mime_extensions_list_free(l4);
                if (vector.size() > 0) {
                    hashtable.put(string, vector);
                }
            }
            l2 = GNOME.g_list_next(l2);
        }
        if (l != 0L) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free(l);
        }
        return hashtable;
    }

    static String gnome_getMimeType(String string) {
        int n;
        String string2 = null;
        String string3 = "swt" + string;
        byte[] byArray = Converter.wcsToMbcs(null, string3, true);
        long l = GNOME.gnome_vfs_mime_type_from_name(byArray);
        if (l != 0L && (n = OS.strlen(l)) > 0) {
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, l, (long)n);
            string2 = new String(Converter.mbcsToWcs(null, byArray2));
        }
        return string2;
    }

    static Program gnome_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        if (l != 0L) {
            program = new Program();
            program.display = display;
            program.name = string;
            GnomeVFSMimeApplication gnomeVFSMimeApplication = new GnomeVFSMimeApplication();
            GNOME.memmove(gnomeVFSMimeApplication, l, GnomeVFSMimeApplication.sizeof);
            int n = OS.strlen(gnomeVFSMimeApplication.command);
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, gnomeVFSMimeApplication.command, (long)n);
            program.command = new String(Converter.mbcsToWcs(null, byArray2));
            program.gnomeExpectUri = gnomeVFSMimeApplication.expects_uris == 0;
            n = OS.strlen(gnomeVFSMimeApplication.id);
            byArray2 = new byte[n + 1];
            OS.memmove(byArray2, gnomeVFSMimeApplication.id, (long)n);
            LONG lONG = (LONG)display.getData(ICON_THEME_DATA);
            long l2 = GNOME.gnome_icon_lookup(lONG.value, 0L, null, byArray2, 0L, byArray, 0, null);
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = GNOME.gnome_icon_theme_lookup_icon(lONG.value, l2, 16, null, null);
            }
            if (l3 != 0L) {
                n = OS.strlen(l3);
                if (n > 0) {
                    byArray2 = new byte[n];
                    OS.memmove(byArray2, l3, (long)n);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray2));
                }
                GNOME.g_free(l3);
            }
            if (l2 != 0L) {
                GNOME.g_free(l2);
            }
            GNOME.gnome_vfs_mime_application_free(l);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        int n = Program.getDesktop(display);
        String string2 = null;
        switch (n) {
            case 1: 
            case 2: {
                string2 = Program.gnome_getMimeType(string);
                break;
            }
            case 3: {
                string2 = Program.cde_getMimeType(string);
            }
        }
        if (string2 == null) {
            return null;
        }
        Program program = null;
        switch (n) {
            case 1: 
            case 2: {
                program = Program.gnome_getProgram(display, string2);
                break;
            }
            case 3: {
                program = Program.cde_getProgram(display, string2);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        String[] stringArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new String[0];
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(stringArray);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (!vector.contains(vector2.elementAt(n2))) {
                    vector.addElement(vector2.elementAt(n2));
                }
                ++n2;
            }
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        Program[] programArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new Program[0];
        }
        Vector<Program> vector = new Vector<Program>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            programArray = (String)enumeration.nextElement();
            Program program = null;
            switch (n) {
                case 1: {
                    program = Program.gnome_getProgram(display, (String)programArray);
                    break;
                }
                case 3: {
                    program = Program.cde_getProgram(display, (String)programArray);
                }
            }
            if (program == null) continue;
            vector.addElement(program);
        }
        programArray = new Program[vector.size()];
        int n2 = 0;
        while (n2 < programArray.length) {
            programArray[n2] = (Program)vector.elementAt(n2);
            ++n2;
        }
        return programArray;
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string);
    }

    static boolean launch(Display display, String string) {
        String string2;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        switch (Program.getDesktop(display)) {
            case 2: {
                if (!Program.gnome_24_launch(string)) break;
                return true;
            }
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string2 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string2 = string.toLowerCase();
        if (string2.startsWith(PREFIX_HTTP) || string2.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = Program.getDesktop(this.display);
        switch (n) {
            case 2: {
                return this.gnome_24_execute(string);
            }
            case 1: {
                return this.gnome_execute(string);
            }
            case 3: {
                return this.cde_execute(string);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 1: 
            case 2: {
                return this.gnome_getImageData();
            }
            case 3: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

