/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int id;
    int width = -1;
    int itemCount = 0;
    int[] childIds;

    public TreeItem(Tree tree, int n) {
        this(TreeItem.checkNull(tree), null, n, -1, true);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(TreeItem.checkNull(tree), null, n, TreeItem.checkIndex(n2), true);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem, n, -1, true);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem, n, TreeItem.checkIndex(n2), true);
    }

    TreeItem(Tree tree, TreeItem treeItem, int n, int n2, boolean bl) {
        super(tree, n);
        this.parent = tree;
        this.parentItem = treeItem;
        if (bl) {
            tree.createItem(this, treeItem, n2);
        }
    }

    boolean _getExpanded() {
        int[] nArray = new int[1];
        OS.GetDataBrowserItemState(this.parent.handle, this.id, nArray);
        return (nArray[0] & 2) != 0;
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static int checkIndex(int n) {
        if (n < 0) {
            SWT.error(6);
        }
        return n;
    }

    int calculateWidth(int n, GC gC) {
        Image image;
        if (n == 0 && this.width != -1) {
            return this.width;
        }
        int n2 = 0;
        Image image2 = n == 0 ? this.image : (image = this.images == null ? null : this.images[n]);
        String string = n == 0 ? this.text : (this.strings == null ? "" : this.strings[n]);
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.getFont();
        }
        gC.setFont(font);
        if (image != null) {
            n2 += image.getBounds().width + this.parent.getGap();
        }
        if (string != null && string.length() > 0) {
            n2 += gC.stringExtent((String)string).x;
        }
        if (this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.index = n;
            event.gc = gC;
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewRowHeight(this.parent.handle, sArray);
            event.width = n2;
            event.height = sArray[0];
            this.parent.sendEvent(41, event);
            if (sArray[0] < event.height) {
                OS.SetDataBrowserTableViewRowHeight(this.parent.handle, (short)event.height);
                this.redrawWidget(this.parent.handle, false);
            }
            n2 = event.width;
        }
        if (n == 0) {
            this.width = n2;
        }
        return n2;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.cached = false;
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.parent.getItemCount(this);
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        this.parent.clear(this, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.parent.clearAll(this, bl);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[n] == null) {
            return this.getBackground();
        }
        return this.cellBackground[n];
    }

    public Rectangle getBounds() {
        Object object;
        int n;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        Rect rect = new Rect();
        int n2 = n = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[0].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = rect.left;
        short s = rect.top;
        int n4 = 0;
        if (this.image != null) {
            object = this.image.getBounds();
            n3 += ((Rectangle)object).width + this.parent.getGap();
        }
        object = new GC(this.parent);
        Point point = ((GC)object).stringExtent(this.text);
        ((Resource)object).dispose();
        n4 += point.x;
        if (this.parent.columnCount > 0) {
            n4 = Math.min(n4, rect.right - n3);
        }
        int n5 = rect.bottom - rect.top;
        return new Rectangle(n3, s, n4, n5);
    }

    public Rectangle getBounds(int n) {
        int n2;
        int n3;
        short s;
        short s2;
        int n4;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n5 = n4 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n4, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.parent.handle, nArray, new boolean[1]);
        if (OS.VERSION >= 4160 && nArray[0] != n4) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            s2 = rect.left;
            s = rect.top;
            n3 = rect.right - rect.left;
            n2 = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n4, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            s2 = rect2.left;
            s = rect2.top;
            n3 = rect.right - rect2.left + 1;
            n2 = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(s2, s, n3, n2);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return (this.state & 0x100) != 0 ? false : this._getExpanded();
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[n] == null) {
            return this.getForeground();
        }
        return this.cellForeground[n];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && n >= 0 && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        Rectangle rectangle;
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n3 = n2 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n2, 0x2D2D2D2D, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        short s = rect.left;
        short s2 = rect.top;
        int n4 = 0;
        if (n == 0 && this.image != null) {
            rectangle = this.image.getBounds();
            n4 += rectangle.width;
        }
        if (n != 0 && this.images != null && this.images[n] != null) {
            rectangle = this.images[n].getBounds();
            n4 += rectangle.width;
        }
        int n5 = rect.bottom - rect.top + 1;
        return new Rectangle(s, s2, n4, n5);
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n >= this.itemCount) {
            this.error(6);
        }
        return this.parent._getItem(this, n);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.parent.getItemCount(this);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.parent.getItems(this);
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && n >= 0 && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        int n2;
        int n3;
        short s;
        int n4;
        int n5;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n != 0 && (n < 0 || n >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int n6 = n5 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n5, 0, rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.parent.handle, nArray, new boolean[1]);
        int n7 = 0;
        int n8 = n == 0 ? 0 : this.parent.getInsetWidth(n5, false) / 2;
        Image image = this.getImage(n);
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            n7 = rectangle.width + this.parent.getGap();
        }
        if (OS.VERSION >= 4160 && nArray[0] != n5) {
            if (this.parent.getLinesVisible()) {
                rect.left = (short)(rect.left + 1);
                rect.top = (short)(rect.top + 1);
            }
            n4 = rect.left + n7 + n8;
            s = rect.top;
            n3 = Math.max(0, rect.right - rect.left - n7 - n8 * 2);
            n2 = rect.bottom - rect.top;
        } else {
            Rect rect2 = new Rect();
            if (OS.GetDataBrowserItemPartBounds(this.parent.handle, this.id, n5, 0x2D2D2D2D, rect2) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            n4 = rect2.left + n7 + n8;
            s = rect2.top;
            n3 = Math.max(0, rect.right - rect2.left + 1 - n7 - n8 * 2);
            n2 = rect2.bottom - rect2.top + 1;
        }
        return new Rectangle(n4, s, n3, n2);
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != this) {
            return -1;
        }
        return this.parent._indexOf(this, treeItem);
    }

    void redraw(int n) {
        Rect rect;
        if (this.parent.ignoreRedraw) {
            return;
        }
        if (this.parent.drawCount != 0 && n != 1024) {
            return;
        }
        int n2 = this.parent.handle;
        int n3 = this.parentItem == null ? 0 : this.parentItem.id;
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.parent.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.parent.handle, dataBrowserCallbacks);
        int[] nArray = new int[]{this.id};
        if (n == 0) {
            if ((this.parent.style & 0x20) != 0) {
                OS.UpdateDataBrowserItems(n2, n3, nArray.length, nArray, 0, 1024);
            }
            if (this.parent.columnCount == 0) {
                OS.UpdateDataBrowserItems(n2, n3, nArray.length, nArray, 0, this.parent.column_id);
            } else {
                int n4 = 0;
                while (n4 < this.parent.columnCount) {
                    OS.UpdateDataBrowserItems(n2, n3, nArray.length, nArray, 0, this.parent.columns[n4].id);
                    ++n4;
                }
            }
        } else {
            OS.UpdateDataBrowserItems(n2, n3, nArray.length, nArray, 0, n);
        }
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.parent.handle, dataBrowserCallbacks);
        if (n == 1024 && OS.GetDataBrowserItemPartBounds(n2, this.id, n, 0, rect = new Rect()) == 0) {
            short s = rect.left;
            int n5 = rect.top - 1;
            int n6 = rect.right - rect.left;
            int n7 = 1;
            this.redrawWidget(n2, s, n5, n6, n7, false);
        }
    }

    void releaseChildren(boolean bl) {
        if (bl) {
            this.parent.releaseItems(this.childIds);
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parentItem = null;
        this.id = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.itemCount - 1;
        while (n >= 0) {
            TreeItem treeItem = this.parent._getItem(this.childIds[n], false);
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
            }
            --n;
        }
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setBackground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[n2];
        }
        if ((color2 = this.cellBackground[n]) == color) {
            return;
        }
        this.cellBackground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        int n3 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        this.redraw(n3);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.setChecked(bl, false);
    }

    void setChecked(boolean bl, boolean bl2) {
        this.checked = bl;
        this.cached = true;
        this.redraw(1024);
        if (bl2) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        if (bl == this.getExpanded()) {
            return;
        }
        this.parent.ignoreExpand = true;
        if (bl) {
            OS.OpenDataBrowserContainer(this.parent.handle, this.id);
        } else {
            OS.CloseDataBrowserContainer(this.parent.handle, this.id);
        }
        this.parent.ignoreExpand = false;
        this.cached = true;
        if (bl) {
            this.parent.setScrollWidth(false, this.childIds, false);
        } else {
            this.parent.setScrollWidth(true);
            this.parent.fixScrollBar();
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.cached = true;
        int n3 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        this.redraw(n3);
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(0);
    }

    public void setForeground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[n2];
        }
        if ((color2 = this.cellForeground[n]) == color) {
            return;
        }
        this.cellForeground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        int n3 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
        this.redraw(n3);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        this.cached = true;
        this.redraw(1024);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image);
        }
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n >= 0 && n < n2) {
            if (this.images == null) {
                this.images = new Image[n2];
            }
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            this.images[n] = image;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        if (n >= 0 && n < n2) {
            int n3 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
            this.redraw(n3);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.parent.setItemCount(this, n);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n >= 0 && n < n2) {
            if (this.strings == null) {
                this.strings = new String[n2];
            }
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        if (n >= 0 && n < n2) {
            int n3 = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[n].id;
            this.redraw(n3);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

