/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HIThemePopupArrowDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeSeparatorDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    int handle;
    int iconHandle;
    int labelHandle;
    int cIcon;
    int visibleRgn;
    int partCode;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int ARROW_WIDTH = 9;
    static final int INSET = 3;
    static final String[] AX_ATTRIBUTES = new String[]{"AXDescription", "AXTitle", "AXValue"};

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, n2);
    }

    int actionProc(int n, int n2) {
        int n3;
        int n4 = this.parent.actionProc(n, n2);
        if (n4 == 0) {
            return n4;
        }
        if (this.isDisposed()) {
            return 0;
        }
        this.partCode = n2;
        if (this.text.length() > 0 && n == this.labelHandle) {
            if (this.image != null && this.iconHandle != 0) {
                n3 = n2 != 0 ? 16384 : 0;
                OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[]{(short)n3});
                this.redrawWidget(this.iconHandle, false);
            }
            this.redrawWidget(this.labelHandle, false);
        }
        if (this.image != null && n == this.iconHandle) {
            this.redrawWidget(this.labelHandle, false);
        }
        if (n == this.handle) {
            if (this.image != null && this.iconHandle != 0) {
                n3 = n2 != 0 ? 16384 : 0;
                OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[]{(short)n3});
                this.redrawWidget(this.iconHandle, false);
            }
            if (this.labelHandle != 0) {
                this.redrawWidget(this.labelHandle, false);
            }
        }
        return n4;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        if (n == this.labelHandle && (this.partCode != 0 || (this.state & 8) != 0 && OS.VERSION >= 4160)) {
            Object[] objectArray;
            Object object;
            HIThemeTextInfo hIThemeTextInfo = new HIThemeTextInfo();
            hIThemeTextInfo.state = this.partCode != 0 ? 2 : (OS.IsControlActive(this.labelHandle) ? ((this.state & 8) == 0 ? 1 : 7) : ((this.state & 8) == 0 ? 0 : 8));
            Font font = this.parent.font;
            if (font != null) {
                object = new short[1];
                objectArray = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, object, objectArray);
                OS.TextFont(object[0]);
                OS.TextFace((short)(objectArray[0] | font.style));
                OS.TextSize((short)font.size);
                hIThemeTextInfo.fontID = (short)200;
            } else {
                hIThemeTextInfo.fontID = (short)this.parent.defaultThemeFont();
            }
            object = new CGRect();
            OS.HIViewGetBounds(this.labelHandle, (CGRect)object);
            objectArray = new int[1];
            OS.GetEventParameter(n4, 1668183160, 1668183160, null, 4, null, (int[])objectArray);
            if ((this.state & 8) != 0 && OS.VERSION >= 4160) {
                OS.HIThemeSetTextFill(36, 0, objectArray[0], 0);
            } else {
                int n6 = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(objectArray[0], n6);
                OS.CGColorSpaceRelease(n6);
                OS.CGContextSetFillColor(objectArray[0], this.parent.getForegroundColor().handle);
            }
            int[] nArray = new int[1];
            OS.GetControlData(this.labelHandle, (short)0, 1667658612, 4, nArray, null);
            OS.HIThemeDrawTextBox(nArray[0], (CGRect)object, hIThemeTextInfo, objectArray[0], 0);
            OS.CFRelease(nArray[0]);
            return 0;
        }
        if (n == this.iconHandle && OS.VERSION >= 4160) {
            int n7;
            int n8;
            Image image = null;
            image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
            if (image != null && (n8 = OS.CGImageGetAlphaInfo(n7 = image.handle)) == 4) {
                int[] nArray = new int[1];
                OS.GetEventParameter(n4, 1668183160, 1668183160, null, 4, null, nArray);
                int n9 = nArray[0];
                CGRect cGRect = new CGRect();
                OS.HIViewGetBounds(this.iconHandle, cGRect);
                if (this.partCode != 0) {
                    OS.HICreateTransformedCGImage(n7, 16384, nArray);
                    n7 = nArray[0];
                } else if ((this.state & 8) != 0) {
                    OS.HICreateTransformedCGImage(n7, 1, nArray);
                    n7 = nArray[0];
                }
                OS.HIViewDrawCGImage(n9, cGRect, n7);
                if (n7 != image.handle) {
                    OS.CGImageRelease(n7);
                }
                return 0;
            }
        }
        return super.callPaintEventHandler(n, n2, n3, n4, n5);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int colorProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 30: {
                if (this.parent.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.parent.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)n3, n4 != 0);
                }
                return 0;
            }
            case 23: {
                float[] fArray;
                float[] fArray2 = fArray = this.parent.background != null ? this.parent.background : this.parent.getParentBackground();
                if (fArray != null) {
                    OS.RGBBackColor(this.toRGBColor(fArray));
                } else {
                    OS.SetThemeBackground((short)1, (short)n3, n4 != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    Point computeSize() {
        int n = 0;
        int n2 = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                n = this.getWidth();
                n2 = 22;
            } else {
                n = 24;
                n2 = this.getWidth();
            }
            if (this.control != null) {
                n2 = Math.max(n2, this.control.getMininumHeight());
            }
        } else {
            int n3 = 0;
            if (this.text.length() != 0 || this.image != null) {
                int n4 = 0;
                int n5 = 0;
                if (this.text.length() != 0) {
                    Point point = this.textExtent();
                    n4 = point.x;
                    n5 = point.y;
                }
                int n6 = 0;
                int n7 = 0;
                if (this.image != null) {
                    if (this.text.length() != 0) {
                        n3 = 2;
                    }
                    Rectangle rectangle = this.image.getBounds();
                    n6 = rectangle.width;
                    n7 = rectangle.height;
                }
                if ((this.parent.style & 0x20000) != 0) {
                    n = n4 + n6 + n3;
                    n2 = Math.max(n5, n7);
                } else {
                    n = Math.max(n4, n6);
                    n2 = n5 + n7 + n3;
                }
            } else {
                n = 24;
                n2 = 22;
            }
            if ((this.style & 4) != 0) {
                n += 9;
            }
            n += 6;
            n2 += 6;
        }
        return new Point(n, n2);
    }

    boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n = OS.GetControlOwner(this.parent.handle);
        int n2 = 18;
        OS.CreateUserPaneControl(n, null, n2, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        OS.HIObjectSetAccessibilityIgnored(this.handle, true);
        if ((this.style & 2) == 0) {
            ControlButtonContentInfo controlButtonContentInfo = new ControlButtonContentInfo();
            OS.CreateIconControl(n, null, controlButtonContentInfo, false, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.iconHandle = nArray[0];
            OS.HIObjectSetAccessibilityIgnored(this.iconHandle, true);
            ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
            Font font = this.parent.font;
            if (font != null) {
                short[] sArray = new short[1];
                short[] sArray2 = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, sArray, sArray2);
                controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 7);
                controlFontStyleRec.font = sArray[0];
                controlFontStyleRec.style = (short)(sArray2[0] | font.style);
                controlFontStyleRec.size = (short)font.size;
            } else {
                controlFontStyleRec.flags = (short)128;
                controlFontStyleRec.font = (short)this.parent.defaultThemeFont();
            }
            OS.CreateStaticTextControl(n, null, 0, controlFontStyleRec, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.labelHandle = nArray[0];
            OS.HIObjectSetAccessibilityIgnored(this.labelHandle, true);
        }
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
        this.toolTipText = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.iconHandle != 0) {
            this.display.removeWidget(this.iconHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        int n = this.handle;
        this.releaseHandle();
        if (n != 0) {
            OS.DisposeControl(n);
        }
    }

    void drawBackground(int n, int n2) {
        if (n == this.handle && this.getSelection()) {
            CGRect cGRect = new CGRect();
            OS.HIViewGetBounds(this.handle, cGRect);
            OS.CGContextSaveGState(n2);
            OS.CGContextSetFillColor(n2, new float[]{0.1f, 0.1f, 0.1f, 0.1f});
            OS.CGContextFillRect(n2, cGRect);
            OS.CGContextSetStrokeColor(n2, new float[]{0.2f, 0.2f, 0.2f, 0.2f});
            cGRect.x += 0.5f;
            cGRect.y += 0.5f;
            cGRect.width -= 1.0f;
            cGRect.height -= 1.0f;
            OS.CGContextStrokeRect(n2, cGRect);
            OS.CGContextRestoreGState(n2);
        }
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        if (n == this.handle && (this.style & 6) != 0) {
            Object object;
            int n6 = OS.IsControlEnabled(n) ? (OS.IsControlActive(n) ? 1 : 0) : (OS.IsControlActive(n) ? 7 : 8);
            CGRect cGRect = new CGRect();
            OS.HIViewGetBounds(this.handle, cGRect);
            if ((this.style & 2) != 0 && this.control == null) {
                cGRect.y += 2.0f;
                cGRect.height -= 4.0f;
                object = new HIThemeSeparatorDrawInfo();
                ((HIThemeSeparatorDrawInfo)object).state = n6;
                OS.HIThemeDrawSeparator(cGRect, (HIThemeSeparatorDrawInfo)object, n2, 0);
            }
            if ((this.style & 4) != 0) {
                cGRect.y = cGRect.height / 2.0f - 1.0f;
                cGRect.x = cGRect.width - 9.0f;
                object = new HIThemePopupArrowDrawInfo();
                ((HIThemePopupArrowDrawInfo)object).state = n6;
                ((HIThemePopupArrowDrawInfo)object).orientation = 1;
                ((HIThemePopupArrowDrawInfo)object).size = 1;
                OS.HIThemeDrawPopupArrow(cGRect, (HIThemePopupArrowDrawInfo)object, n2, 0);
            }
        }
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getControlBounds(this.handle);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    int getDrawCount(int n) {
        return this.parent.getDrawCount(n);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getVisibleRegion(int n, boolean bl) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(n, this.visibleRgn, false);
        }
        int n2 = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, n2);
        return n2;
    }

    int helpProc(int n, int n2, int n3, int n4, int n5) {
        if (this.parent.toolTipText == null) {
            switch (n3) {
                case 0: {
                    short[] sArray = new short[]{-1};
                    if (this.toolTipText != null && this.toolTipText.length() != 0) {
                        char[] cArray = new char[this.toolTipText.length()];
                        this.toolTipText.getChars(0, cArray.length, cArray, 0);
                        int n6 = this.fixMnemonic(cArray);
                        if (this.display.helpString != 0) {
                            OS.CFRelease(this.display.helpString);
                        }
                        this.display.helpString = OS.CFStringCreateWithCharacters(0, cArray, n6);
                        HMHelpContentRec hMHelpContentRec = new HMHelpContentRec();
                        OS.memmove(hMHelpContentRec, n5, 534);
                        hMHelpContentRec.version = 3;
                        hMHelpContentRec.tagSide = 0;
                        this.display.helpWidget = null;
                        hMHelpContentRec.absHotRect_left = 0;
                        hMHelpContentRec.absHotRect_top = 0;
                        hMHelpContentRec.absHotRect_right = 0;
                        hMHelpContentRec.absHotRect_bottom = 0;
                        hMHelpContentRec.content0_contentType = 1667658612;
                        hMHelpContentRec.content0_tagCFString = this.display.helpString;
                        hMHelpContentRec.content1_contentType = 1667658612;
                        hMHelpContentRec.content1_tagCFString = this.display.helpString;
                        OS.memmove(n5, hMHelpContentRec, 534);
                        sArray[0] = 0;
                    }
                    OS.memmove(n4, sArray, 2);
                    break;
                }
                case 1: {
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpWidget = null;
                    this.display.helpString = 0;
                }
            }
            return 0;
        }
        return this.parent.helpProc(n, n2, n3, n4, n5);
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.controlProc;
        int n2 = this.display.colorProc;
        int[] nArray = new int[]{1668183148, 4, 1668183148, 1, 1668183148, 3, 1668183148, 51};
        int n3 = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(n3, n, nArray.length / 2, nArray, this.handle, null);
        int[] nArray2 = new int[]{1668183148, 4, 1668183148, 3, 1668183148, 51, 1668183148, 17};
        int n4 = this.display.accessibilityProc;
        int[] nArray3 = new int[]{1633903461, 21, 1633903461, 22};
        if (this.iconHandle != 0) {
            n3 = OS.GetControlEventTarget(this.iconHandle);
            OS.InstallEventHandler(n3, n, nArray2.length / 2, nArray2, this.iconHandle, null);
            OS.SetControlColorProc(this.iconHandle, n2);
            OS.SetControlAction(this.iconHandle, this.display.actionProc);
            OS.InstallEventHandler(n3, n4, nArray3.length / 2, nArray3, this.iconHandle, null);
        }
        if (this.labelHandle != 0) {
            n3 = OS.GetControlEventTarget(this.labelHandle);
            OS.InstallEventHandler(n3, n, nArray2.length / 2, nArray2, this.labelHandle, null);
            OS.SetControlColorProc(this.labelHandle, n2);
            OS.SetControlAction(this.labelHandle, this.display.actionProc);
        }
        if ((this.style & 2) == 0) {
            OS.SetControlAction(this.handle, this.display.actionProc);
        }
        int n5 = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, n5);
        OS.SetControlColorProc(this.handle, n2);
    }

    void invalidateVisibleRegion(int n) {
        this.resetVisibleRegion(n);
        this.parent.resetVisibleRegion(n);
    }

    void invalWindowRgn(int n, int n2) {
        this.parent.invalWindowRgn(n, n2);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    int kEventAccessibleGetAllAttributeNames(int n, int n2, int n3) {
        int n4 = -9874;
        String[] stringArray = this.getAxAttributes();
        if (stringArray != null) {
            OS.CallNextEventHandler(n, n2);
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1635020403, 1667657057, null, 4, null, nArray);
            int n5 = nArray[0];
            int n6 = OS.CFArrayGetCount(n5);
            String[] stringArray2 = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                int n8 = OS.CFArrayGetValueAtIndex(n5, n7);
                int n9 = OS.CFStringGetLength(n8);
                char[] cArray = new char[n9];
                CFRange cFRange = new CFRange();
                cFRange.length = n9;
                OS.CFStringGetCharacters(n8, cFRange, cArray);
                stringArray2[n7] = new String(cArray);
                ++n7;
            }
            n7 = 0;
            while (n7 < stringArray.length) {
                if (!this.contains(stringArray2, stringArray[n7])) {
                    String string = stringArray[n7];
                    char[] cArray = new char[string.length()];
                    string.getChars(0, cArray.length, cArray, 0);
                    int n10 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                    OS.CFArrayAppendValue(n5, n10);
                    OS.CFRelease(n10);
                }
                ++n7;
            }
            n4 = 0;
        }
        if (this.parent.accessible != null) {
            n4 = this.parent.accessible.internal_kEventAccessibleGetAllAttributeNames(n, n2, n4);
        }
        return n4;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        int n4 = -9874;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray);
        int n5 = 0;
        if (nArray[0] != 0) {
            n5 = OS.CFStringGetLength(nArray[0]);
        }
        char[] cArray = new char[n5];
        CFRange cFRange = new CFRange();
        cFRange.length = n5;
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        String string = new String(cArray);
        if (string.equals("AXRole") || string.equals("AXRoleDescription")) {
            String string2;
            String string3 = (this.style & 8) != 0 ? "AXButton" : ((this.style & 0x10) != 0 ? "AXRadioButton" : ((this.style & 0x20) != 0 ? "AXCheckBox" : (string2 = (this.style & 4) != 0 ? "AXMenuButton" : null)));
            if (string2 != null) {
                cArray = new char[string2.length()];
                string2.getChars(0, cArray.length, cArray, 0);
                nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray[0] != 0) {
                    if (string.equals("AXRole")) {
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                    } else {
                        int n6 = OS.HICopyAccessibilityRoleDescription(nArray[0], 0);
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n6});
                        OS.CFRelease(n6);
                    }
                    OS.CFRelease(nArray[0]);
                    n4 = 0;
                }
            }
        } else if (string.equals("AXTitle") || string.equals("AXDescription")) {
            String string4 = this.toolTipText;
            if (string4 == null || string4.equals("")) {
                string4 = this.text;
            }
            if (string4 != null && !string4.equals("")) {
                cArray = new char[string4.length()];
                string4.getChars(0, cArray.length, cArray, 0);
                int n7 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n7});
                OS.CFRelease(n7);
                n4 = 0;
            }
        } else if (string.equals("AXValue") && (this.style & 0x30) != 0) {
            OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{this.selection ? 1 : 0});
            n4 = 0;
        }
        if (this.parent.accessible != null) {
            n4 = this.parent.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        return this.parent.kEventControlGetClickActivation(n, n2, n3);
    }

    int kEventControlHit(int n, int n2, int n3) {
        int n4 = super.kEventControlHit(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventControlHitTest(int n, int n2, int n3) {
        if (this.display.clickCountButton == 2) {
            return 0;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1668575852, null, 4, null, nArray);
        if (nArray[0] == this.labelHandle || nArray[0] == this.handle && (this.style & 2) == 0) {
            CGRect cGRect = new CGRect();
            OS.HIViewGetBounds(nArray[0], cGRect);
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 1835822947, 1751740532, null, 8, null, cGPoint);
            if (OS.CGRectContainsPoint(cGRect, cGPoint) != 0 && (nArray[0] != this.handle || (this.style & 4) == 0 || cGRect.width - cGPoint.x >= 12.0f)) {
                OS.SetEventParameter(n2, 1668313716, 1668313716, 2, new short[]{1});
                return 0;
            }
        }
        return -9874;
    }

    int kEventControlTrack(int n, int n2, int n3) {
        int n4 = this.parent.kEventControlTrack(n, n2, n3);
        if (this.isDisposed()) {
            return 0;
        }
        this.partCode = 0;
        if (this.text.length() > 0 && this.labelHandle != 0) {
            this.redrawWidget(this.labelHandle, false);
        }
        if (this.image != null && this.iconHandle != 0) {
            OS.SetControlData(this.iconHandle, 0, 1953654381, 2, new short[1]);
            this.redrawWidget(this.iconHandle, false);
        }
        return n4;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = this.parent.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if ((this.style & 4) != 0) {
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 2003660661, 1751740532, null, 8, null, cGPoint);
            OS.HIViewConvertPoint(cGPoint, 0, this.handle);
            CGRect cGRect = new CGRect();
            OS.HIViewGetFrame(this.handle, cGRect);
            int n5 = (int)cGPoint.x;
            int n6 = (int)cGRect.width;
            if (n6 - n5 < 12) {
                OS.HIViewConvertPoint(cGPoint, this.handle, this.parent.handle);
                Event event = new Event();
                event.detail = 4;
                event.x = (int)cGRect.x;
                event.y = (int)(cGRect.y + cGRect.height);
                this.postEvent(13, event);
            }
        }
        return n4;
    }

    int kEventMouseDragged(int n, int n2, int n3) {
        return this.parent.kEventMouseDragged(n, n2, n3);
    }

    int kEventMouseMoved(int n, int n2, int n3) {
        return this.parent.kEventMouseMoved(n, n2, n3);
    }

    int kEventMouseUp(int n, int n2, int n3) {
        return this.parent.kEventMouseUp(n, n2, n3);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.iconHandle != 0) {
            this.display.addWidget(this.iconHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.iconHandle = 0;
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resetVisibleRegion(int n) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    void selectRadio() {
        int n = 0;
        ToolItem[] toolItemArray = this.parent.getItems();
        while (n < toolItemArray.length && toolItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && toolItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < toolItemArray.length && toolItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    void setBackground(float[] fArray) {
        this.parent.setBackground(this.handle, fArray);
        if (this.labelHandle != 0) {
            this.parent.setBackground(this.labelHandle, fArray);
        }
        if (this.iconHandle != 0) {
            this.parent.setBackground(this.iconHandle, fArray);
        }
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.setBounds(this.handle, n, n2, n3, n4, true, true, false);
        if ((this.style & 2) != 0) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.text.length() != 0) {
            Point point = this.textExtent();
            n6 = point.x;
            n7 = point.y;
        }
        int n8 = 0;
        int n9 = 0;
        if (this.image != null) {
            if (this.text.length() != 0) {
                n5 = 2;
            }
            Rectangle rectangle = this.image.getBounds();
            n8 = rectangle.width;
            n9 = rectangle.height;
        }
        int n10 = 0;
        if ((this.style & 4) != 0) {
            n10 = 9;
        }
        if ((this.parent.style & 0x20000) != 0) {
            int n11 = 3;
            int n12 = 3 + (n4 - 6 - n9) / 2;
            this.setBounds(this.iconHandle, n11, n12, n8, n9, true, true, false);
            int n13 = n11 + n8 + n5;
            int n14 = 3 + (n4 - 6 - n7) / 2;
            this.setBounds(this.labelHandle, n13, n14, n6, n7, true, true, false);
        } else {
            int n15 = 3 + (n3 - 6 - n10 - n8) / 2;
            int n16 = 3 + (n4 - n9 - n7 - 6) / 2;
            this.setBounds(this.iconHandle, n15, n16, n8, n9, true, true, false);
            int n17 = 3 + (n3 - 6 - n10 - n6) / 2;
            int n18 = n16 + n9 + n5;
            this.setBounds(this.labelHandle, n17, n18, n6, n7, true, true, false);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.redrawWidget(this.handle, false);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 && bl) {
            return;
        }
        if (bl) {
            this.state &= 0xFFFFFFF7;
            OS.EnableControl(this.handle);
        } else {
            this.state |= 8;
            OS.DisableControl(this.handle);
        }
    }

    void setFontStyle(Font font) {
        this.parent.setFontStyle(this.labelHandle, font);
    }

    void setForeground(float[] fArray) {
        this.parent.setForeground(this.handle, fArray);
        if (this.labelHandle != 0) {
            this.parent.setForeground(this.labelHandle, fArray);
        }
        if (this.iconHandle != 0) {
            this.parent.setForeground(this.iconHandle, fArray);
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
        OS.HIObjectSetAccessibilityIgnored(this.iconHandle, image == null);
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = bl;
        this.redrawWidget(this.handle, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, n);
        if (n2 == 0) {
            this.error(13);
        }
        OS.SetControlData(this.labelHandle, 0, 1667658612, 4, new int[]{n2});
        OS.CFRelease(n2);
        this.redrawWidget(this.labelHandle, false);
        this.parent.relayout();
        OS.HIObjectSetAccessibilityIgnored(this.labelHandle, string.equals(""));
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void setVisible(boolean bl) {
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.setVisible(this.handle, bl);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0 || this.width == n) {
            return;
        }
        this.width = n;
        this.redrawWidget(this.handle, false);
        this.parent.relayout();
    }

    void setZOrder() {
        OS.HIViewAddSubview(this.parent.handle, this.handle);
        if (this.iconHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.iconHandle);
        }
        if (this.labelHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.labelHandle);
        }
    }

    void updateImage(boolean bl) {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        Image image = null;
        image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
        ControlButtonContentInfo controlButtonContentInfo = new ControlButtonContentInfo();
        if (image != null) {
            this.cIcon = this.createCIcon(image);
            controlButtonContentInfo.contentType = (short)130;
            controlButtonContentInfo.iconRef = this.cIcon;
        }
        OS.SetBevelButtonContentInfo(this.iconHandle, controlButtonContentInfo);
        if (bl) {
            this.redrawWidget(this.iconHandle, false);
            this.parent.relayout();
        }
    }

    Point textExtent() {
        int[] nArray = new int[1];
        OS.GetControlData(this.labelHandle, (short)0, 1667658612, 4, nArray, null);
        Point point = this.parent.textExtent(nArray[0], 0);
        if (nArray[0] != 0) {
            OS.CFRelease(nArray[0]);
        }
        return point;
    }
}

