/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        Control control;
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            control.fillBackground(this.handle, gC.handle, new Rectangle(n, n2, n3, n4));
        } else {
            gC.fillRectangle(n, n2, n3, n4);
        }
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        super.drawWidget(n, n2, n3, n4, n5);
        if (OS.VERSION >= 4160) {
            if (n != this.handle) {
                return;
            }
            if (this.caret == null) {
                return;
            }
            if (this.caret.isShowing) {
                OS.CGContextSaveGState(n2);
                CGRect cGRect = new CGRect();
                cGRect.x = this.caret.x;
                cGRect.y = this.caret.y;
                Image image = this.caret.image;
                OS.CGContextSetBlendMode(n2, 10);
                if (image != null) {
                    cGRect.width = OS.CGImageGetWidth(image.handle);
                    cGRect.height = OS.CGImageGetHeight(image.handle);
                    OS.CGContextScaleCTM(n2, 1.0f, -1.0f);
                    OS.CGContextTranslateCTM(n2, 0.0f, -(cGRect.height + 2.0f * cGRect.y));
                    OS.CGContextDrawImage(n2, cGRect, image.handle);
                } else {
                    cGRect.width = this.caret.width != 0 ? this.caret.width : 1;
                    cGRect.height = this.caret.height;
                    OS.CGContextSetShouldAntialias(n2, false);
                    int n6 = OS.CGColorSpaceCreateDeviceRGB();
                    OS.CGContextSetFillColorSpace(n2, n6);
                    OS.CGContextSetFillColor(n2, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    OS.CGColorSpaceRelease(n6);
                    OS.CGContextFillRect(n2, cGRect);
                }
                OS.CGContextRestoreGState(n2);
            }
        }
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    int kEventControlDraw(int n, int n2, int n3) {
        boolean bl;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1668575852, null, 4, null, nArray);
        boolean bl2 = bl = OS.VERSION < 4160 && nArray[0] == this.handle && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n4 = super.kEventControlDraw(n, n2, n3);
        if (bl) {
            this.caret.setFocus();
        }
        return n4;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0 && !this.isDisposed()) {
            Shell shell = this.getShell();
            short[] sArray = new short[1];
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] != 0) {
                if (this.caret != null) {
                    this.caret.setFocus();
                }
                OS.ActivateTSMDocument(shell.imHandle);
            } else {
                if (this.caret != null) {
                    this.caret.killFocus();
                }
                OS.DeactivateTSMDocument(shell.imHandle);
            }
        }
        return n4;
    }

    int kEventTextInputOffsetToPos(int n, int n2, int n3) {
        int n4;
        if (this.ime != null && (n4 = this.ime.kEventTextInputOffsetToPos(n, n2, n3)) != -9874) {
            return n4;
        }
        return super.kEventTextInputOffsetToPos(n, n2, n3);
    }

    int kEventTextInputPosToOffset(int n, int n2, int n3) {
        int n4;
        if (this.ime != null && (n4 = this.ime.kEventTextInputPosToOffset(n, n2, n3)) != -9874) {
            return n4;
        }
        return super.kEventTextInputPosToOffset(n, n2, n3);
    }

    int kEventTextInputUnicodeForKeyEvent(int n, int n2, int n3) {
        int n4 = super.kEventTextInputUnicodeForKeyEvent(n, n2, n3);
        if (n4 != 0 && this.caret != null) {
            OS.CGDisplayHideCursor(OS.CGMainDisplayID());
        }
        return n4;
    }

    int kEventTextInputUpdateActiveInputArea(int n, int n2, int n3) {
        int n4;
        if (this.ime != null && (n4 = this.ime.kEventTextInputUpdateActiveInputArea(n, n2, n3)) != -9874) {
            return n4;
        }
        return super.kEventTextInputUpdateActiveInputArea(n, n2, n3);
    }

    int kEventTextInputGetSelectedText(int n, int n2, int n3) {
        int n4;
        if (this.ime != null && (n4 = this.ime.kEventTextInputGetSelectedText(n, n2, n3)) != -9874) {
            return n4;
        }
        return super.kEventTextInputGetSelectedText(n, n2, n3);
    }

    void redrawWidget(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = OS.VERSION < 4160 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, bl);
        if (bl2) {
            this.caret.setFocus();
        }
    }

    void redrawWidget(int n, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = OS.VERSION < 4160 && this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, n5, bl);
        if (bl2) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Control[] controlArray;
        Control control;
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl2;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isDrawing(this.handle)) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        if ((rectangle2 = new Rectangle(n3, n4, n5, n6)).intersects(rectangle = this.getClientArea())) {
            this.update(bl);
        }
        if ((control = this.findBackgroundControl()) != null && control.backgroundImage != null) {
            this.redrawWidget(this.handle, n3, n4, n5, n6, false);
            this.redrawWidget(this.handle, n, n2, n5, n6, false);
        } else {
            controlArray = new GC(this);
            controlArray.copyArea(n3, n4, n5, n6, n, n2);
            controlArray.dispose();
        }
        if (bl) {
            controlArray = this._getChildren();
            int n9 = 0;
            while (n9 < controlArray.length) {
                Control control2 = controlArray[n9];
                Rectangle rectangle3 = control2.getBounds();
                if (Math.min(n3 + n5, rectangle3.x + rectangle3.width) >= Math.max(n3, rectangle3.x) && Math.min(n4 + n6, rectangle3.y + rectangle3.height) >= Math.max(n4, rectangle3.y)) {
                    control2.setLocation(rectangle3.x + n7, rectangle3.y + n8);
                }
                ++n9;
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }
}

