/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.opengl.carbon.AGL;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int context;
    int pixelFormat;
    static final int MAX_ATTRIBUTES = 32;
    static final String RESET_VISIBLE_REGION = "org.eclipse.swt.internal.resetVisibleRegion";

    public GLCanvas(Composite composite, int n, GLData gLData) {
        super(composite, n);
        if (gLData == null) {
            SWT.error(4);
        }
        int[] nArray = new int[32];
        int n2 = 0;
        nArray[n2++] = 4;
        if (gLData.doubleBuffer) {
            nArray[n2++] = 5;
        }
        if (gLData.stereo) {
            nArray[n2++] = 6;
        }
        if (gLData.redSize > 0) {
            nArray[n2++] = 8;
            nArray[n2++] = gLData.redSize;
        }
        if (gLData.greenSize > 0) {
            nArray[n2++] = 9;
            nArray[n2++] = gLData.greenSize;
        }
        if (gLData.blueSize > 0) {
            nArray[n2++] = 10;
            nArray[n2++] = gLData.blueSize;
        }
        if (gLData.alphaSize > 0) {
            nArray[n2++] = 11;
            nArray[n2++] = gLData.alphaSize;
        }
        if (gLData.depthSize > 0) {
            nArray[n2++] = 12;
            nArray[n2++] = gLData.depthSize;
        }
        if (gLData.stencilSize > 0) {
            nArray[n2++] = 13;
            nArray[n2++] = gLData.stencilSize;
        }
        if (gLData.accumRedSize > 0) {
            nArray[n2++] = 14;
            nArray[n2++] = gLData.accumRedSize;
        }
        if (gLData.accumGreenSize > 0) {
            nArray[n2++] = 15;
            nArray[n2++] = gLData.accumGreenSize;
        }
        if (gLData.accumBlueSize > 0) {
            nArray[n2++] = 16;
            nArray[n2++] = gLData.accumBlueSize;
        }
        if (gLData.accumAlphaSize > 0) {
            nArray[n2++] = 17;
            nArray[n2++] = gLData.accumAlphaSize;
        }
        if (gLData.sampleBuffers > 0) {
            nArray[n2++] = 55;
            nArray[n2++] = gLData.sampleBuffers;
        }
        if (gLData.samples > 0) {
            nArray[n2++] = 56;
            nArray[n2++] = gLData.samples;
        }
        nArray[n2++] = 0;
        this.pixelFormat = AGL.aglChoosePixelFormat(0, 0, nArray);
        if (this.pixelFormat == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.context = AGL.aglCreateContext(this.pixelFormat, 0);
        int n3 = OS.GetControlOwner(this.handle);
        int n4 = OS.GetWindowPort(n3);
        AGL.aglSetDrawable(this.context, n4);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        AGL.aglDestroyContext(GLCanvas.this.context);
                        AGL.aglDestroyPixelFormat(GLCanvas.this.pixelFormat);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.setData(RESET_VISIBLE_REGION, new Runnable(){

            public void run() {
                if (GLCanvas.this.isDisposed()) {
                    return;
                }
                GLCanvas.this.fixBounds();
            }
        });
    }

    void fixBounds() {
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        int n = OS.GetControlOwner(this.handle);
        int[] nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(n), OS.kHIViewWindowContentID(), nArray);
        CGPoint cGPoint = new CGPoint();
        OS.HIViewConvertPoint(cGPoint, OS.HIViewGetSuperview(this.handle), nArray[0]);
        rect.left = (short)(rect.left + (int)cGPoint.x);
        rect.top = (short)(rect.top + (int)cGPoint.y);
        rect.right = (short)(rect.right + (int)cGPoint.x);
        rect.bottom = (short)(rect.bottom + (int)cGPoint.y);
        short s = rect.left;
        short s2 = rect.top;
        int n2 = rect.right - rect.left;
        int n3 = rect.bottom - rect.top;
        int n4 = OS.GetWindowPort(n);
        OS.GetPortBounds(n4, rect);
        int[] nArray2 = new int[]{s, rect.bottom - rect.top - s2 - n3, n2, n3};
        AGL.aglSetInteger(this.context, 202, nArray2);
        AGL.aglEnable(this.context, 202);
        GCData gCData = new GCData();
        int n5 = this.internal_new_GC(gCData);
        AGL.aglSetInteger(this.context, 254, gCData.visibleRgn);
        AGL.aglEnable(this.context, 254);
        this.internal_dispose_GC(n5, gCData);
    }

    public GLData getGLData() {
        this.checkWidget();
        GLData gLData = new GLData();
        int[] nArray = new int[1];
        AGL.aglDescribePixelFormat(this.pixelFormat, 5, nArray);
        gLData.doubleBuffer = nArray[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 6, nArray);
        gLData.stereo = nArray[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 8, nArray);
        gLData.redSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 9, nArray);
        gLData.greenSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 10, nArray);
        gLData.blueSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 11, nArray);
        gLData.alphaSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 12, nArray);
        gLData.depthSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 13, nArray);
        gLData.stencilSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 14, nArray);
        gLData.accumRedSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 15, nArray);
        gLData.accumGreenSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 16, nArray);
        gLData.accumBlueSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 17, nArray);
        gLData.accumAlphaSize = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 55, nArray);
        gLData.sampleBuffers = nArray[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 56, nArray);
        gLData.samples = nArray[0];
        return gLData;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return AGL.aglGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (AGL.aglGetCurrentContext() != this.context) {
            AGL.aglSetCurrentContext(this.context);
        }
    }

    public void swapBuffers() {
        this.checkWidget();
        AGL.aglSwapBuffers(this.context);
    }
}

