/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;

final class OlePropertyChangeSink {
    private OleControlSite controlSite;
    private COMObject iUnknown;
    private COMObject iPropertyNotifySink;
    private int refCount;
    private int propertyCookie;
    private OleEventTable eventTable;

    OlePropertyChangeSink(OleControlSite oleControlSite) {
        this.controlSite = oleControlSite;
        this.createCOMInterfaces();
    }

    void addListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void connect(IUnknown iUnknown) {
        long[] lArray = new long[1];
        if (iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, lArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(lArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, lArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(lArray[0]);
                int[] nArray = new int[1];
                if (iConnectionPoint.Advise(this.iPropertyNotifySink.getAddress(), nArray) == 0) {
                    this.propertyCookie = nArray[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.iUnknown = new COMObject(nArray){

            public long method0(long[] lArray) {
                return OlePropertyChangeSink.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return OlePropertyChangeSink.this.AddRef();
            }

            public long method2(long[] lArray) {
                return OlePropertyChangeSink.this.Release();
            }
        };
        int[] nArray2 = new int[5];
        nArray2[0] = 2;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.iPropertyNotifySink = new COMObject(nArray2){

            public long method0(long[] lArray) {
                return OlePropertyChangeSink.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return OlePropertyChangeSink.this.AddRef();
            }

            public long method2(long[] lArray) {
                return OlePropertyChangeSink.this.Release();
            }

            public long method3(long[] lArray) {
                return OlePropertyChangeSink.this.OnChanged((int)lArray[0]);
            }

            public long method4(long[] lArray) {
                return OlePropertyChangeSink.this.OnRequestEdit((int)lArray[0]);
            }
        };
    }

    void disconnect(IUnknown iUnknown) {
        long[] lArray;
        if (this.propertyCookie != 0 && iUnknown != null && iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, lArray = new long[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(lArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, lArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(lArray[0]);
                if (iConnectionPoint.Unadvise(this.propertyCookie) == 0) {
                    this.propertyCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iPropertyNotifySink != null) {
            this.iPropertyNotifySink.dispose();
        }
        this.iPropertyNotifySink = null;
    }

    private void notifyListener(int n, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n;
        oleEvent.widget = this.controlSite;
        this.eventTable.sendEvent(oleEvent);
    }

    private int OnChanged(int n) {
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.detail = 1;
        this.notifyListener(n, oleEvent);
        return 0;
    }

    private int OnRequestEdit(int n) {
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.doit = true;
        oleEvent.detail = 0;
        this.notifyListener(n, oleEvent);
        return oleEvent.doit ? 0 : 1;
    }

    private int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.iUnknown.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIPropertyNotifySink)) {
            COM.MoveMemory(l2, new long[]{this.iPropertyNotifySink.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, oleListener);
    }
}

