/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class TrayDialog
extends Dialog {
    private static boolean dialogHelpAvailable;
    private DialogTray tray;
    private Control trayControl;
    private Label leftSeparator;
    private Label rightSeparator;
    private Sash sash;
    private boolean helpAvailable = TrayDialog.isDialogHelpAvailable();

    protected TrayDialog(Shell shell) {
        super(shell);
    }

    protected TrayDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public void closeTray() throws IllegalStateException {
        if (this.getTray() == null) {
            throw new IllegalStateException("Tray was not open");
        }
        int trayWidth = this.trayControl.getSize().x + this.leftSeparator.getSize().x + this.sash.getSize().x + this.rightSeparator.getSize().x;
        this.trayControl.dispose();
        this.trayControl = null;
        this.tray = null;
        this.leftSeparator.dispose();
        this.leftSeparator = null;
        this.rightSeparator.dispose();
        this.rightSeparator = null;
        this.sash.dispose();
        this.sash = null;
        Shell shell = this.getShell();
        Rectangle bounds = shell.getBounds();
        shell.setBounds(bounds.x + (TrayDialog.getDefaultOrientation() == 0x4000000 ? trayWidth : 0), bounds.y, bounds.width - trayWidth, bounds.height);
    }

    public boolean close() {
        if (this.getTray() != null) {
            this.closeTray();
        }
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setFont(parent.getFont());
        if (this.isHelpAvailable()) {
            Control helpControl = this.createHelpControl(composite);
            ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    protected Control createHelpControl(Composite parent) {
        Image helpImage = JFaceResources.getImage("dialog_help_image");
        if (helpImage != null) {
            return this.createHelpImageButton(parent, helpImage);
        }
        return this.createHelpLink(parent);
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)parent.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString("helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrayDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    private Link createHelpLink(Composite parent) {
        Link link = new Link(parent, 524352);
        ++((GridLayout)parent.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrayDialog.this.helpPressed();
            }
        });
        return link;
    }

    private boolean isCompatibleLayout(Layout layout) {
        if (layout != null && layout instanceof GridLayout) {
            GridLayout grid = (GridLayout)layout;
            return !grid.makeColumnsEqualWidth && grid.horizontalSpacing == 0 && grid.marginWidth == 0 && grid.marginHeight == 0 && grid.horizontalSpacing == 0 && grid.numColumns == 5;
        }
        return false;
    }

    public boolean isHelpAvailable() {
        return this.helpAvailable;
    }

    protected Layout getLayout() {
        GridLayout layout = (GridLayout)super.getLayout();
        layout.numColumns = 5;
        layout.horizontalSpacing = 0;
        return layout;
    }

    public DialogTray getTray() {
        return this.tray;
    }

    private void helpPressed() {
        if (this.getShell() != null) {
            Control c = this.getShell().getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        if (tray == null) {
            throw new NullPointerException("Tray was null");
        }
        if (this.getTray() != null) {
            throw new IllegalStateException("Tray was already open");
        }
        if (!this.isCompatibleLayout(this.getShell().getLayout())) {
            throw new UnsupportedOperationException("Trays not supported with custom layouts");
        }
        this.tray = tray;
        final Shell shell = this.getShell();
        this.leftSeparator = new Label((Composite)shell, 514);
        this.leftSeparator.setLayoutData((Object)new GridData(1040));
        this.sash = new Sash((Composite)shell, 512);
        this.sash.setLayoutData((Object)new GridData(1040));
        this.rightSeparator = new Label((Composite)shell, 514);
        this.rightSeparator.setLayoutData((Object)new GridData(1040));
        this.trayControl = tray.createContents((Composite)shell);
        Rectangle clientArea = shell.getClientArea();
        final GridData data = new GridData(1040);
        data.widthHint = this.trayControl.computeSize((int)-1, (int)clientArea.height).x;
        this.trayControl.setLayoutData((Object)data);
        int trayWidth = this.leftSeparator.computeSize((int)-1, (int)clientArea.height).x + this.sash.computeSize((int)-1, (int)clientArea.height).x + this.rightSeparator.computeSize((int)-1, (int)clientArea.height).x + data.widthHint;
        Rectangle bounds = shell.getBounds();
        shell.setBounds(bounds.x - (TrayDialog.getDefaultOrientation() == 0x4000000 ? trayWidth : 0), bounds.y, bounds.width + trayWidth, bounds.height);
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 1) {
                    Rectangle clientArea = shell.getClientArea();
                    int newWidth = clientArea.width - event.x - (((TrayDialog)TrayDialog.this).sash.getSize().x + ((TrayDialog)TrayDialog.this).rightSeparator.getSize().x);
                    if (newWidth != data.widthHint) {
                        data.widthHint = newWidth;
                        shell.layout();
                    }
                }
            }
        });
    }

    public void setHelpAvailable(boolean helpAvailable) {
        this.helpAvailable = helpAvailable;
    }

    public static boolean isDialogHelpAvailable() {
        return dialogHelpAvailable;
    }

    public static void setDialogHelpAvailable(boolean helpAvailable) {
        dialogHelpAvailable = helpAvailable;
    }
}

